/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity;

import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftSmart;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityJurassiCraftRidable
extends EntityJurassiCraftSmart {
    private float mountingSpeed;

    public EntityJurassiCraftRidable(World world) {
        super(world);
        this.setMountingSpeed((float)this.getCreature().getRidingSpeed());
    }

    public boolean isCreatureRidable() {
        return this.getCreature().isRidable();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            this.ridingPlayerRightClick();
        }
    }

    public void ridingPlayerRightClick() {
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack playerItemStack = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && this.checkRidingItem(playerItemStack)) {
            if (this.isCreatureRidable() && this.isTamed() && this.isCreatureAdult() && !this.isSitting() && !this.isSleeping() && !this.isAttacking() && !this.isDefending() && this.field_70153_n == null && player.func_70005_c_().equals(this.getOwnerName())) {
                this.setSitting(false, null);
                this.setRidingPlayer(player);
            } else if (!this.isCreatureRidable()) {
                if (this.func_94056_bM()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.riding.notRidable")));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.riding.notRidable")));
                }
            } else if (!this.isTamed()) {
                if (this.func_94056_bM()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.riding.notTamed")));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.riding.notTamed")));
                }
            } else if (!this.isCreatureAdult()) {
                if (this.func_94056_bM()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.riding.notAdult")));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.riding.notAdult")));
                }
            } else if (this.isSitting()) {
                if (this.func_94056_bM()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.riding.sitting")));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.riding.sitting")));
                }
            } else if (this.field_70153_n != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"entity.riding.isRiding")));
            }
        }
        return super.func_70085_c(player);
    }

    protected boolean checkRidingItem(ItemStack ridingItem) {
        return ridingItem != null && this.getCreature().isRidingItem(ridingItem.func_77973_b());
    }

    public float getMountingSpeed() {
        return this.mountingSpeed;
    }

    public void setMountingSpeed(float speed) {
        this.mountingSpeed = speed;
    }

    public void setRidingPlayer(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_70078_a((Entity)this);
    }

    protected void handleMouseControlledRiding() {
        this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
        this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    protected void handleFastItemControlledRiding() {
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        float adjust = MathHelper.func_76142_g((float)(((EntityLivingBase)this.field_70153_n).field_70177_z - this.field_70177_z)) * 0.5f;
        if (adjust > 6.0f) {
            adjust = 6.0f;
        } else if (adjust < -6.0f) {
            adjust = -6.0f;
        }
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + adjust));
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    protected void handleSlowItemControlledRiding() {
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        float adjust = MathHelper.func_76142_g((float)(((EntityLivingBase)this.field_70153_n).field_70177_z - this.field_70177_z)) * 0.5f;
        if (adjust > 2.0f) {
            adjust = 2.0f;
        } else if (adjust < -2.0f) {
            adjust = -2.0f;
        }
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + adjust));
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    protected void handleVerySlowItemControlledRiding() {
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        float adjust = MathHelper.func_76142_g((float)(((EntityLivingBase)this.field_70153_n).field_70177_z - this.field_70177_z)) * 0.5f;
        if (adjust > 0.8f) {
            adjust = 0.8f;
        } else if (adjust < -0.8f) {
            adjust = -0.8f;
        }
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + adjust));
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    protected void handleKeyboardControlledRiding(float adjustment) {
        float adjustPitch = 0.0f;
        float adjustYaw = 0.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
            adjustYaw += adjustment;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
            adjustYaw -= adjustment;
        }
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + adjustYaw));
        this.field_70125_A = MathHelper.func_76142_g((float)(this.field_70125_A + adjustPitch));
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    public void func_70612_e(float movementStrafing, float movementForward) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.checkRidingItem(((EntityPlayer)this.field_70153_n).func_70694_bm())) {
            EntityPlayer player = (EntityPlayer)this.field_70153_n;
            switch (this.getCreature().getRidingStyle()) {
                case 0: {
                    this.handleMouseControlledRiding();
                    break;
                }
                case 1: {
                    this.handleFastItemControlledRiding();
                    break;
                }
                case 2: {
                    this.handleSlowItemControlledRiding();
                    break;
                }
                case 3: {
                    this.handleVerySlowItemControlledRiding();
                    break;
                }
                default: {
                    this.handleSlowItemControlledRiding();
                }
            }
            this.field_70138_W = 1.0f;
            movementStrafing = 0.25f * player.field_70702_br * this.getMountingSpeed();
            movementForward = Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d() ? player.field_70701_bs * 0.3f * this.getMountingSpeed() : player.field_70701_bs * this.getMountingSpeed();
            if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && this.field_70122_E && !this.field_70703_bu && !this.field_70160_al) {
                this.decreaseHeldItemDurability(20);
                this.func_70664_aZ();
            }
            this.decreaseHeldItemDurability(1);
            if (!this.field_70170_p.field_72995_K) {
                super.func_70612_e(movementStrafing, movementForward);
            }
            this.handleLimbMovement();
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(movementStrafing, movementForward);
        }
    }

    protected void handleLimbMovement() {
        this.field_70722_aY = this.field_70721_aZ;
        double pointX = this.field_70165_t - this.field_70169_q;
        double pointZ = this.field_70161_v - this.field_70166_s;
        float distance = MathHelper.func_76133_a((double)(pointX * pointX + pointZ * pointZ)) * 4.0f;
        if (distance > 1.0f) {
            distance = 1.0f;
        }
        this.field_70721_aZ += (distance - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    protected void decreaseHeldItemDurability(int damage) {
        if (this.field_70153_n != null && ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77960_j() + damage > ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77958_k()) {
            --((EntityPlayer)this.field_70153_n).func_70694_bm().field_77994_a;
            if (((EntityPlayer)this.field_70153_n).func_70694_bm().field_77994_a <= 0) {
                ((EntityPlayer)this.field_70153_n).field_71071_by.func_70299_a(((EntityPlayer)this.field_70153_n).field_71071_by.field_70461_c, null);
            }
        } else {
            ((EntityPlayer)this.field_70153_n).func_70694_bm().func_77964_b(((EntityPlayer)this.field_70153_n).func_70694_bm().func_77960_j() + damage);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }
}

