/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftAggressive;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCoward;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCreature;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftProtective;
import net.ilexiconn.jurassicraft.common.entity.ai.JCPathNavigate;
import net.ilexiconn.jurassicraft.common.item.ItemDinoPad;
import net.ilexiconn.jurassicraft.common.item.ItemGrowthSerum;
import net.ilexiconn.jurassicraft.common.item.ItemOnAStick;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityJurassiCraftSmart
extends EntityJurassiCraftCreature
implements IEntityOwnable {
    public EntityLivingBase creatureToAttack;
    protected int angryTicks;
    protected int numberOfAllies = 0;

    public EntityJurassiCraftSmart(World world) {
        super(world);
        JCPathNavigate nav = new JCPathNavigate((EntityLiving)this, world);
        ObfuscationReflectionHelper.setPrivateValue(EntityLiving.class, (Object)this, (Object)((Object)nav), (int)6);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)"");
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack heldItemStack = player.func_70694_bm();
        if (heldItemStack != null) {
            if (!(heldItemStack.func_77973_b() instanceof ItemGrowthSerum || heldItemStack.func_77973_b() instanceof ItemDinoPad || heldItemStack.func_77973_b() instanceof ItemOnAStick)) {
                if (this.getCreature().isFavoriteFood(heldItemStack.func_77973_b())) {
                    boolean shouldDecreaceItemStack = false;
                    if ((double)(this.func_110143_aJ() + 3.0f) <= this.getCreatureHealth()) {
                        shouldDecreaceItemStack = true;
                        this.func_70691_i(3.0f);
                    }
                    if (!this.isTamed() && !this.field_70170_p.field_72995_K) {
                        shouldDecreaceItemStack = true;
                        if (this.field_70146_Z.nextInt(4) == 0) {
                            this.setTamed(true, player);
                        } else {
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    if (shouldDecreaceItemStack && !player.field_71075_bZ.field_75098_d) {
                        --heldItemStack.field_77994_a;
                        if (heldItemStack.field_77994_a <= 0) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        }
                    }
                } else if (this.isTamed() && this.isOwner((Entity)player) && !this.field_70170_p.field_72995_K) {
                    this.setSitting(!this.isSitting(), player);
                }
            }
        } else if (this.isTamed() && this.isOwner((Entity)player) && !this.field_70170_p.field_72995_K) {
            this.setSitting(!this.isSitting(), player);
        }
        return super.func_70085_c(player);
    }

    public int getStatus() {
        return this.field_70180_af.func_75679_c(15);
    }

    public void setStatus(int states) {
        this.field_70180_af.func_75692_b(15, (Object)states);
    }

    public boolean isTakingOff() {
        return (this.getStatus() & 4) == 4;
    }

    public void setTakingOff(boolean flag) {
        if (!(!flag || this.isSitting() || this.isSleeping() || this.func_70113_ah() || this.isDrinking() || this.isPlaying() || this.isBreeding() || this.isFlying())) {
            this.setStatus(this.getStatus() | 4);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFFFB);
        }
    }

    public void forceTakingOff(boolean flag) {
        this.setStatus(this.getStatus() & 0xFFFFFFF7);
        this.setStatus(this.getStatus() & 0xFFFFFFEF);
        this.setStatus(this.getStatus() & 0xFFFFFF7F);
        this.setStatus(this.getStatus() & 0xFFFFFEFF);
        this.setStatus(this.getStatus() & 0xFFFFFBFF);
        this.setStatus(this.getStatus() & 0xFFFFF7FF);
        this.setStatus(this.getStatus() & 0xFFFFFFFD);
        this.setStatus(this.getStatus() | 4);
    }

    public boolean isFlying() {
        return (this.getStatus() & 2) == 2;
    }

    public void setFlying(boolean flag) {
        if (!(!flag || this.isSitting() || this.isSleeping() || this.func_70113_ah() || this.isDrinking() || this.isPlaying() || this.isBreeding() || !this.isTakingOff())) {
            this.setStatus(this.getStatus() | 2);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFFFD);
        }
    }

    public void forceFlying(boolean flag) {
        this.setStatus(this.getStatus() & 0xFFFFFFF7);
        this.setStatus(this.getStatus() & 0xFFFFFFEF);
        this.setStatus(this.getStatus() & 0xFFFFFF7F);
        this.setStatus(this.getStatus() & 0xFFFFFEFF);
        this.setStatus(this.getStatus() & 0xFFFFFBFF);
        this.setStatus(this.getStatus() & 0xFFFFF7FF);
        this.setStatus(this.getStatus() & 0xFFFFFFFB);
        this.setStatus(this.getStatus() | 2);
    }

    public boolean isTamed() {
        return (this.getStatus() & 1) == 1;
    }

    public void setTamed(boolean flag, EntityPlayer player) {
        if (flag) {
            this.setStatus(this.getStatus() | 1);
            this.func_70624_b(null);
            this.func_70778_a(null);
            this.forceSitting(player);
            this.setOwner(player.func_70005_c_());
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            if (this.func_94056_bM()) {
                player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.interaction.tamed")));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.interaction.tamed")));
            }
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFFFE);
        }
    }

    public boolean isSitting() {
        return (this.getStatus() & 8) == 8;
    }

    public void setSitting(boolean flag, EntityPlayer player) {
        if (!(!flag || this.isDefending() || this.func_70113_ah() || this.isAttacking() || this.isDrinking() || this.isPlaying() || this.isBreeding() || this.isTakingOff() || this.isFlying())) {
            this.setStatus(this.getStatus() | 8);
            this.field_70703_bu = false;
            this.func_70778_a(null);
            this.func_70784_b(null);
            this.func_70624_b(null);
            this.handleSittingText(player);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFFF7);
            this.handleSittingText(player);
        }
    }

    public void forceSitting(EntityPlayer player) {
        this.setStatus(this.getStatus() & 0xFFFEFFFF);
        this.setStatus(this.getStatus() & 0xFFFDFFFF);
        this.setStatus(this.getStatus() & 0xFFFFFF7F);
        this.setStatus(this.getStatus() & 0xFFFFFEFF);
        this.setStatus(this.getStatus() & 0xFFFFFBFF);
        this.setStatus(this.getStatus() & 0xFFFFF7FF);
        this.setStatus(this.getStatus() & 0xFFFFFFFB);
        this.setStatus(this.getStatus() & 0xFFFFFFFD);
        this.setStatus(this.getStatus() | 8);
        this.field_70703_bu = false;
        this.func_70778_a(null);
        this.func_70784_b(null);
        this.func_70624_b(null);
        this.handleSittingText(player);
    }

    public void handleSittingText(EntityPlayer player) {
        if (player != null) {
            if (this.isSitting()) {
                if (this.func_94056_bM()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.interaction.isSitting")));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.interaction.isSitting")));
                }
            } else if (this.func_94056_bM()) {
                player.func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + ") " + StatCollector.func_74838_a((String)"entity.interaction.isNotSitting")));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("entity." + this.getCreature().getCreatureName() + ".name")) + " " + StatCollector.func_74838_a((String)"entity.interaction.isNotSitting")));
            }
        }
    }

    public boolean isSleeping() {
        return (this.getStatus() & 0x10) == 16;
    }

    public void setSleeping(boolean flag) {
        if (!(!flag || !this.isSitting() || this.isDefending() || this.isAttacking() || this.func_70113_ah() || this.isDrinking() || this.isPlaying() || this.isBreeding() || this.isTakingOff() || this.isFlying())) {
            this.setStatus(this.getStatus() | 0x10);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFFEF);
        }
    }

    public boolean isHungry() {
        return (this.getStatus() & 0x20) == 32;
    }

    public void setHunger(boolean flag) {
        if (flag) {
            this.setStatus(this.getStatus() | 0x20);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFFDF);
        }
    }

    public boolean func_70113_ah() {
        return (this.getStatus() & 0x80) == 128;
    }

    public void func_70019_c(boolean flag) {
        if (!(!flag || this.isSleeping() || this.isDefending() || this.isAttacking() || this.isSitting() || this.isDrinking() || this.isPlaying() || this.isBreeding() || this.isTakingOff() || this.isFlying())) {
            this.setStatus(this.getStatus() | 0x80);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFF7F);
        }
    }

    public boolean isThirsty() {
        return (this.getStatus() & 0x40) == 64;
    }

    public void setThirsty(boolean flag) {
        if (flag) {
            this.setStatus(this.getStatus() | 0x40);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFFBF);
        }
    }

    public boolean isDrinking() {
        return (this.getStatus() & 0x100) == 256;
    }

    public void setDrinking(boolean flag) {
        if (!(!flag || this.isSleeping() || this.isSitting() || this.isDefending() || this.isAttacking() || this.func_70113_ah() || this.isPlaying() || this.isBreeding() || this.isTakingOff() || this.isFlying())) {
            this.setStatus(this.getStatus() | 0x100);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFEFF);
        }
    }

    public boolean isInjured() {
        return (this.getStatus() & 0x8000) == 32768;
    }

    public void setInjured(boolean flag) {
        if (flag) {
            this.setStatus(this.getStatus() | 0x8000);
        } else {
            this.setStatus(this.getStatus() & 0xFFFF7FFF);
        }
    }

    public boolean isSocializing() {
        return (this.getStatus() & 0x200) == 512;
    }

    public void setSocializing(boolean flag) {
        if (!(!flag || this.isSleeping() || this.isDefending() || this.isAttacking() || this.isBreeding())) {
            this.setStatus(this.getStatus() | 0x200);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFDFF);
        }
    }

    public boolean isDefending() {
        return (this.getStatus() & 0x10000) == 65536;
    }

    public void setDefending(boolean flag) {
        if (flag && !this.isSleeping()) {
            this.setStatus(this.getStatus() | 0x10000);
        } else {
            this.setStatus(this.getStatus() & 0xFFFEFFFF);
        }
    }

    public int getNumberOfAllies() {
        return this.numberOfAllies;
    }

    public void setNumberOfAllies(int numberOfAllies) {
        this.numberOfAllies = numberOfAllies;
    }

    public boolean isAttacking() {
        return (this.getStatus() & 0x20000) == 131072;
    }

    public void setAttacking(boolean flag) {
        if (flag && !this.isSleeping()) {
            this.setStatus(this.getStatus() | 0x20000);
        } else {
            this.setStatus(this.getStatus() & 0xFFFDFFFF);
        }
    }

    public boolean isAngry() {
        return (this.getStatus() & 0x40000) == 262144;
    }

    public void setAngry(boolean flag) {
        if (flag && !this.isSleeping() && !this.isFleeing()) {
            this.setStatus(this.getStatus() | 0x40000);
        } else {
            this.setStatus(this.getStatus() & 0xFFFBFFFF);
        }
    }

    public int getAngerLevel() {
        return this.angryTicks;
    }

    public void setAngerLevel(int angryTicks) {
        this.angryTicks = angryTicks;
    }

    protected void setCreatureAngry(EntityJurassiCraftAggressive creature, Entity attacker) {
        if (attacker instanceof EntityLivingBase) {
            creature.becomeAngry((EntityLivingBase)attacker, 0.0f);
        }
    }

    protected void becomeAngry(EntityLivingBase target, float agePercentage) {
        if (this.isCreatureOlderThan(agePercentage)) {
            if (this.isTamed()) {
                if (this.checkTargetBeforeAttacking(target)) {
                    if (this.isSitting()) {
                        this.setSitting(false, null);
                    }
                    this.func_70624_b(target);
                    this.setAngry(true);
                }
            } else {
                if (this.isSitting()) {
                    this.setSitting(false, null);
                }
                this.func_70624_b(target);
                this.setAngry(true);
            }
        }
    }

    public boolean isFleeing() {
        return (this.getStatus() & 0x4000) == 16384;
    }

    public void setFleeing(boolean flag) {
        if (flag && !this.isSleeping()) {
            this.setStatus(this.getStatus() | 0x4000);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFBFFF);
        }
    }

    public int getFleeingTick() {
        return this.field_70788_c;
    }

    public void setFleeingTick(int value) {
        this.field_70788_c = value;
    }

    protected void startFleeing() {
        if (this.isSitting()) {
            this.setSitting(false, null);
        }
        this.func_70624_b(null);
        this.setFleeing(true);
    }

    public boolean hasBeenHurt() {
        return this.field_70737_aN > 0;
    }

    public boolean isPlaying() {
        return (this.getStatus() & 0x400) == 1024;
    }

    public void setPlaying(boolean flag) {
        if (!(!flag || this.isSleeping() || this.func_70113_ah() || this.isDrinking() || this.isDefending() || this.isAttacking() || this.isTakingOff())) {
            this.setStatus(this.getStatus() | 0x400);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFFBFF);
        }
    }

    public boolean isStalking() {
        return (this.getStatus() & 0x2000) == 8192;
    }

    public void setStalking(boolean flag) {
        if (!(!flag || this.isSitting() || this.isSleeping() || this.func_70113_ah() || this.isDrinking() || this.isDefending() || this.isTakingOff() || this.isFlying())) {
            this.setStatus(this.getStatus() | 0x2000);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFDFFF);
        }
    }

    public boolean isBreeding() {
        return (this.getStatus() & 0x800) == 2048;
    }

    public void setBreeding(boolean flag) {
        if (!(!flag || this.isSitting() || this.isSleeping() || this.isDefending() || this.isAttacking() || this.func_70113_ah() || this.isDrinking() || this.isTakingOff() || this.isFlying())) {
            this.setStatus(this.getStatus() | 0x800);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFF7FF);
        }
    }

    public boolean isInLove() {
        return (this.getStatus() & 0x1000) == 4096;
    }

    public void setInLove(boolean flag) {
        if (flag && !this.isSleeping()) {
            this.setStatus(this.getStatus() | 0x1000);
        } else {
            this.setStatus(this.getStatus() & 0xFFFFEFFF);
        }
    }

    public boolean canBeTamedUponSpawning() {
        return this.getCreature().canBeTamedUponSpawning();
    }

    public void clearStatus() {
        this.setStatus(this.getStatus() & 0xFFFFFFF7);
        this.setStatus(this.getStatus() & 0xFFFFFFEF);
        this.setStatus(this.getStatus() & 0xFFFFFFDF);
        this.setStatus(this.getStatus() & 0xFFFFFFBF);
        this.setStatus(this.getStatus() & 0xFFFFFF7F);
        this.setStatus(this.getStatus() & 0xFFFFFEFF);
        this.setStatus(this.getStatus() & 0xFFFFFDFF);
        this.setStatus(this.getStatus() & 0xFFFEFFFF);
        this.setStatus(this.getStatus() & 0xFFFDFFFF);
        this.setStatus(this.getStatus() & 0xFFFFBFFF);
        this.setStatus(this.getStatus() & 0xFFFFFBFF);
        this.setStatus(this.getStatus() & 0xFFFFDFFF);
        this.setStatus(this.getStatus() & 0xFFFFEFFF);
    }

    public EntityJurassiCraftAggressive getClosestEntityAggressive(EntityLivingBase creature, double x, double y, double z) {
        List list = creature.field_70170_p.func_72839_b((Entity)creature, creature.field_70121_D.func_72314_b(x, y, z));
        ArrayList<EntityJurassiCraftAggressive> listOfTargets = new ArrayList<EntityJurassiCraftAggressive>();
        for (Entity entity : list) {
            if (!(entity instanceof EntityJurassiCraftAggressive)) continue;
            listOfTargets.add((EntityJurassiCraftAggressive)entity);
        }
        if (!listOfTargets.isEmpty()) {
            EntityJurassiCraftAggressive closestAggressive = null;
            double distanceSq = x * x + y * y + z * z;
            for (EntityJurassiCraftAggressive closeTarget : listOfTargets) {
                double nextDistance = creature.func_70068_e((Entity)closeTarget);
                if (!(nextDistance < distanceSq)) continue;
                distanceSq = nextDistance;
                closestAggressive = closeTarget;
            }
            return closestAggressive;
        }
        return null;
    }

    public ArrayList<EntityJurassiCraftAggressive> getClosestEntityAggressiveList(EntityLivingBase creature, double x, double y, double z) {
        List list = creature.field_70170_p.func_72839_b((Entity)creature, creature.field_70121_D.func_72314_b(x, y, z));
        ArrayList<EntityJurassiCraftAggressive> listOfTargets = new ArrayList<EntityJurassiCraftAggressive>();
        for (Entity entity : list) {
            if (!(entity instanceof EntityJurassiCraftAggressive)) continue;
            listOfTargets.add((EntityJurassiCraftAggressive)entity);
        }
        return listOfTargets;
    }

    public EntityJurassiCraftProtective getClosestEntityProtective(EntityLivingBase creature, double x, double y, double z) {
        List list = creature.field_70170_p.func_72839_b((Entity)creature, creature.field_70121_D.func_72314_b(x, y, z));
        ArrayList<EntityJurassiCraftProtective> listOfTargets = new ArrayList<EntityJurassiCraftProtective>();
        for (Entity entity : list) {
            if (!(entity instanceof EntityJurassiCraftProtective)) continue;
            listOfTargets.add((EntityJurassiCraftProtective)entity);
        }
        if (!listOfTargets.isEmpty()) {
            EntityJurassiCraftProtective closestProtective = null;
            double distanceSq = x * x + y * y + z * z;
            for (EntityJurassiCraftProtective closeTarget : listOfTargets) {
                double nextDistance = creature.func_70068_e((Entity)closeTarget);
                if (!(nextDistance < distanceSq)) continue;
                distanceSq = nextDistance;
                closestProtective = closeTarget;
            }
            return closestProtective;
        }
        return null;
    }

    public ArrayList<EntityJurassiCraftProtective> getClosestEntityProtectiveList(EntityLivingBase creature, double x, double y, double z) {
        List list = creature.field_70170_p.func_72839_b((Entity)creature, creature.field_70121_D.func_72314_b(x, y, z));
        ArrayList<EntityJurassiCraftProtective> listOfTargets = new ArrayList<EntityJurassiCraftProtective>();
        System.out.println("list " + list);
        for (Entity entity : list) {
            if (!(entity instanceof EntityJurassiCraftProtective)) continue;
            listOfTargets.add((EntityJurassiCraftProtective)entity);
        }
        return listOfTargets;
    }

    public EntityJurassiCraftCoward getClosestEntityCoward(EntityLivingBase creature, double x, double y, double z) {
        List list = creature.field_70170_p.func_72839_b((Entity)creature, creature.field_70121_D.func_72314_b(x, y, z));
        ArrayList<EntityJurassiCraftCoward> listOfTargets = new ArrayList<EntityJurassiCraftCoward>();
        for (Entity entity : list) {
            if (!(entity instanceof EntityJurassiCraftCoward)) continue;
            listOfTargets.add((EntityJurassiCraftCoward)entity);
        }
        if (!listOfTargets.isEmpty()) {
            EntityJurassiCraftCoward closestCoward = null;
            double distanceSq = x * x + y * y + z * z;
            for (EntityJurassiCraftCoward closeTarget : listOfTargets) {
                double nextDistance = creature.func_70068_e((Entity)closeTarget);
                if (!(nextDistance < distanceSq)) continue;
                distanceSq = nextDistance;
                closestCoward = closeTarget;
            }
            return closestCoward;
        }
        return null;
    }

    public ArrayList<EntityJurassiCraftCoward> getClosestEntityCowardList(EntityLivingBase creature, double x, double y, double z) {
        List list = creature.field_70170_p.func_72839_b((Entity)creature, creature.field_70121_D.func_72314_b(x, y, z));
        ArrayList<EntityJurassiCraftCoward> listOfTargets = new ArrayList<EntityJurassiCraftCoward>();
        for (Entity entity : list) {
            if (!(entity instanceof EntityJurassiCraftCoward)) continue;
            listOfTargets.add((EntityJurassiCraftCoward)entity);
        }
        return listOfTargets;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte flag) {
        if (flag == 7) {
            this.playTameEffect(true);
        } else if (flag == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(flag);
        }
    }

    protected void playTameEffect(boolean flag) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(flag ? "heart" : "smoke", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(16);
    }

    public boolean isOwner(Entity possibleOwner) {
        return possibleOwner == this.getOwner();
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.isTamed() && !this.isTakingOff() && !this.isFlying();
    }

    public EntityLivingBase getOwner() {
        return this.field_70170_p.func_72924_a(this.getOwnerName());
    }

    public void setOwner(String owner) {
        this.field_70180_af.func_75692_b(16, (Object)owner);
    }

    public Team func_96124_cp() {
        EntityLivingBase owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_142014_c(EntityLivingBase creature) {
        if (this.isTamed()) {
            EntityLivingBase owner = this.getOwner();
            if (creature == owner) {
                return true;
            }
            if (owner != null) {
                return owner.func_142014_c(creature);
            }
        }
        return super.func_142014_c(creature);
    }

    public String func_152113_b() {
        return null;
    }

    public boolean checkTargetBeforeAttacking(EntityLivingBase target) {
        if (target.field_70153_n == this || this.field_70153_n == target || target.field_70154_o != null) {
            return false;
        }
        if (target == null || target == this || target == this.getOwner()) {
            if (target instanceof EntityJurassiCraftSmart) {
                return !this.isOwner((Entity)((EntityJurassiCraftSmart)target).getOwner());
            }
            return true;
        }
        return false;
    }

    public EntityLivingBase getCreatureToAttack() {
        return this.creatureToAttack;
    }

    public void setCreatureToAttack(EntityLivingBase creature) {
        if (creature != this) {
            this.creatureToAttack = creature;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Status", this.getStatus());
        compound.func_74768_a("FleeingTick", this.getFleeingTick());
        compound.func_74768_a("AngerLevel", this.getAngerLevel());
        if (this.getOwnerName() != null) {
            compound.func_74778_a("Owner", this.getOwnerName());
        } else {
            compound.func_74778_a("Owner", "");
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Status")) {
            this.setStatus(compound.func_74762_e("Status"));
        }
        if (compound.func_74764_b("FleeingTick")) {
            this.setFleeingTick(compound.func_74762_e("FleeingTick"));
        }
        if (compound.func_74764_b("AngerLevel")) {
            this.setAngerLevel(compound.func_74762_e("AngerLevel"));
        }
        if (compound.func_74764_b("Owner")) {
            String ownerName = compound.func_74779_i("Owner");
            if (ownerName != null && ownerName.length() > 0) {
                this.setOwner(ownerName);
            }
        } else {
            this.setOwner("");
        }
    }
}

