/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.model.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.ilexiconn.jurassicraft.client.model.base.MowzieModelRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public class MowzieModelBase
extends ModelBase {
    protected MowzieModelRenderer[] parts;

    protected void setInitPose() {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].setInitValuesToCurrentPose();
        }
    }

    protected void setToInitPose() {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].setCurrentPoseToInitValues();
        }
    }

    protected void addChildTo(ModelRenderer child, ModelRenderer parent) {
        float distance = (float)Math.sqrt(Math.pow(child.field_78798_e - parent.field_78798_e, 2.0) + Math.pow(child.field_78797_d - parent.field_78797_d, 2.0));
        float oldRotateAngleX = parent.field_78795_f;
        float parentToChildAngle = (float)Math.atan((child.field_78798_e - parent.field_78798_e) / (child.field_78797_d - parent.field_78797_d));
        float childRelativeRotation = parentToChildAngle - parent.field_78795_f;
        float newRotationPointY = (float)((double)distance * Math.cos(childRelativeRotation));
        float newRotationPointZ = (float)((double)distance * Math.sin(childRelativeRotation));
        parent.field_78795_f = 0.0f;
        child.func_78793_a(child.field_78800_c - parent.field_78800_c, newRotationPointY, newRotationPointZ);
        parent.func_78792_a(child);
        parent.field_78795_f = oldRotateAngleX;
        child.field_78795_f -= parent.field_78795_f;
        child.field_78796_g -= parent.field_78796_g;
        child.field_78808_h -= parent.field_78808_h;
    }

    protected void newAddChildTo(ModelRenderer child, ModelRenderer parent) {
        float distance = (float)Math.sqrt(Math.pow(child.field_78798_e - parent.field_78798_e, 2.0) + Math.pow(child.field_78797_d - parent.field_78797_d, 2.0));
        float angle = (float)Math.atan2(child.field_78797_d - parent.field_78797_d, child.field_78798_e - parent.field_78798_e);
        float newRotationPointZ = (float)((double)distance * Math.cos(angle));
        float newRotationPointY = (float)((double)distance * Math.sin(angle));
        parent.func_78792_a(child);
        child.field_78795_f -= parent.field_78795_f;
        child.field_78796_g -= parent.field_78796_g;
        child.field_78808_h -= parent.field_78808_h;
    }

    public void faceTarget(MowzieModelRenderer box, float f, float f3, float f4) {
        box.field_78796_g += f3 / 57.295776f / f;
        box.field_78795_f += f4 / 57.295776f / f;
    }

    public float rotateBox(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        if (invert) {
            return -MathHelper.func_76134_b((float)(f * speed + offset)) * degree * f1 + weight * f1;
        }
        return MathHelper.func_76134_b((float)(f * speed + offset)) * degree * f1 + weight * f1;
    }

    public float moveBox(float speed, float degree, boolean bounce, float f, float f1) {
        if (bounce) {
            return -MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)(f * speed)) * f1 * degree));
        }
        return MathHelper.func_76126_a((float)(f * speed)) * f1 * degree - f1 * degree;
    }

    public void walk(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78795_f += MathHelper.func_76134_b((float)(f * speed + offset)) * degree * (float)inverted * f1 + weight * f1;
    }

    public void flap(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78808_h += MathHelper.func_76134_b((float)(f * speed + offset)) * degree * (float)inverted * f1 + weight * f1;
    }

    public void bob(MowzieModelRenderer box, float speed, float degree, boolean bounce, float f, float f1) {
        float bob = (float)(Math.sin(f * speed) * (double)f1 * (double)degree - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        box.field_78797_d += bob;
    }

    public void chainSwing(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78796_g += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }

    public void chainWave(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78795_f += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }
}

