/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai;

import java.util.ArrayList;
import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCoward;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftSmart;
import net.ilexiconn.jurassicraft.common.handler.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;

public class JurassiCraftAIPlayfulBaby
extends EntityAIBase {
    private EntityJurassiCraftSmart creature;
    private EntityJurassiCraftSmart otherCreature;
    private double minimumDistance;
    private double maximumDistance;
    private int chance;
    private float maxAge;

    public JurassiCraftAIPlayfulBaby(EntityJurassiCraftSmart creature, int chance, double minimumDistance, double maximumDistance, float maxAge) {
        this.creature = creature;
        this.chance = chance;
        this.minimumDistance = minimumDistance * minimumDistance;
        this.maximumDistance = maximumDistance * maximumDistance;
        this.maxAge = maxAge;
        this.otherCreature = null;
    }

    public boolean func_75250_a() {
        if (this.creature.func_70681_au().nextInt(this.chance) > 0 || this.creature.isCreatureOlderThan(this.maxAge) || this.creature.isPlaying() || this.creature.isSocializing() || this.creature.getAnimationId() != 0 || this.creature.isSitting() || this.creature.isSleeping() || this.creature.isFleeing() || this.creature.func_70113_ah() || this.creature.isDrinking() || this.creature.isAttacking() || this.creature.isDefending()) {
            return false;
        }
        System.out.println("Searching!");
        double searchDistance = Math.sqrt(this.maximumDistance);
        ArrayList<EntityJurassiCraftCoward> closeCowardList = this.creature.getClosestEntityCowardList((EntityLivingBase)this.creature, searchDistance, searchDistance / 2.0, searchDistance);
        if (!closeCowardList.isEmpty()) {
            for (EntityJurassiCraftCoward entity : closeCowardList) {
                double distance;
                if (entity == null || entity.getClass() != this.creature.getClass() || entity == this.creature || !((distance = this.creature.func_70068_e((Entity)entity)) >= this.minimumDistance) || !(distance <= this.maximumDistance)) continue;
                this.otherCreature = entity;
                return !this.otherCreature.isCreatureOlderThan(this.maxAge) && !this.otherCreature.isPlaying() && this.otherCreature.getAnimationId() == 0 && !this.otherCreature.isSocializing() && !this.otherCreature.isSitting() && !this.otherCreature.isSleeping() && !this.otherCreature.isFleeing() && !this.otherCreature.func_70113_ah() && !this.otherCreature.isDrinking() && !this.otherCreature.isAttacking() && !this.otherCreature.isDefending();
            }
        }
        return false;
    }

    public void func_75249_e() {
        if (this.creature.isTakingOff()) {
            this.creature.setTakingOff(false);
        }
        if (this.creature.isFlying()) {
            this.creature.setFlying(false);
        }
        if (this.creature.isDefending()) {
            this.creature.setDefending(false);
        }
        if (this.creature.isAttacking()) {
            this.creature.setAttacking(false);
        }
        if (this.creature.isFleeing()) {
            this.creature.setFleeing(false);
        }
        if (this.creature.func_70113_ah()) {
            this.creature.func_70019_c(false);
        }
        if (this.creature.isDrinking()) {
            this.creature.setDrinking(false);
        }
        if (this.creature.isSleeping()) {
            this.creature.setSleeping(false);
        }
        if (this.creature.isBreeding()) {
            this.creature.setBreeding(false);
        }
        if (this.creature.isSitting()) {
            this.creature.setSitting(false, null);
        }
        if (this.otherCreature.isTakingOff()) {
            this.otherCreature.setTakingOff(false);
        }
        if (this.otherCreature.isFlying()) {
            this.otherCreature.setFlying(false);
        }
        if (this.otherCreature.isDefending()) {
            this.otherCreature.setDefending(false);
        }
        if (this.otherCreature.isAttacking()) {
            this.otherCreature.setAttacking(false);
        }
        if (this.otherCreature.isFleeing()) {
            this.otherCreature.setFleeing(false);
        }
        if (this.otherCreature.func_70113_ah()) {
            this.otherCreature.func_70019_c(false);
        }
        if (this.otherCreature.isDrinking()) {
            this.otherCreature.setDrinking(false);
        }
        if (this.otherCreature.isSleeping()) {
            this.otherCreature.setSleeping(false);
        }
        if (this.otherCreature.isBreeding()) {
            this.otherCreature.setBreeding(false);
        }
        if (this.otherCreature.isSitting()) {
            this.otherCreature.setSitting(false, null);
        }
        this.otherCreature.setSocializing(true);
        this.creature.setPlaying(true);
    }

    public void func_75246_d() {
        if (!this.creature.func_70781_l()) {
            this.creature.func_70661_as().func_75497_a((Entity)this.otherCreature, this.creature.getCreatureSpeed());
        }
    }

    public boolean func_75253_b() {
        return this.creature.func_70681_au().nextBoolean() ? true : this.creature.func_70068_e((Entity)this.otherCreature) > this.minimumDistance;
    }

    public void func_75251_c() {
        if (this.creature.getAnimationId() == 0) {
            AnimationHandler.sendAnimationPacket(this.creature, JurassiCraftAnimationIDs.PLAYING.animID());
        }
        this.creature.func_70661_as().func_75499_g();
        this.creature.setCreatureToAttack((EntityLivingBase)this.otherCreature);
        this.creature.setPlaying(false);
        if (this.otherCreature.getAnimationId() == 0) {
            AnimationHandler.sendAnimationPacket(this.otherCreature, JurassiCraftAnimationIDs.SOCIALIZING.animID());
        }
        this.otherCreature.func_70661_as().func_75499_g();
        this.otherCreature.setCreatureToAttack((EntityLivingBase)this.creature);
        this.otherCreature.setSocializing(false);
        this.otherCreature = null;
    }
}

