/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.render;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    private static RenderUtils instance = new RenderUtils();

    public static RenderUtils instance() {
        return instance;
    }

    public void setRenderBounds(RenderBlocks renderer, double par1, double par3, double par5, double par7, double par9, double par11) {
        if (!renderer.field_147847_n) {
            renderer.field_147859_h = par1;
            renderer.field_147861_i = par7;
            renderer.field_147855_j = par3;
            renderer.field_147857_k = par9;
            renderer.field_147851_l = par5;
            renderer.field_147853_m = par11;
            renderer.field_147849_o = renderer.field_147877_p.field_71474_y.field_74348_k >= 2 && (renderer.field_147859_h > 0.0 || renderer.field_147861_i < 1.0 || renderer.field_147855_j > 0.0 || renderer.field_147857_k < 1.0 || renderer.field_147851_l > 0.0 || renderer.field_147853_m < 1.0);
        }
    }

    public void renderBlock(Type type, RenderBlocks renderer, RenderData data) {
        if (type == Type.WORLD && data.x != -300000000) {
            this.renderWorldBlock(renderer, data.block, data.x, data.y, data.z);
        } else if (type == Type.INVENTORY && data.x == -300000000) {
            this.renderInvBlock(renderer, data.block, data.metadata);
        }
    }

    public void renderInvBlock(RenderBlocks renderer, Block block, int metadata) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(RenderBlocks renderer, Block par1Block, int par2, int par3, int par4) {
        return renderer.func_147784_q(par1Block, par2, par3, par4);
    }

    public boolean renderWorldCrossedSquares(RenderBlocks renderer, IBlockAccess world, Block par1Block, int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(par1Block.func_149677_c(world, x, y, z));
        float f = 1.0f;
        int l = par1Block.func_149720_d(world, x, y, z);
        float f1 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.func_78386_a(f * f1, f * f2, f * f3);
        double d0 = x;
        double d1 = y;
        double d2 = z;
        this.drawCrossedSquares(renderer, world, par1Block, x, y, z, d0, d1, d2, 1.0f);
        return true;
    }

    private void drawCrossedSquares(RenderBlocks renderer, IBlockAccess world, Block block, int x, int y, int z, double par3, double par5, double par7, float par9) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = renderer.func_147793_a(block, world, x, y, z, 0);
        if (renderer.func_147744_b()) {
            icon = renderer.field_147840_d;
        }
        double minU = icon.func_94209_e();
        double minV = icon.func_94206_g();
        double maxU = icon.func_94212_f();
        double maxV = icon.func_94210_h();
        double d7 = 0.45 * (double)par9;
        double d8 = par3 + 0.5 - d7;
        double d9 = par3 + 0.5 + d7;
        double d10 = par7 + 0.5 - d7;
        double d11 = par7 + 0.5 + d7;
        tessellator.func_78374_a(d8, par5 + (double)par9, d10, minU, minV);
        tessellator.func_78374_a(d8, par5 + 0.0, d10, minU, maxV);
        tessellator.func_78374_a(d9, par5 + 0.0, d11, maxU, maxV);
        tessellator.func_78374_a(d9, par5 + (double)par9, d11, maxU, minV);
        tessellator.func_78374_a(d9, par5 + (double)par9, d11, minU, minV);
        tessellator.func_78374_a(d9, par5 + 0.0, d11, minU, maxV);
        tessellator.func_78374_a(d8, par5 + 0.0, d10, maxU, maxV);
        tessellator.func_78374_a(d8, par5 + (double)par9, d10, maxU, minV);
        tessellator.func_78374_a(d8, par5 + (double)par9, d11, minU, minV);
        tessellator.func_78374_a(d8, par5 + 0.0, d11, minU, maxV);
        tessellator.func_78374_a(d9, par5 + 0.0, d10, maxU, maxV);
        tessellator.func_78374_a(d9, par5 + (double)par9, d10, maxU, minV);
        tessellator.func_78374_a(d9, par5 + (double)par9, d10, minU, minV);
        tessellator.func_78374_a(d9, par5 + 0.0, d10, minU, maxV);
        tessellator.func_78374_a(d8, par5 + 0.0, d11, maxU, maxV);
        tessellator.func_78374_a(d8, par5 + (double)par9, d11, maxU, minV);
    }

    public static class RenderData {
        int x;
        int y;
        int z = -300000000;
        int metadata = 0;
        Block block;

        public RenderData(IBlockAccess world, Block block, int x, int y, int z) {
            this(block, world.func_72805_g(x, y, z));
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public RenderData(Block block, int metadata) {
            this.metadata = metadata;
            this.block = block;
        }
    }

    public static enum Type {
        WORLD,
        INVENTORY;

    }
}

