/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.dinosaurs;

import net.ilexiconn.jurassicraft.client.model.base.ControlledParam;
import net.ilexiconn.jurassicraft.common.api.IHerbivore;
import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.ChainBuffer;
import net.ilexiconn.jurassicraft.common.entity.ControlledAnimation;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftAggressive;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCharges;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIAngry;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIDefensiveReaction;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEatDroppedFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEating;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFlee;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFollowFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIHerdBehavior;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerHurtsTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerIsHurtByTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAISit;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIWander;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIFollowHerd;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityTyrannosaurus;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTriceratops
extends EntityJurassiCraftCharges
implements IHerbivore {
    public ControlledParam flailDegree = new ControlledParam(0.0f, 0.0f, 1.0f, 0.0f);
    public ControlledAnimation defendingPosition = new ControlledAnimation(40);
    public ChainBuffer tailBuffer = new ChainBuffer(5);

    public EntityTriceratops(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JurassiCraftAIAngry(this, 200));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JurassiCraftAIFlee(this, 60, 1.1 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JurassiCraftAIWander(this, 45, 0.8 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new JurassiCraftAISit(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, (double)1.1f * this.getCreatureSpeed(), false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAIDefensiveReaction(this, 16.0, 36.0, true, JurassiCraftAnimationIDs.CHARGE.animID(), true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new JurassiCraftAIEating(this, 20));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIFollowFood(this, 50, 1.1 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIEatDroppedFood(this, 16.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTyrannosaurus.class, 12.0f, this.getCreatureSpeed(), 1.2 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new JurassiCraftAIHerdBehavior(this, 96.0, 2000, 20.0, 0.7 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new HerdAIFollowHerd(this, false, this.getCreatureSpeed()));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new JurassiCraftAIOwnerIsHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new JurassiCraftAIOwnerHurtsTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.setCreatureExperiencePoints(3500);
    }

    public double func_70042_X() {
        if (this.getAnimationId() == JurassiCraftAnimationIDs.CHARGE.animID()) {
            if (this.getAnimationTick() < 5) {
                float animationProgress = (float)this.getAnimationTick() / 5.0f;
                return 0.91 * (double)this.getYBouningBox() - (double)(0.3f * MathHelper.func_76126_a((float)animationProgress));
            }
            if (this.getAnimationTick() < 18) {
                float animationProgress = (float)(this.getAnimationTick() - 5) / 13.0f;
                return 0.91 * (double)this.getYBouningBox() + (double)(0.6f * MathHelper.func_76126_a((float)animationProgress));
            }
            if (this.getAnimationTick() < 39) {
                float animationProgress = (float)(this.getAnimationTick() - 18) / 21.0f;
                return 0.91 * (double)this.getYBouningBox() - (double)(0.5f * MathHelper.func_76126_a((float)animationProgress));
            }
        }
        return 0.91 * (double)this.getYBouningBox();
    }

    @Override
    public int getNumberOfAllies() {
        return 1;
    }

    @Override
    public int func_70627_aG() {
        return 350;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.flailDegree.update();
        if (this.animID == JurassiCraftAnimationIDs.CHARGE.animID() && this.animTick == 1) {
            this.flailDegree.thereAndBack(0.0f, 0.1f, 1.0f, 5);
        }
        if (this.isDefending()) {
            this.defendingPosition.increaseTimer();
            if (this.creatureToAttack != null) {
                this.field_70761_aq = this.field_70177_z = this.creatureToAttack.field_70177_z + (float)Math.PI;
            }
        } else {
            this.defendingPosition.decreaseTimer(2);
            if (this.field_70146_Z.nextInt(40) == 0 && this.isCreatureOlderThan(0.6f)) {
                this.creatureToAttack = this.getClosestEntityAggressive((EntityLivingBase)this, 20.0, 8.0, 20.0);
                if (this.creatureToAttack != null) {
                    this.setDefending(((EntityJurassiCraftAggressive)this.creatureToAttack).isCreatureOlderThan(0.5f));
                }
            }
        }
        this.tailBuffer.calculateChainSwingBuffer(40.0f, 5, 3.0f, (EntityLivingBase)this);
    }

    @Override
    protected void func_70628_a(boolean recentlyBeenHit, int enchantBonus) {
        float developmentFraction = (float)this.getGrowthStage() / 120.0f;
        int count = Math.round(1.0f + 4.0f * developmentFraction + (float)this.field_70146_Z.nextInt(1 + (int)(4.0f * developmentFraction)) + (float)this.field_70146_Z.nextInt(1 + enchantBonus));
        if (!this.func_70027_ad()) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getMeat(), count));
        } else {
            this.func_145779_a((Item)this.getCreature().getSteak(), count);
        }
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getSkull()));
        }
        if (this.isMale() && this.field_70146_Z.nextFloat() < 0.25f) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getSkin()));
        }
    }
}

