/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.egg;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.ilexiconn.jurassicraft.JurassiCraft;
import net.ilexiconn.jurassicraft.common.entity.Creature;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCreature;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftSmart;
import net.ilexiconn.jurassicraft.common.entity.egg.EggEnviroment;
import net.ilexiconn.jurassicraft.common.handler.CreatureHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityDinoEgg
extends Entity
implements IEntityAdditionalSpawnData {
    public Creature creature;
    public int quality;
    public int currentSpawnTime;
    public int spawnTime;
    public int rockAmount;
    public boolean froze;
    public boolean dried;

    public EntityDinoEgg(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70138_W = 1.0f;
    }

    public EntityDinoEgg(World world, Creature creature, int spawnTime) {
        this(world);
        this.creature = creature;
        this.spawnTime = spawnTime;
    }

    public EntityDinoEgg(World world, Creature creature, int quality, String dna, int spawnTime, double x, double y, double z) {
        this(world, creature, spawnTime);
        this.func_70107_b(x + 0.5, y, z + 0.5);
        this.quality = quality;
        this.setDNASequence(dna);
    }

    public void setCreature(Creature creature) {
        this.creature = creature;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getDNAQuality() {
        return this.quality;
    }

    public String getDNASequence() {
        return this.field_70180_af.func_75681_e(24);
    }

    public void setDNASequence(String dna) {
        this.field_70180_af.func_75692_b(24, (Object)String.valueOf(dna));
    }

    public void setCurrentSpawnTime(int currentSpawnTime) {
        this.currentSpawnTime = currentSpawnTime;
    }

    public void setSpawnTime(int spawnTime) {
        this.spawnTime = spawnTime;
    }

    public boolean func_70097_a(DamageSource damage, float amount) {
        if (!this.func_85032_ar()) {
            this.func_70106_y();
        }
        return super.func_70097_a(damage, amount);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70128_L) {
            if (this.field_70170_p.field_72995_K) {
                this.froze = this.field_70180_af.func_75679_c(25) != 0;
                this.dried = this.field_70180_af.func_75679_c(26) != 0;
                this.currentSpawnTime = this.field_70180_af.func_75679_c(27);
            }
            if (!this.field_70122_E) {
                this.field_70181_x -= (double)0.05f;
            }
            if (this.field_70181_x < (double)-0.8f) {
                this.field_70181_x = -0.8f;
            }
            if (this.field_70122_E) {
                this.field_70159_w *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                this.field_70159_w *= (double)0.7f;
                this.field_70179_y *= (double)0.7f;
            }
            if (!this.field_70170_p.field_72995_K) {
                int amountToIncrease = 0;
                List<EggEnviroment> enviroments = EggEnviroment.getEnviroments(this);
                boolean wet = enviroments.contains((Object)EggEnviroment.WET);
                boolean warm = enviroments.contains((Object)EggEnviroment.WARM);
                boolean overheat = enviroments.contains((Object)EggEnviroment.OVERHEAT);
                boolean cold = enviroments.contains((Object)EggEnviroment.COLD);
                amountToIncrease = this.creature.isWaterCreature() ? (!wet ? (overheat ? -2 : -1) : 2) : (warm && !wet ? 1 : (cold && wet ? -2 : -1));
                this.currentSpawnTime += amountToIncrease;
                if (this.currentSpawnTime < -500) {
                    if (this.creature.isWaterCreature()) {
                        this.dried = true;
                    } else {
                        this.froze = true;
                    }
                }
                if (this.currentSpawnTime >= this.spawnTime) {
                    Class<EntityLivingBase> dinoToSpawnClass = this.creature.getCreatureClass();
                    try {
                        Entity dinoToSpawn = (Entity)dinoToSpawnClass.getConstructor(World.class).newInstance(this.field_70170_p);
                        if (dinoToSpawn instanceof EntityJurassiCraftCreature) {
                            EntityPlayer owner;
                            EntityJurassiCraftCreature baby = (EntityJurassiCraftCreature)dinoToSpawn;
                            baby.setGenetics(this.quality, this.getDNASequence());
                            EntityJurassiCraftSmart smartBaby = (EntityJurassiCraftSmart)baby;
                            if (dinoToSpawn instanceof EntityJurassiCraftSmart && smartBaby.canBeTamedUponSpawning() && (owner = this.field_70170_p.func_72890_a((Entity)this, 6.0)) != null) {
                                smartBaby.setTamed(true, owner);
                                smartBaby.setOwner(owner.func_70005_c_());
                                this.field_70170_p.func_72960_a((Entity)baby, (byte)7);
                            }
                            baby.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                            this.field_70170_p.func_72838_d((Entity)baby);
                            this.currentSpawnTime = 0;
                            this.func_70106_y();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.currentSpawnTime < this.spawnTime - 100 && !this.dried && !this.froze) {
                if (this.field_70125_A >= 5.0f) {
                    this.rockAmount = -1;
                } else if (this.field_70125_A <= -5.0f) {
                    this.rockAmount = 1;
                }
                this.field_70125_A += (float)this.rockAmount / 2.0f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(25, (Object)(this.froze ? 1 : 0));
                this.field_70180_af.func_75692_b(26, (Object)(this.dried ? 1 : 0));
                this.field_70180_af.func_75692_b(27, (Object)this.currentSpawnTime);
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    public void func_70069_a(float fallDistance) {
        super.func_70069_a(fallDistance);
        if (fallDistance > 10.0f && this.field_70122_E) {
            this.func_70097_a(DamageSource.field_76379_h, 1.0f);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(24, (Object)"");
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)this.rockAmount);
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation(JurassiCraft.getModId() + "textures/eggs/egg" + this.creature.getCreatureName() + ".png");
    }

    public int getHatchingProgressScaled(int i) {
        if (this.spawnTime > 0) {
            return i * this.currentSpawnTime / this.spawnTime;
        }
        return 0;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (player.func_70694_bm() == null) {
            ItemStack stack = new ItemStack((Item)this.creature.getEgg());
            if (!player.field_70170_p.field_72995_K) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("EggQuality", this.quality);
                compound.func_74778_a("EggDNA", this.getDNASequence());
                stack.func_77982_d(compound);
                if (player.field_71071_by.func_70441_a(stack)) {
                    this.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.func_70106_y();
                }
            }
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("CreatureID", (int)this.creature.getCreatureID());
        nbt.func_74778_a("DNASequence", this.getDNASequence());
        nbt.func_74768_a("Quality", this.quality);
        nbt.func_74768_a("SpawnTime", this.spawnTime);
        nbt.func_74768_a("CurrentSpawnTime", this.currentSpawnTime);
        nbt.func_74757_a("Froze", this.froze);
        nbt.func_74757_a("Dried", this.dried);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.creature = CreatureHandler.getCreatureFromId(nbt.func_74762_e("CreatureID"));
        this.setDNASequence(nbt.func_74779_i("DNASequence"));
        this.setQuality(nbt.func_74762_e("Quality"));
        this.spawnTime = nbt.func_74762_e("SpawnTime");
        this.currentSpawnTime = nbt.func_74762_e("CurrentSpawnTime");
        this.froze = nbt.func_74767_n("Froze");
        this.dried = nbt.func_74767_n("Dried");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt((int)this.creature.getCreatureID());
        buffer.writeInt(this.quality);
        buffer.writeInt(this.spawnTime);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.creature = CreatureHandler.getCreatureFromId(additionalData.readInt());
        this.quality = additionalData.readInt();
        this.spawnTime = additionalData.readInt();
    }
}

