/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.handler;

import java.util.Random;

public class JurassiCraftDNAHandler {
    private static Random random = new Random();

    public static String createDefaultDNA() {
        return JurassiCraftDNAHandler.createDNA(15);
    }

    public static String createDNA(int size) {
        String newDNA = "";
        block6: for (int i = 0; i < size; ++i) {
            switch (random.nextInt(4)) {
                case 0: {
                    newDNA = newDNA + "A";
                    continue block6;
                }
                case 1: {
                    newDNA = newDNA + "C";
                    continue block6;
                }
                case 2: {
                    newDNA = newDNA + "G";
                    continue block6;
                }
                case 3: {
                    newDNA = newDNA + "T";
                    continue block6;
                }
                default: {
                    newDNA = newDNA + "_FAIL_";
                }
            }
        }
        if (newDNA.length() != size) {
            newDNA = "FAIL";
        }
        return newDNA;
    }

    public static String reviseDNA(String dna, int quality) {
        if (dna != null && dna.length() > 0) {
            int changes = dna.length() * (100 - quality) / 100;
            for (int i = 0; i < changes; ++i) {
                int charAt = random.nextInt(dna.length());
                String dna1 = dna.substring(0, charAt);
                String dna2 = dna.substring(charAt + 1, dna.length());
                String charChanged = String.valueOf(dna.charAt(charAt));
                if (charChanged.equals("A")) {
                    switch (random.nextInt(3)) {
                        case 0: {
                            charChanged = "C";
                            break;
                        }
                        case 1: {
                            charChanged = "G";
                            break;
                        }
                        case 2: {
                            charChanged = "T";
                            break;
                        }
                        default: {
                            charChanged = "A";
                            break;
                        }
                    }
                } else if (charChanged.equals("C")) {
                    switch (random.nextInt(3)) {
                        case 0: {
                            charChanged = "A";
                            break;
                        }
                        case 1: {
                            charChanged = "G";
                            break;
                        }
                        case 2: {
                            charChanged = "T";
                            break;
                        }
                        default: {
                            charChanged = "C";
                            break;
                        }
                    }
                } else if (charChanged.equals("G")) {
                    switch (random.nextInt(3)) {
                        case 0: {
                            charChanged = "A";
                            break;
                        }
                        case 1: {
                            charChanged = "C";
                            break;
                        }
                        case 2: {
                            charChanged = "T";
                            break;
                        }
                        default: {
                            charChanged = "G";
                            break;
                        }
                    }
                } else if (charChanged.equals("T")) {
                    switch (random.nextInt(3)) {
                        case 0: {
                            charChanged = "A";
                            break;
                        }
                        case 1: {
                            charChanged = "C";
                            break;
                        }
                        case 2: {
                            charChanged = "G";
                            break;
                        }
                        default: {
                            charChanged = "T";
                        }
                    }
                }
                dna = dna1 + charChanged + dna2;
            }
        } else {
            dna = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return dna;
    }

    public static String mixTwoDNAs(String dna1, String dna2) {
        String newDNA = "";
        if (dna1.length() > 0 && dna2.length() > 0 && dna1.length() == dna2.length()) {
            for (int i = 0; i < dna1.length(); ++i) {
                newDNA = i % 2 == 0 ? String.valueOf(newDNA + dna1.charAt(i)) : String.valueOf(newDNA + dna2.charAt(i));
            }
        } else {
            newDNA = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return newDNA;
    }

    public static float getDefaultGenderDNAQuality(String dna) {
        float quality = 0.5f;
        if (dna != null && dna.length() > 0) {
            block6: for (int i = 0; i < 3; ++i) {
                switch (dna.charAt(i)) {
                    case 'A': {
                        quality -= 0.1f;
                        continue block6;
                    }
                    case 'C': {
                        quality -= 0.05f;
                        continue block6;
                    }
                    case 'G': {
                        quality += 0.05f;
                        continue block6;
                    }
                    case 'T': {
                        quality += 0.1f;
                    }
                }
            }
        } else {
            dna = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return quality;
    }

    public static float getGenderDNAQuality(String dna, int fromChar, int toChar) {
        float quality = 0.5f;
        if (dna != null && dna.length() > 0) {
            block6: for (int i = fromChar; i < toChar + 1; ++i) {
                switch (dna.charAt(i)) {
                    case 'A': {
                        quality -= 0.1f;
                        continue block6;
                    }
                    case 'C': {
                        quality -= 0.05f;
                        continue block6;
                    }
                    case 'G': {
                        quality += 0.05f;
                        continue block6;
                    }
                    case 'T': {
                        quality += 0.1f;
                    }
                }
            }
        } else {
            dna = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return Float.valueOf((int)(100000.0f * quality)).floatValue() / 100000.0f;
    }

    public static float getDefaultTextureDNAQuality(String dna) {
        float quality = 0.5f;
        if (dna != null && dna.length() > 0) {
            block6: for (int i = 3; i < 7; ++i) {
                switch (dna.charAt(i)) {
                    case 'A': {
                        quality -= 0.1f;
                        continue block6;
                    }
                    case 'C': {
                        quality -= 0.05f;
                        continue block6;
                    }
                    case 'G': {
                        quality += 0.05f;
                        continue block6;
                    }
                    case 'T': {
                        quality += 0.1f;
                    }
                }
            }
        } else {
            dna = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return Float.valueOf((int)(100000.0f * quality)).floatValue() / 100000.0f;
    }

    public static float getTextureDNAQuality(String dna, int fromChar, int toChar) {
        float quality = 0.5f;
        if (dna != null && dna.length() > 0) {
            block6: for (int i = fromChar; i < toChar + 1; ++i) {
                switch (dna.charAt(i)) {
                    case 'A': {
                        quality -= 0.1f;
                        continue block6;
                    }
                    case 'C': {
                        quality -= 0.05f;
                        continue block6;
                    }
                    case 'G': {
                        quality += 0.05f;
                        continue block6;
                    }
                    case 'T': {
                        quality += 0.1f;
                    }
                }
            }
        } else {
            dna = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return Float.valueOf((int)(100000.0f * quality)).floatValue() / 100000.0f;
    }

    public static float getDefaultGeneticDNAQuality(String dna) {
        float quality = 1.0f;
        if (dna != null && dna.length() > 0) {
            block6: for (int i = 7; i < 15; ++i) {
                switch (dna.charAt(i)) {
                    case 'A': {
                        quality -= 0.05f;
                        continue block6;
                    }
                    case 'C': {
                        quality -= 0.025f;
                        continue block6;
                    }
                    case 'G': {
                        quality += 0.025f;
                        continue block6;
                    }
                    case 'T': {
                        quality += 0.05f;
                    }
                }
            }
        } else {
            dna = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return Float.valueOf((int)(100000.0f * quality)).floatValue() / 100000.0f;
    }

    public static float getGeneticDNAQuality(String dna, int fromChar, int toChar) {
        float quality = 1.0f;
        if (dna != null && dna.length() > 0) {
            block6: for (int i = fromChar; i < toChar + 1; ++i) {
                switch (dna.charAt(i)) {
                    case 'A': {
                        quality -= 0.05f;
                        continue block6;
                    }
                    case 'C': {
                        quality -= 0.025f;
                        continue block6;
                    }
                    case 'G': {
                        quality += 0.025f;
                        continue block6;
                    }
                    case 'T': {
                        quality += 0.05f;
                    }
                }
            }
        } else {
            dna = JurassiCraftDNAHandler.createDefaultDNA();
        }
        return Float.valueOf((int)(100000.0f * quality)).floatValue() / 100000.0f;
    }
}

