/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.render.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.ilexiconn.llibrary.common.event.Render3dItemEvent;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Item3dRenderer
implements IItemRenderer {
    public Item item;
    public ModelBase model;
    public ResourceLocation texture;

    public Item3dRenderer(Item i, ModelBase m, ResourceLocation t) {
        this.item = i;
        this.model = m;
        this.texture = t;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderBlock(0.0f, 1.5f, 0.0f, type);
                break;
            }
            case EQUIPPED: {
                this.renderBlock(0.5f, 1.5f, 0.5f, type);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderBlock(0.5f, 1.5f, 0.5f, type);
                break;
            }
            case INVENTORY: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderBlock(0.0f, 1.0f, 0.0f, type);
                break;
            }
            default: {
                this.renderBlock(0.5f, 1.5f, 0.5f, type);
            }
        }
    }

    public void renderBlock(float x, float y, float z, IItemRenderer.ItemRenderType type) {
        GL11.glPushMatrix();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.texture);
        if (!MinecraftForge.EVENT_BUS.post((Event)new Render3dItemEvent.Pre(this.item, this.model, this.texture, type, x, y, z))) {
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        }
        MinecraftForge.EVENT_BUS.post((Event)new Render3dItemEvent.Post(this.item, this.model, this.texture, type, x, y, z));
        GL11.glPopMatrix();
    }
}

