/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.ilexiconn.llibrary.common.config.ConfigContainer;
import net.ilexiconn.llibrary.common.config.ConfigHelper;
import net.ilexiconn.llibrary.common.entity.EntityHelper;
import net.ilexiconn.llibrary.common.entity.multipart.EntityPart;
import net.ilexiconn.llibrary.common.entity.multipart.IEntityMultiPart;
import net.ilexiconn.llibrary.common.save.SaveHelper;
import net.ilexiconn.llibrary.common.update.UpdateCheckerThread;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ServerEventHandler {
    private boolean checkedForUpdates;

    @SubscribeEvent
    public void entityTick(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof IEntityMultiPart) {
            for (EntityPart part : ((IEntityMultiPart)event.entityLiving).getParts()) {
                part.func_70071_h_();
            }
        }
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K && event.entity instanceof EntityPlayer && !this.checkedForUpdates) {
            new UpdateCheckerThread().start();
            this.checkedForUpdates = true;
        }
        if (EntityHelper.hasEntityBeenRemoved(event.entity.getClass())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            SaveHelper.load(event.world.func_72860_G(), event.world);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K) {
            SaveHelper.save(event.world.func_72860_G(), event.world);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        ConfigContainer container;
        if (ConfigHelper.hasConfiguration(event.modID) && (container = ConfigHelper.getConfigContainer(event.modID)) != null) {
            container.getConfigHandler().loadConfig(container.getConfiguration());
            container.getConfiguration().save();
        }
    }
}

