/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.color;

import com.google.common.collect.Maps;
import java.util.Map;
import net.ilexiconn.llibrary.common.color.RGB;

public class ColorHelper {
    private static Map<RGB, Integer> colorCache = Maps.newHashMap();

    public static int getColorInt(int r, int g, int b, int a) {
        int color = 0;
        Integer cached = colorCache.get(new RGB(r, g, b, a));
        if (cached == null) {
            int red = 0;
            int blue = 0;
            int green = 0;
            int alpha = 0;
            while (alpha != a || red != r || green != b || blue != g) {
                alpha = color >> 24 & 0xFF;
                red = color >> 16 & 0xFF;
                blue = color >> 8 & 0xFF;
                green = color & 0xFF;
                if (alpha < a) {
                    color += 50000;
                    continue;
                }
                if (red < r) {
                    color += 500;
                    continue;
                }
                if (blue < g) {
                    color += 25;
                    continue;
                }
                ++color;
            }
        } else {
            return cached;
        }
        return color;
    }
}

