unit WXOConn;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, WebXoneMidas_TLB, StdVcl, DBXpress, DB, SqlExpr, Provider,
  MemDS, DBAccess, MyAccess;

type
  TWebXoenMidas = class(TRemoteDataModule, IWebXoenMidas)
    MyConnection: TMyConnection;
    MyQuery: TMyQuery;
    DataSetProvider: TDataSetProvider;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

class procedure TWebXoenMidas.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  TComponentFactory.Create(ComServer, TWebXoenMidas,
    Class_WebXoenMidas, ciMultiInstance, tmApartment);
end.
