/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import org.htmlparser.beans.HTMLLinkBean;
import org.htmlparser.beans.HTMLTextBean;

public class BeanyBaby
extends JFrame
implements PropertyChangeListener,
ActionListener,
MouseListener {
    protected Vector mTrail;
    protected int mCrumb;
    private HTMLLinkBean mLinkBean;
    private JMenuItem mForward;
    private JMenuItem mBack;
    private JCheckBoxMenuItem mCollapse;
    private JTextField mTextField;
    private JSplitPane mSplitPane;
    private JCheckBoxMenuItem mLinks;
    private HTMLTextBean mStringBean;
    private JCheckBoxMenuItem mNobreak;

    public BeanyBaby() {
        this.initComponents();
        this.mTrail = new Vector();
        this.mCrumb = -1;
        ((Component)this).setVisible(true);
        this.mSplitPane.setDividerLocation(0.5);
        ((Component)this).setVisible(false);
        this.mLinkBean.addPropertyChangeListener(this);
        this.mStringBean.addPropertyChangeListener(this);
        this.mTextField.addActionListener(this);
        this.mLinkBean.addMouseListener(this);
        this.mLinks.setSelected(this.mStringBean.getLinks());
        this.mCollapse.setSelected(this.mStringBean.getCollapse());
        this.mNobreak.setSelected(this.mStringBean.getReplaceNonBreakingSpaces());
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source == this.mLinkBean) {
            if (!this.mLinkBean.getURL().equals(this.mStringBean.getURL())) {
                this.mStringBean.setURL(this.mLinkBean.getURL());
            }
        } else if (source == this.mStringBean) {
            String name;
            if (!this.mStringBean.getURL().equals(this.mLinkBean.getURL())) {
                this.mLinkBean.setURL(this.mStringBean.getURL());
            }
            if ((name = event.getPropertyName()).equals("links")) {
                this.mLinks.setSelected((Boolean)event.getNewValue());
            } else if (name.equals("collapse")) {
                this.mCollapse.setSelected((Boolean)event.getNewValue());
            } else if (name.equals("replaceNonBreakingSpaces")) {
                this.mNobreak.setSelected((Boolean)event.getNewValue());
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mTextField) {
            String url = this.mTextField.getText();
            this.mTextField.selectAll();
            this.setURL(url);
        } else if (source instanceof JCheckBoxMenuItem) {
            JMenuItem item = (JMenuItem)source;
            String name = item.getName();
            if ("Links".equals(name)) {
                this.mStringBean.setLinks(item.isSelected());
            } else if ("Collapse".equals(name)) {
                this.mStringBean.setCollapse(item.isSelected());
            } else if ("Nobreak".equals(name)) {
                this.mStringBean.setReplaceNonBreakingSpaces(item.isSelected());
            }
        } else if (source instanceof JMenuItem) {
            String name = ((JMenuItem)source).getName();
            if ("Back".equals(name)) {
                if (this.mCrumb > 0) {
                    --this.mCrumb;
                    String url = (String)this.mTrail.elementAt(this.mCrumb);
                    --this.mCrumb;
                    this.setURL(url);
                }
            } else if ("Forward".equals(name) && this.mCrumb < this.mTrail.size()) {
                ++this.mCrumb;
                String url = (String)this.mTrail.elementAt(this.mCrumb);
                --this.mCrumb;
                this.setURL(url);
            }
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (2 == event.getClickCount()) {
            int index = this.mLinkBean.locationToIndex(event.getPoint());
            String url = this.mLinkBean.getModel().getElementAt(index).toString();
            this.setURL(url);
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void setURL(String url) {
        this.mTextField.setText(url);
        ++this.mCrumb;
        if (this.mTrail.size() <= this.mCrumb) {
            this.mTrail.addElement(url);
        } else {
            this.mTrail.setElementAt(url, this.mCrumb);
        }
        this.mLinkBean.setURL(url);
        this.mBack.setEnabled(this.mCrumb > 0);
        this.mForward.setEnabled(this.mCrumb + 1 < this.mTrail.size());
    }

    private void initComponents() {
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu go = new JMenu();
        this.mBack = new JMenuItem();
        this.mForward = new JMenuItem();
        JMenu options = new JMenu();
        this.mLinks = new JCheckBoxMenuItem();
        this.mCollapse = new JCheckBoxMenuItem();
        this.mNobreak = new JCheckBoxMenuItem();
        JPanel panel = new JPanel();
        this.mSplitPane = new JSplitPane();
        JScrollPane pane1 = new JScrollPane();
        this.mLinkBean = new HTMLLinkBean();
        JScrollPane pane2 = new JScrollPane();
        this.mStringBean = new HTMLTextBean();
        this.mTextField = new JTextField();
        go.setMnemonic('G');
        go.setText("Go");
        go.setToolTipText("crude URL navigation");
        this.mBack.setMnemonic('B');
        this.mBack.setText("Back");
        this.mBack.setToolTipText("back one URL");
        this.mBack.setName("Back");
        this.mBack.addActionListener(this);
        go.add(this.mBack);
        this.mForward.setMnemonic('F');
        this.mForward.setText("Forward");
        this.mForward.setToolTipText("forward one URL");
        this.mForward.setName("Forward");
        this.mForward.addActionListener(this);
        go.add(this.mForward);
        menubar.add(go);
        options.setMnemonic('O');
        options.setText("Options");
        options.setToolTipText("Bean settings");
        this.mLinks.setMnemonic('L');
        this.mLinks.setText("Links");
        this.mLinks.setToolTipText("show/hide links in text");
        this.mLinks.setName("Links");
        this.mLinks.addActionListener(this);
        options.add(this.mLinks);
        this.mCollapse.setMnemonic('C');
        this.mCollapse.setText("Collapse");
        this.mCollapse.setToolTipText("collapse/retain whitespace sequences");
        this.mCollapse.setName("Collapse");
        this.mCollapse.addActionListener(this);
        options.add(this.mCollapse);
        this.mNobreak.setMnemonic('N');
        this.mNobreak.setText("Non-breaking Spaces");
        this.mNobreak.setToolTipText("replace/retain non-breaking spaces");
        this.mNobreak.setName("Nobreak");
        this.mNobreak.addActionListener(this);
        options.add(this.mNobreak);
        menubar.add(options);
        this.setTitle("BeanyBaby");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BeanyBaby.this.exitForm(evt);
            }
        });
        panel.setLayout(new BorderLayout());
        pane1.setViewportView(this.mLinkBean);
        this.mSplitPane.setLeftComponent(pane1);
        pane2.setViewportView(this.mStringBean);
        this.mSplitPane.setRightComponent(pane2);
        panel.add((Component)this.mSplitPane, "Center");
        this.mTextField.setToolTipText("Enter the URL to view");
        panel.add((Component)this.mTextField, "South");
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setSize(new Dimension(640, 480));
        ((Component)this).setLocation((screenSize.width - 640) / 2, (screenSize.height - 480) / 2);
    }

    private void exitForm(WindowEvent event) {
        System.exit(0);
    }

    public static void main(String[] args) {
        BeanyBaby bb = new BeanyBaby();
        ((Component)bb).setVisible(true);
        if (0 >= args.length) {
            bb.setURL("http://www.slashdot.org");
        } else {
            bb.setURL(args[0]);
        }
    }
}

