/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ExtendedBeanInfo
implements BeanInfo {
    private final BeanInfo delegate;
    private final SortedSet<PropertyDescriptor> propertyDescriptors = new TreeSet<PropertyDescriptor>(new PropertyDescriptorComparator());

    public ExtendedBeanInfo(BeanInfo delegate) throws IntrospectionException {
        this.delegate = delegate;
        MethodDescriptor[] methodDescriptorArray = delegate.getMethodDescriptors();
        int n = methodDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                MethodDescriptor md = methodDescriptorArray[n2];
                Method method = md.getMethod();
                if (!ReflectionUtils.isObjectMethod((Method)method) || method.getName().startsWith("get")) {
                    int n3;
                    PropertyDescriptor[] propertyDescriptorArray;
                    String propertyName;
                    if (method.getName().startsWith("set") && method.getParameterTypes().length == 1) {
                        propertyName = this.propertyNameFor(method);
                        if (propertyName.length() != 0) {
                            propertyDescriptorArray = delegate.getPropertyDescriptors();
                            int n4 = propertyDescriptorArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                PropertyDescriptor pd = propertyDescriptorArray[n3];
                                Method readMethod = pd.getReadMethod();
                                Method writeMethod = pd.getWriteMethod();
                                if (writeMethod != null && writeMethod.getName().equals(method.getName())) {
                                    this.addOrUpdatePropertyDescriptor(propertyName, readMethod, writeMethod);
                                    break block19;
                                }
                                if (readMethod != null && readMethod.getName().equals(this.getterMethodNameFor(propertyName)) && readMethod.getReturnType().equals(method.getParameterTypes()[0])) {
                                    this.addOrUpdatePropertyDescriptor(propertyName, readMethod, method);
                                    break block19;
                                }
                                ++n3;
                            }
                            this.addOrUpdatePropertyDescriptor(propertyName, null, method);
                        }
                    } else if (method.getName().startsWith("set") && method.getParameterTypes().length == 2 && method.getParameterTypes()[0].equals(Integer.TYPE)) {
                        propertyName = this.propertyNameFor(method);
                        if (propertyName.length() != 0) {
                            propertyDescriptorArray = delegate.getPropertyDescriptors();
                            int n5 = propertyDescriptorArray.length;
                            n3 = 0;
                            while (n3 < n5) {
                                PropertyDescriptor pd = propertyDescriptorArray[n3];
                                if (pd instanceof IndexedPropertyDescriptor) {
                                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                                    Method readMethod = ipd.getReadMethod();
                                    Method writeMethod = ipd.getWriteMethod();
                                    Method indexedReadMethod = ipd.getIndexedReadMethod();
                                    Method indexedWriteMethod = ipd.getIndexedWriteMethod();
                                    if (indexedWriteMethod != null && indexedWriteMethod.getName().equals(method.getName())) {
                                        this.addOrUpdatePropertyDescriptor(propertyName, readMethod, writeMethod, indexedReadMethod, indexedWriteMethod);
                                        break block19;
                                    }
                                    if (indexedReadMethod != null && indexedReadMethod.getName().equals(this.getterMethodNameFor(propertyName)) && indexedReadMethod.getReturnType().equals(method.getParameterTypes()[1])) {
                                        this.addOrUpdatePropertyDescriptor(propertyName, readMethod, writeMethod, indexedReadMethod, method);
                                        break block19;
                                    }
                                }
                                ++n3;
                            }
                            this.addOrUpdatePropertyDescriptor(propertyName, null, null, null, method);
                        }
                    } else {
                        PropertyDescriptor[] propertyDescriptorArray2 = delegate.getPropertyDescriptors();
                        n3 = propertyDescriptorArray2.length;
                        int n6 = 0;
                        block3: while (n6 < n3) {
                            PropertyDescriptor pd = propertyDescriptorArray2[n6];
                            for (PropertyDescriptor existingPD : this.propertyDescriptors) {
                                if (!method.equals(pd.getReadMethod()) || !existingPD.getName().equals(pd.getName())) continue;
                                if (existingPD.getReadMethod() != null) break block3;
                                this.addOrUpdatePropertyDescriptor(pd.getName(), method, pd.getWriteMethod());
                                break block3;
                            }
                            if (method == pd.getReadMethod() || pd instanceof IndexedPropertyDescriptor && method == ((IndexedPropertyDescriptor)pd).getIndexedReadMethod()) {
                                if (pd instanceof IndexedPropertyDescriptor) {
                                    this.addOrUpdatePropertyDescriptor(pd.getName(), pd.getReadMethod(), pd.getWriteMethod(), ((IndexedPropertyDescriptor)pd).getIndexedReadMethod(), ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod());
                                    break;
                                }
                                this.addOrUpdatePropertyDescriptor(pd.getName(), pd.getReadMethod(), pd.getWriteMethod());
                                break;
                            }
                            ++n6;
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void addOrUpdatePropertyDescriptor(String propertyName, Method readMethod, Method writeMethod) throws IntrospectionException {
        this.addOrUpdatePropertyDescriptor(propertyName, readMethod, writeMethod, null, null);
    }

    private void addOrUpdatePropertyDescriptor(String propertyName, Method readMethod, Method writeMethod, Method indexedReadMethod, Method indexedWriteMethod) throws IntrospectionException {
        for (PropertyDescriptor existingPD : this.propertyDescriptors) {
            if (!existingPD.getName().equals(propertyName)) continue;
            if (existingPD.getReadMethod() != null && (readMethod != null && existingPD.getReadMethod().getReturnType() != readMethod.getReturnType() || writeMethod != null && existingPD.getReadMethod().getReturnType() != writeMethod.getParameterTypes()[0])) break;
            if (readMethod != null) {
                try {
                    existingPD.setReadMethod(readMethod);
                }
                catch (IntrospectionException introspectionException) {
                    existingPD.setWriteMethod(null);
                    existingPD.setReadMethod(readMethod);
                }
            }
            if (existingPD.getWriteMethod() != null && (readMethod != null && existingPD.getWriteMethod().getParameterTypes()[0] != readMethod.getReturnType() || writeMethod != null && existingPD.getWriteMethod().getParameterTypes()[0] != writeMethod.getParameterTypes()[0])) break;
            if (writeMethod != null) {
                existingPD.setWriteMethod(writeMethod);
            }
            if (existingPD instanceof IndexedPropertyDescriptor) {
                IndexedPropertyDescriptor existingIPD = (IndexedPropertyDescriptor)existingPD;
                if (existingIPD.getIndexedReadMethod() != null && (indexedReadMethod != null && existingIPD.getIndexedReadMethod().getReturnType() != indexedReadMethod.getReturnType() || indexedWriteMethod != null && existingIPD.getIndexedReadMethod().getReturnType() != indexedWriteMethod.getParameterTypes()[1])) break;
                try {
                    existingIPD.setIndexedReadMethod(indexedReadMethod);
                }
                catch (IntrospectionException introspectionException) {
                    existingIPD.setIndexedWriteMethod(null);
                    existingIPD.setIndexedReadMethod(indexedReadMethod);
                }
                if (existingIPD.getIndexedWriteMethod() != null && (indexedReadMethod != null && existingIPD.getIndexedWriteMethod().getParameterTypes()[1] != indexedReadMethod.getReturnType() || indexedWriteMethod != null && existingIPD.getIndexedWriteMethod().getParameterTypes()[1] != indexedWriteMethod.getParameterTypes()[1])) break;
                if (indexedWriteMethod != null) {
                    existingIPD.setIndexedWriteMethod(indexedWriteMethod);
                }
            }
            return;
        }
        if (indexedReadMethod == null && indexedWriteMethod == null) {
            this.propertyDescriptors.add(new PropertyDescriptor(propertyName, readMethod, writeMethod));
        } else {
            this.propertyDescriptors.add(new IndexedPropertyDescriptor(propertyName, readMethod, writeMethod, indexedReadMethod, indexedWriteMethod));
        }
    }

    private String propertyNameFor(Method method) {
        return Introspector.decapitalize(method.getName().substring(3, method.getName().length()));
    }

    private Object getterMethodNameFor(String name) {
        return "get" + StringUtils.capitalize((String)name);
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return this.delegate.getAdditionalBeanInfo();
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.delegate.getBeanDescriptor();
    }

    public int getDefaultEventIndex() {
        return this.delegate.getDefaultEventIndex();
    }

    public int getDefaultPropertyIndex() {
        return this.delegate.getDefaultPropertyIndex();
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.delegate.getEventSetDescriptors();
    }

    public Image getIcon(int arg0) {
        return this.delegate.getIcon(arg0);
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.delegate.getMethodDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors.toArray(new PropertyDescriptor[this.propertyDescriptors.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyDescriptorComparator
    implements Comparator<PropertyDescriptor> {
        PropertyDescriptorComparator() {
        }

        @Override
        public int compare(PropertyDescriptor desc1, PropertyDescriptor desc2) {
            String left = desc1.getName();
            String right = desc2.getName();
            int i = 0;
            while (i < left.length()) {
                if (right.length() == i) {
                    return 1;
                }
                int result = left.getBytes()[i] - right.getBytes()[i];
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return left.length() - right.length();
        }
    }
}

