/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class X509CertificateWrapper
extends X509Certificate {
    private final X509Certificate cert;
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";

    X509CertificateWrapper(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public int getBasicConstraints() {
        int n = this.cert.getBasicConstraints();
        if (n != -1) {
            return n;
        }
        try {
            if (this.cert.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (CertUtils.getNetscapeCertTypeBit(this.cert, NSCT_SSL_CA) || CertUtils.getNetscapeCertTypeBit(this.cert, NSCT_S_MIME_CA) || CertUtils.getNetscapeCertTypeBit(this.cert, NSCT_OBJECT_SIGNING_CA))) {
                return Integer.MAX_VALUE;
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return -1;
    }

    public boolean[] getKeyUsage() {
        return this.cert.getKeyUsage();
    }

    public boolean[] getSubjectUniqueID() {
        return this.cert.getSubjectUniqueID();
    }

    public boolean[] getIssuerUniqueID() {
        return this.cert.getIssuerUniqueID();
    }

    public byte[] getSigAlgParams() {
        return this.cert.getSigAlgParams();
    }

    public String getSigAlgOID() {
        return this.cert.getSigAlgOID();
    }

    public String getSigAlgName() {
        return this.cert.getSigAlgName();
    }

    public byte[] getSignature() {
        return this.cert.getSignature();
    }

    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    public Principal getSubjectDN() {
        return this.cert.getSubjectDN();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.cert.getTBSCertificate();
    }

    public int getVersion() {
        return this.cert.getVersion();
    }

    public Principal getIssuerDN() {
        return this.cert.getIssuerDN();
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
    }

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    public String toString() {
        return this.cert.toString();
    }

    public void verify(PublicKey publicKey) throws CertificateException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        this.cert.verify(publicKey);
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        this.cert.verify(publicKey, string);
    }

    public byte[] getExtensionValue(String string) {
        return this.cert.getExtensionValue(string);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.cert.getNonCriticalExtensionOIDs();
    }

    public Set getCriticalExtensionOIDs() {
        return this.cert.getCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.cert.hasUnsupportedCriticalExtension();
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        return this.cert.getExtendedKeyUsage();
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return this.cert.getIssuerAlternativeNames();
    }

    public X500Principal getIssuerX500Principal() {
        return this.cert.getIssuerX500Principal();
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return this.cert.getSubjectAlternativeNames();
    }

    public X500Principal getSubjectX500Principal() {
        return this.cert.getSubjectX500Principal();
    }

    public boolean equals(Object object) {
        return this.cert.equals(object);
    }

    public int hashCode() {
        return this.cert.hashCode();
    }
}

