/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.javaws.Main;
import com.sun.javaws.security.AppContextUtil;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public final class JavawsSysRun
extends DeploySysRun {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object delegate(DeploySysAction deploySysAction) throws Exception {
        if (Thread.currentThread().getThreadGroup().equals(Main.getSecurityThreadGroup())) {
            return deploySysAction.execute();
        }
        final SecureThread secureThread = new SecureThread(deploySysAction);
        if (AppContextUtil.isApplicationAppContext() && SwingUtilities.isEventDispatchThread()) {
            Object object = secureThread.syncObject;
            synchronized (object) {
                DummyDialog dummyDialog;
                secureThread.dummyDialog = dummyDialog = new DummyDialog();
                dummyDialog.addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent windowEvent) {
                        secureThread.start();
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        dummyDialog.setVisible(false);
                    }
                });
                if (Config.getOSName().equals("Windows")) {
                    dummyDialog.setLocation(-200, -200);
                } else {
                    Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
                    dummyDialog.setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
                }
                dummyDialog.setResizable(false);
                dummyDialog.toBack();
                dummyDialog.setVisible(true);
                try {
                    secureThread.syncObject.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    dummyDialog.setVisible(false);
                }
            }
        }
        secureThread.start();
        try {
            secureThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (secureThread.exception != null) {
            throw secureThread.exception;
        }
        return secureThread.result;
    }

    static void invokeLater(final Runnable runnable) {
        if (Thread.currentThread().getThreadGroup().equals(Main.getSecurityThreadGroup())) {
            SwingUtilities.invokeLater(runnable);
            return;
        }
        final Runnable runnable2 = new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(runnable);
            }
        };
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(Main.getSecurityThreadGroup(), runnable2);
                thread.setContextClassLoader(Main.getSecureContextClassLoader());
                thread.start();
                return null;
            }
        });
    }

    private class DummyDialog
    extends JDialog {
        private ThreadGroup _callingTG = Thread.currentThread().getThreadGroup();

        DummyDialog() {
            super((Frame)null, true);
        }

        public void secureHide() {
            new Thread(this._callingTG, new Runnable(){

                public void run() {
                    DummyDialog.this.setVisible(false);
                }
            }).start();
        }
    }

    class SecureThread
    extends Thread {
        Exception exception = null;
        Object result = null;
        DeploySysAction action = null;
        Object syncObject = new Object();
        DummyDialog dummyDialog = null;

        public SecureThread(DeploySysAction deploySysAction) {
            super(Main.getSecurityThreadGroup(), "Javaws Secure Thread");
            this.action = deploySysAction;
            this.setContextClassLoader(Main.getSecureContextClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Thread.currentThread().setContextClassLoader(Main.getSecureContextClassLoader());
                    }
                });
                this.result = this.action.execute();
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            finally {
                if (this.dummyDialog != null) {
                    this.dummyDialog.secureHide();
                }
                Object object = this.syncObject;
                synchronized (object) {
                    this.syncObject.notifyAll();
                }
            }
        }
    }
}

