/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.AstUtils;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;

public class Indexer
extends SpelNodeImpl {
    private String cachedReadName;
    private Class<?> cachedReadTargetType;
    private PropertyAccessor cachedReadAccessor;
    private String cachedWriteName;
    private Class<?> cachedWriteTargetType;
    private PropertyAccessor cachedWriteAccessor;

    public Indexer(int pos, SpelNodeImpl expr) {
        super(pos, expr);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue context = state.getActiveContextObject();
        Object targetObject = context.getValue();
        TypeDescriptor targetObjectTypeDescriptor = context.getTypeDescriptor();
        TypedValue indexValue = null;
        Object index = null;
        if (targetObject instanceof Map && this.children[0] instanceof PropertyOrFieldReference) {
            PropertyOrFieldReference reference = (PropertyOrFieldReference)this.children[0];
            index = reference.getName();
            indexValue = new TypedValue(index);
        } else {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                indexValue = this.children[0].getValueInternal(state);
                index = indexValue.getValue();
            }
            finally {
                state.popActiveContextObject();
            }
        }
        if (targetObject instanceof Map) {
            Object key = index;
            if (targetObjectTypeDescriptor.getMapKeyTypeDescriptor() != null) {
                key = state.convertValue(key, targetObjectTypeDescriptor.getMapKeyTypeDescriptor());
            }
            Object value = ((Map)targetObject).get(key);
            return new TypedValue(value, targetObjectTypeDescriptor.mapValueTypeDescriptor(value));
        }
        if (targetObject == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        if (targetObject instanceof Collection || targetObject.getClass().isArray() || targetObject instanceof String) {
            int idx = (Integer)state.convertValue(index, TypeDescriptor.valueOf(Integer.class));
            if (targetObject.getClass().isArray()) {
                Object arrayElement = this.accessArrayElement(targetObject, idx);
                return new TypedValue(arrayElement, targetObjectTypeDescriptor.elementTypeDescriptor(arrayElement));
            }
            if (targetObject instanceof Collection) {
                Collection c = (Collection)targetObject;
                if (idx >= c.size() && !this.growCollection(state, targetObjectTypeDescriptor, idx, c)) {
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, c.size(), idx);
                }
                int pos = 0;
                for (Object o : c) {
                    if (pos == idx) {
                        return new TypedValue(o, targetObjectTypeDescriptor.elementTypeDescriptor(o));
                    }
                    ++pos;
                }
            } else if (targetObject instanceof String) {
                String ctxString = (String)targetObject;
                if (idx >= ctxString.length()) {
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.STRING_INDEX_OUT_OF_BOUNDS, ctxString.length(), idx);
                }
                return new TypedValue(String.valueOf(ctxString.charAt(idx)));
            }
        }
        if (indexValue.getTypeDescriptor().getType() == String.class) {
            Class<?> targetObjectRuntimeClass = this.getObjectClass(targetObject);
            String name = (String)indexValue.getValue();
            EvaluationContext eContext = state.getEvaluationContext();
            try {
                if (this.cachedReadName != null && this.cachedReadName.equals(name) && this.cachedReadTargetType != null && this.cachedReadTargetType.equals(targetObjectRuntimeClass)) {
                    return this.cachedReadAccessor.read(eContext, targetObject, name);
                }
                List<PropertyAccessor> accessorsToTry = AstUtils.getPropertyAccessorsToTry(targetObjectRuntimeClass, state);
                if (accessorsToTry != null) {
                    for (PropertyAccessor accessor : accessorsToTry) {
                        if (!accessor.canRead(eContext, targetObject, name)) continue;
                        if (accessor instanceof ReflectivePropertyAccessor) {
                            accessor = ((ReflectivePropertyAccessor)accessor).createOptimalAccessor(eContext, targetObject, name);
                        }
                        this.cachedReadAccessor = accessor;
                        this.cachedReadName = name;
                        this.cachedReadTargetType = targetObjectRuntimeClass;
                        return accessor.read(eContext, targetObject, name);
                    }
                }
            }
            catch (AccessException e) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)e, SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return true;
    }

    public void setValue(ExpressionState state, Object newValue) throws EvaluationException {
        TypedValue contextObject = state.getActiveContextObject();
        Object targetObject = contextObject.getValue();
        TypeDescriptor targetObjectTypeDescriptor = contextObject.getTypeDescriptor();
        TypedValue index = this.children[0].getValueInternal(state);
        if (targetObject == null) {
            throw new SpelEvaluationException(SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        if (targetObject instanceof Map) {
            Map map = (Map)targetObject;
            Object key = index.getValue();
            if (targetObjectTypeDescriptor.getMapKeyTypeDescriptor() != null) {
                key = state.convertValue(index, targetObjectTypeDescriptor.getMapKeyTypeDescriptor());
            }
            if (targetObjectTypeDescriptor.getMapValueTypeDescriptor() != null) {
                newValue = state.convertValue(newValue, targetObjectTypeDescriptor.getMapValueTypeDescriptor());
            }
            map.put(key, newValue);
            return;
        }
        if (targetObjectTypeDescriptor.isArray()) {
            int idx = (Integer)state.convertValue(index, TypeDescriptor.valueOf(Integer.class));
            this.setArrayElement(state, contextObject.getValue(), idx, newValue, targetObjectTypeDescriptor.getElementTypeDescriptor().getType());
            return;
        }
        if (targetObject instanceof Collection) {
            Collection c;
            int idx = (Integer)state.convertValue(index, TypeDescriptor.valueOf(Integer.class));
            if (idx >= (c = (Collection)targetObject).size() && !this.growCollection(state, targetObjectTypeDescriptor, idx, c)) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, c.size(), idx);
            }
            if (targetObject instanceof List) {
                List list = (List)targetObject;
                if (targetObjectTypeDescriptor.getElementTypeDescriptor() != null) {
                    newValue = state.convertValue(newValue, targetObjectTypeDescriptor.getElementTypeDescriptor());
                }
                list.set(idx, newValue);
                return;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
        }
        if (index.getTypeDescriptor().getType() == String.class) {
            Class<?> contextObjectClass = this.getObjectClass(contextObject.getValue());
            String name = (String)index.getValue();
            EvaluationContext eContext = state.getEvaluationContext();
            try {
                if (this.cachedWriteName != null && this.cachedWriteName.equals(name) && this.cachedWriteTargetType != null && this.cachedWriteTargetType.equals(contextObjectClass)) {
                    this.cachedWriteAccessor.write(eContext, targetObject, name, newValue);
                    return;
                }
                List<PropertyAccessor> accessorsToTry = AstUtils.getPropertyAccessorsToTry(contextObjectClass, state);
                if (accessorsToTry != null) {
                    for (PropertyAccessor accessor : accessorsToTry) {
                        if (!accessor.canWrite(eContext, contextObject.getValue(), name)) continue;
                        this.cachedWriteName = name;
                        this.cachedWriteTargetType = contextObjectClass;
                        this.cachedWriteAccessor = accessor;
                        accessor.write(eContext, contextObject.getValue(), name, newValue);
                        return;
                    }
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, name, ae.getMessage());
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
    }

    private boolean growCollection(ExpressionState state, TypeDescriptor targetType, int index, Collection collection) {
        if (state.getConfiguration().isAutoGrowCollections()) {
            if (targetType.getElementTypeDescriptor() == null) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION_UNKNOWN_ELEMENT_TYPE, new Object[0]);
            }
            TypeDescriptor elementType = targetType.getElementTypeDescriptor();
            Object newCollectionElement = null;
            try {
                int newElements = index - collection.size();
                while (newElements > 0) {
                    collection.add(elementType.getType().newInstance());
                    --newElements;
                }
                newCollectionElement = elementType.getType().newInstance();
            }
            catch (Exception ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
            }
            collection.add(newCollectionElement);
            return true;
        }
        return false;
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private void setArrayElement(ExpressionState state, Object ctx, int idx, Object newValue, Class clazz) throws EvaluationException {
        Class arrayComponentType = clazz;
        if (arrayComponentType == Integer.TYPE) {
            int[] array = (int[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Integer)state.convertValue(newValue, TypeDescriptor.valueOf(Integer.class));
        } else if (arrayComponentType == Boolean.TYPE) {
            boolean[] array = (boolean[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Boolean)state.convertValue(newValue, TypeDescriptor.valueOf(Boolean.class));
        } else if (arrayComponentType == Character.TYPE) {
            char[] array = (char[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = ((Character)state.convertValue(newValue, TypeDescriptor.valueOf(Character.class))).charValue();
        } else if (arrayComponentType == Long.TYPE) {
            long[] array = (long[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Long)state.convertValue(newValue, TypeDescriptor.valueOf(Long.class));
        } else if (arrayComponentType == Short.TYPE) {
            short[] array = (short[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Short)state.convertValue(newValue, TypeDescriptor.valueOf(Short.class));
        } else if (arrayComponentType == Double.TYPE) {
            double[] array = (double[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Double)state.convertValue(newValue, TypeDescriptor.valueOf(Double.class));
        } else if (arrayComponentType == Float.TYPE) {
            float[] array = (float[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = ((Float)state.convertValue(newValue, TypeDescriptor.valueOf(Float.class))).floatValue();
        } else if (arrayComponentType == Byte.TYPE) {
            byte[] array = (byte[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Byte)state.convertValue(newValue, TypeDescriptor.valueOf(Byte.class));
        } else {
            Object[] array = (Object[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = state.convertValue(newValue, TypeDescriptor.valueOf((Class)clazz));
        }
    }

    private Object accessArrayElement(Object ctx, int idx) throws SpelEvaluationException {
        Class<?> arrayComponentType = ctx.getClass().getComponentType();
        if (arrayComponentType == Integer.TYPE) {
            int[] array = (int[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Boolean.TYPE) {
            boolean[] array = (boolean[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Character.TYPE) {
            char[] array = (char[])ctx;
            this.checkAccess(array.length, idx);
            return Character.valueOf(array[idx]);
        }
        if (arrayComponentType == Long.TYPE) {
            long[] array = (long[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Short.TYPE) {
            short[] array = (short[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Double.TYPE) {
            double[] array = (double[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Float.TYPE) {
            float[] array = (float[])ctx;
            this.checkAccess(array.length, idx);
            return Float.valueOf(array[idx]);
        }
        if (arrayComponentType == Byte.TYPE) {
            byte[] array = (byte[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        Object[] array = (Object[])ctx;
        this.checkAccess(array.length, idx);
        return array[idx];
    }

    private void checkAccess(int arrayLength, int index) throws SpelEvaluationException {
        if (index > arrayLength) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.ARRAY_INDEX_OUT_OF_BOUNDS, arrayLength, index);
        }
    }
}

