/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.SpringCachingAnnotationParser;
import org.springframework.cache.interceptor.AbstractFallbackCacheOperationSource;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCacheOperationSource
extends AbstractFallbackCacheOperationSource
implements Serializable {
    private final boolean publicMethodsOnly;
    private final Set<CacheAnnotationParser> annotationParsers;

    public AnnotationCacheOperationSource() {
        this(true);
    }

    public AnnotationCacheOperationSource(boolean publicMethodsOnly) {
        this.publicMethodsOnly = publicMethodsOnly;
        this.annotationParsers = new LinkedHashSet<CacheAnnotationParser>(1);
        this.annotationParsers.add(new SpringCachingAnnotationParser());
    }

    public AnnotationCacheOperationSource(CacheAnnotationParser ... annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty((Object[])annotationParsers, (String)"At least one CacheAnnotationParser needs to be specified");
        LinkedHashSet<CacheAnnotationParser> parsers = new LinkedHashSet<CacheAnnotationParser>(annotationParsers.length);
        Collections.addAll(parsers, annotationParsers);
        this.annotationParsers = parsers;
    }

    @Override
    protected CacheOperation findCacheOperation(Class<?> clazz) {
        return this.determineCacheOperation(clazz);
    }

    @Override
    protected CacheOperation findCacheOperation(Method method) {
        return this.determineCacheOperation(method);
    }

    protected CacheOperation determineCacheOperation(AnnotatedElement ae) {
        for (CacheAnnotationParser annotationParser : this.annotationParsers) {
            CacheOperation attr = annotationParser.parseCacheAnnotation(ae);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    @Override
    protected boolean allowPublicMethodsOnly() {
        return this.publicMethodsOnly;
    }
}

