/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.DefaultValueWrapper;

public class ConcurrentMapCache
implements Cache {
    private static final Object NULL_HOLDER = new NullHolder();
    private final ConcurrentMap store;
    private final String name;
    private final boolean allowNullValues;

    public ConcurrentMapCache() {
        this("");
    }

    public ConcurrentMapCache(String name) {
        this(new ConcurrentHashMap(), name, true);
    }

    public ConcurrentMapCache(ConcurrentMap delegate, String name, boolean allowNullValues) {
        this.store = delegate;
        this.name = name;
        this.allowNullValues = allowNullValues;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAllowNullValues() {
        return this.allowNullValues;
    }

    public ConcurrentMap getNativeCache() {
        return this.store;
    }

    public void clear() {
        this.store.clear();
    }

    public Cache.ValueWrapper get(Object key) {
        Object v = this.store.get(key);
        return v != null ? new DefaultValueWrapper(this.filterNull(v)) : null;
    }

    public void put(Object key, Object value) {
        if (this.allowNullValues && value == null) {
            ConcurrentMap map = this.store;
            map.put(key, NULL_HOLDER);
        } else {
            this.store.put(key, value);
        }
    }

    public void evict(Object key) {
        this.store.remove(key);
    }

    protected Object filterNull(Object val) {
        if (this.allowNullValues && val == NULL_HOLDER) {
            return null;
        }
        return val;
    }

    private static class NullHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private NullHolder() {
        }
    }
}

