/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.config;

import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cache.annotation.AnnotationCacheOperationSource;
import org.springframework.cache.interceptor.BeanFactoryCacheOperationSourceAdvisor;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.w3c.dom.Element;

class AnnotationDrivenCacheBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String CACHE_MANAGER_ATTRIBUTE = "cache-manager";
    private static final String DEFAULT_CACHE_MANAGER_BEAN_NAME = "cacheManager";

    AnnotationDrivenCacheBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String mode = element.getAttribute("mode");
        if ("aspectj".equals(mode)) {
            this.registerCacheAspect(element, parserContext);
        } else {
            AopAutoProxyConfigurer.configureAutoProxyCreator(element, parserContext);
        }
        return null;
    }

    private static String extractCacheManager(Element element) {
        return element.hasAttribute(CACHE_MANAGER_ATTRIBUTE) ? element.getAttribute(CACHE_MANAGER_ATTRIBUTE) : DEFAULT_CACHE_MANAGER_BEAN_NAME;
    }

    private static void registerCacheManagerProperty(Element element, BeanDefinition def) {
        def.getPropertyValues().add(DEFAULT_CACHE_MANAGER_BEAN_NAME, (Object)new RuntimeBeanReference(AnnotationDrivenCacheBeanDefinitionParser.extractCacheManager(element)));
    }

    private void registerCacheAspect(Element element, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("org.springframework.cache.config.internalCacheAspect")) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName("org.springframework.cache.aspectj.AnnotationCacheAspect");
            def.setFactoryMethodName("aspectOf");
            AnnotationDrivenCacheBeanDefinitionParser.registerCacheManagerProperty(element, (BeanDefinition)def);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, "org.springframework.cache.config.internalCacheAspect"));
        }
    }

    private static class AopAutoProxyConfigurer {
        private AopAutoProxyConfigurer() {
        }

        public static void configureAutoProxyCreator(Element element, ParserContext parserContext) {
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
            if (!parserContext.getRegistry().containsBeanDefinition("org.springframework.cache.config.internalCacheAdvisor")) {
                Object eleSource = parserContext.extractSource((Object)element);
                RootBeanDefinition sourceDef = new RootBeanDefinition(AnnotationCacheOperationSource.class);
                sourceDef.setSource(eleSource);
                sourceDef.setRole(2);
                String sourceName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)sourceDef);
                RootBeanDefinition interceptorDef = new RootBeanDefinition(CacheInterceptor.class);
                interceptorDef.setSource(eleSource);
                interceptorDef.setRole(2);
                AnnotationDrivenCacheBeanDefinitionParser.registerCacheManagerProperty(element, (BeanDefinition)interceptorDef);
                interceptorDef.getPropertyValues().add("cacheDefinitionSources", (Object)new RuntimeBeanReference(sourceName));
                String interceptorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)interceptorDef);
                RootBeanDefinition advisorDef = new RootBeanDefinition(BeanFactoryCacheOperationSourceAdvisor.class);
                advisorDef.setSource(eleSource);
                advisorDef.setRole(2);
                advisorDef.getPropertyValues().add("cacheDefinitionSource", (Object)new RuntimeBeanReference(sourceName));
                advisorDef.getPropertyValues().add("adviceBeanName", (Object)interceptorName);
                if (element.hasAttribute("order")) {
                    advisorDef.getPropertyValues().add("order", (Object)element.getAttribute("order"));
                }
                parserContext.getRegistry().registerBeanDefinition("org.springframework.cache.config.internalCacheAdvisor", (BeanDefinition)advisorDef);
                CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), eleSource);
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)sourceDef, sourceName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptorDef, interceptorName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)advisorDef, "org.springframework.cache.config.internalCacheAdvisor"));
                parserContext.registerComponent((ComponentDefinition)compositeDef);
            }
        }
    }
}

