/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCacheManager
implements CacheManager {
    private CacheManager[] cacheManagers;

    @Override
    public Cache getCache(String name) {
        Cache cache = null;
        CacheManager[] cacheManagerArray = this.cacheManagers;
        int n = this.cacheManagers.length;
        int n2 = 0;
        while (n2 < n) {
            CacheManager cacheManager = cacheManagerArray[n2];
            cache = cacheManager.getCache(name);
            if (cache != null) {
                return cache;
            }
            ++n2;
        }
        return cache;
    }

    @Override
    public Collection<String> getCacheNames() {
        ArrayList<String> names = new ArrayList<String>();
        CacheManager[] cacheManagerArray = this.cacheManagers;
        int n = this.cacheManagers.length;
        int n2 = 0;
        while (n2 < n) {
            CacheManager manager = cacheManagerArray[n2];
            names.addAll(manager.getCacheNames());
            ++n2;
        }
        return Collections.unmodifiableCollection(names);
    }

    public void setCacheManagers(CacheManager[] cacheManagers) {
        Assert.notEmpty((Object[])cacheManagers, (String)"non-null/empty array required");
        this.cacheManagers = (CacheManager[])cacheManagers.clone();
    }
}

