/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableLoadTimeWeaving;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.LoadTimeWeavingConfigurer;
import org.springframework.context.annotation.Role;
import org.springframework.context.weaving.AspectJWeavingEnabler;
import org.springframework.context.weaving.DefaultContextLoadTimeWeaver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.util.Assert;

@Configuration
public class LoadTimeWeavingConfiguration
implements ImportAware,
BeanClassLoaderAware {
    private Map<String, Object> enableLTW;
    @Autowired(required=false)
    private LoadTimeWeavingConfigurer ltwConfigurer;
    private ClassLoader beanClassLoader;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLTW = importMetadata.getAnnotationAttributes(EnableLoadTimeWeaving.class.getName(), false);
        Assert.notNull(this.enableLTW, (String)("@EnableLoadTimeWeaving is not present on importing class " + importMetadata.getClassName()));
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Bean(name={"loadTimeWeaver"})
    @Role(value=2)
    public LoadTimeWeaver loadTimeWeaver() {
        LoadTimeWeaver loadTimeWeaver = null;
        if (this.ltwConfigurer != null) {
            loadTimeWeaver = this.ltwConfigurer.getLoadTimeWeaver();
        }
        if (loadTimeWeaver == null) {
            loadTimeWeaver = new DefaultContextLoadTimeWeaver(this.beanClassLoader);
        }
        switch ((EnableLoadTimeWeaving.AspectJWeaving)((Object)this.enableLTW.get("aspectjWeaving"))) {
            case DISABLED: {
                break;
            }
            case AUTODETECT: {
                if (this.beanClassLoader.getResource("META-INF/aop.xml") != null) break;
            }
            case ENABLED: {
                AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
            }
        }
        return loadTimeWeaver;
    }
}

