/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.conversation.annotation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.aop.support.AopUtils;
import org.springframework.conversation.annotation.BeginConversationAnnotationParser;
import org.springframework.conversation.annotation.ConversationAnnotationParser;
import org.springframework.conversation.annotation.EndConversationAnnotationParser;
import org.springframework.conversation.interceptor.ConversationAttribute;
import org.springframework.conversation.interceptor.ConversationAttributeSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConversationAttributeSource
implements ConversationAttributeSource {
    private final Set<ConversationAnnotationParser> conversationAnnotationParsers;

    public AnnotationConversationAttributeSource() {
        LinkedHashSet<ConversationAnnotationParser> defaultParsers = new LinkedHashSet<ConversationAnnotationParser>();
        Collections.addAll(defaultParsers, new BeginConversationAnnotationParser(), new EndConversationAnnotationParser());
        this.conversationAnnotationParsers = defaultParsers;
    }

    public AnnotationConversationAttributeSource(ConversationAnnotationParser conversationAnnotationParsers) {
        this(Collections.singleton(conversationAnnotationParsers));
    }

    public AnnotationConversationAttributeSource(Set<ConversationAnnotationParser> parsers) {
        Assert.notNull(parsers, (String)"ConversationAnnotationParsers must not be null");
        this.conversationAnnotationParsers = parsers;
    }

    @Override
    public ConversationAttribute getConversationAttribute(Method method, Class<?> targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        for (ConversationAnnotationParser parser : this.conversationAnnotationParsers) {
            ConversationAttribute attribute = parser.parseConversationAnnotation(specificMethod);
            if (attribute != null) {
                return attribute;
            }
            if (method == specificMethod || (attribute = parser.parseConversationAnnotation(method)) == null) continue;
            return attribute;
        }
        return null;
    }
}

