/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.conversation.manager;

import org.springframework.conversation.manager.ConversationRepository;
import org.springframework.conversation.manager.DefaultConversation;
import org.springframework.conversation.manager.MutableConversation;

public abstract class AbstractConversationRepository
implements ConversationRepository {
    private int defaultTimeout = 0;

    public MutableConversation createNewConversation() {
        DefaultConversation conversation = new DefaultConversation();
        conversation.setTimeout(this.getDefaultConversationTimeout());
        return conversation;
    }

    public MutableConversation createNewChildConversation(MutableConversation parentConversation, boolean isIsolated) {
        MutableConversation childConversation = this.createNewConversation();
        parentConversation.addChildConversation(childConversation, isIsolated);
        childConversation.setTimeout(parentConversation.getTimeout());
        return childConversation;
    }

    public void removeConversation(String id, boolean root) {
        MutableConversation conversation = this.getConversation(id);
        if (conversation == null) {
            return;
        }
        if (root) {
            this.removeConversation((MutableConversation)conversation.getRoot());
        } else {
            this.removeConversation(conversation);
        }
    }

    protected final void removeConversation(MutableConversation conversation) {
        while (conversation.getChildren().size() > 0) {
            this.removeConversation((MutableConversation)conversation.getChildren().get(0));
        }
        MutableConversation parentConversation = (MutableConversation)conversation.getParent();
        if (parentConversation != null) {
            parentConversation.removeChildConversation(conversation);
        }
        conversation.clear();
        conversation.invalidate();
        this.removeSingleConversationObject(conversation);
    }

    protected abstract void removeSingleConversationObject(MutableConversation var1);

    public void setDefaultConversationTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public int getDefaultConversationTimeout() {
        return this.defaultTimeout;
    }
}

