/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.conversation.manager;

import org.springframework.conversation.ConversationManager;
import org.springframework.conversation.ConversationType;
import org.springframework.conversation.manager.ConversationRepository;
import org.springframework.conversation.manager.ConversationResolver;
import org.springframework.conversation.manager.MutableConversation;

public class DefaultConversationManager
implements ConversationManager {
    private ConversationResolver conversationResolver;
    private ConversationRepository conversationRepository;

    public MutableConversation getCurrentConversation() {
        return this.getCurrentConversation(true);
    }

    public MutableConversation getCurrentConversation(boolean createNewIfNotExisting) {
        ConversationResolver resolver = this.getConversationResolver();
        MutableConversation currentConversation = null;
        String conversationId = resolver.getCurrentConversationId();
        if (conversationId != null) {
            ConversationRepository repository = this.getConversationRepository();
            currentConversation = repository.getConversation(conversationId);
        }
        if (currentConversation == null && createNewIfNotExisting) {
            currentConversation = this.beginConversation(ConversationType.NEW);
        }
        return currentConversation;
    }

    public MutableConversation beginConversation(ConversationType conversationType) {
        ConversationRepository repository = this.getConversationRepository();
        ConversationResolver resolver = this.getConversationResolver();
        MutableConversation newConversation = null;
        switch (conversationType) {
            case NEW: {
                this.endCurrentConversation(true);
                newConversation = repository.createNewConversation();
                break;
            }
            case NESTED: 
            case ISOLATED: {
                MutableConversation parentConversation = this.getCurrentConversation(false);
                newConversation = parentConversation != null ? repository.createNewChildConversation(parentConversation, conversationType == ConversationType.ISOLATED) : repository.createNewConversation();
            }
        }
        repository.storeConversation(newConversation);
        resolver.setCurrentConversationId(newConversation.getId());
        return newConversation;
    }

    public void endCurrentConversation(boolean root) {
        MutableConversation currentConversation;
        ConversationResolver resolver = this.getConversationResolver();
        ConversationRepository repository = this.getConversationRepository();
        String currentConversationId = resolver.getCurrentConversationId();
        if (currentConversationId == null) {
            return;
        }
        if (!root && (currentConversation = repository.getConversation(currentConversationId)) != null && currentConversation.getParent() != null) {
            MutableConversation parentConversation = (MutableConversation)currentConversation.getParent();
            resolver.setCurrentConversationId(parentConversation.getId());
        }
        repository.removeConversation(currentConversationId, root);
    }

    public ConversationResolver getConversationResolver() {
        return this.conversationResolver;
    }

    public void setConversationResolver(ConversationResolver conversationResolver) {
        this.conversationResolver = conversationResolver;
    }

    public ConversationRepository getConversationRepository() {
        return this.conversationRepository;
    }

    public void setConversationRepository(ConversationRepository conversationRepository) {
        this.conversationRepository = conversationRepository;
    }
}

