/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.conversation.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.conversation.Conversation;
import org.springframework.conversation.manager.AbstractConversationRepository;
import org.springframework.conversation.manager.MutableConversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransientConversationRepository
extends AbstractConversationRepository {
    private final ConcurrentMap<String, MutableConversation> conversationMap = new ConcurrentHashMap<String, MutableConversation>();
    private final AtomicInteger nextAvailableConversationId = new AtomicInteger(0);

    @Override
    public MutableConversation getConversation(String id) {
        return (MutableConversation)this.conversationMap.get(id);
    }

    @Override
    public void storeConversation(MutableConversation conversation) {
        conversation.setId(this.createNextConversationId());
        this.conversationMap.put(conversation.getId(), conversation);
    }

    @Override
    protected void removeSingleConversationObject(MutableConversation conversation) {
        this.conversationMap.remove(conversation.getId());
    }

    public List<Conversation> getConversations() {
        return new ArrayList<Conversation>(this.conversationMap.values());
    }

    public int size() {
        return this.conversationMap.size();
    }

    protected String createNextConversationId() {
        return Integer.toString(this.nextAvailableConversationId.incrementAndGet());
    }
}

