/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.client.ServiceContext;
import com.sun.xml.internal.ws.handler.HandlerChainsModel;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.HandlerAnnotationProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
implements HandlerResolver {
    private HandlerChainsModel handlerModel;
    private Map<PortInfo, List<Handler>> chainMap;
    private ServiceContext serviceContext;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.handler");

    public HandlerResolverImpl(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.handlerModel = HandlerAnnotationProcessor.buildHandlerChainsModel(serviceContext.getServiceClass());
        this.chainMap = new HashMap<PortInfo, List<Handler>>();
    }

    @Override
    public List<Handler> getHandlerChain(PortInfo portInfo) {
        HandlerAnnotationInfo handlerAnnotationInfo;
        List<Handler> list = this.chainMap.get(portInfo);
        if (list != null) {
            return list;
        }
        if (this.handlerModel != null && (handlerAnnotationInfo = this.handlerModel.getHandlersForPortInfo(portInfo)) != null) {
            list = handlerAnnotationInfo.getHandlers();
            this.serviceContext.setRoles(portInfo.getPortName(), handlerAnnotationInfo.getRoles());
        }
        if (list == null) {
            if (logger.isLoggable(Level.FINE)) {
                this.logGetChain(portInfo);
            }
            list = new ArrayList<Handler>();
        }
        this.chainMap.put(portInfo, list);
        return list;
    }

    private void logGetChain(PortInfo portInfo) {
        logger.fine("No handler chain found for port info:");
        this.logPortInfo(portInfo, Level.FINE);
        logger.fine("Existing handler chains:");
        if (this.chainMap.isEmpty()) {
            logger.fine("none");
        } else {
            for (PortInfo portInfo2 : this.chainMap.keySet()) {
                logger.fine(this.chainMap.get(portInfo2).size() + " handlers for port info ");
                this.logPortInfo(portInfo2, Level.FINE);
            }
        }
    }

    private void logPortInfo(PortInfo portInfo, Level level) {
        logger.log(level, "binding: " + portInfo.getBindingID() + "\nservice: " + portInfo.getServiceName() + "\nport: " + portInfo.getPortName());
    }
}

