/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private volatile transient boolean compiled = false;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient int[] buffer;
    transient GroupHead[] groupNodes;
    private transient int[] temp;
    transient int capturingGroupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node lookbehindEnd = new Node(){

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n == matcher.lookbehindTo;
        }
    };
    static Node accept = new Node();
    static Node lastAccept = new LastNode();

    public static Pattern compile(String string) {
        return new Pattern(string, 0);
    }

    public static Pattern compile(String string, int n) {
        return new Pattern(string, n);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher matcher(CharSequence charSequence) {
        Object object = this;
        synchronized (object) {
            if (!this.compiled) {
                this.compile();
            }
        }
        object = new Matcher(this, charSequence);
        return object;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String string, CharSequence charSequence) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        return matcher.matches();
    }

    public String[] split(CharSequence charSequence, int n) {
        int n2;
        int n3 = 0;
        boolean bl = n > 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = this.matcher(charSequence);
        while (matcher.find()) {
            String string;
            if (!bl || arrayList.size() < n - 1) {
                string = ((Object)charSequence.subSequence(n3, matcher.start())).toString();
                arrayList.add(string);
                n3 = matcher.end();
                continue;
            }
            if (arrayList.size() != n - 1) continue;
            string = ((Object)charSequence.subSequence(n3, charSequence.length())).toString();
            arrayList.add(string);
            n3 = matcher.end();
        }
        if (n3 == 0) {
            return new String[]{((Object)charSequence).toString()};
        }
        if (!bl || arrayList.size() < n) {
            arrayList.add(((Object)charSequence.subSequence(n3, charSequence.length())).toString());
        }
        if (n == 0) {
            for (n2 = arrayList.size(); n2 > 0 && ((String)arrayList.get(n2 - 1)).equals(""); --n2) {
            }
        }
        String[] stringArray = new String[n2];
        return arrayList.subList(0, n2).toArray(stringArray);
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    public static String quote(String string) {
        int n = string.indexOf("\\E");
        if (n == -1) {
            return "\\Q" + string + "\\E";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        stringBuilder.append("\\Q");
        n = 0;
        int n2 = 0;
        while ((n = string.indexOf("\\E", n2)) != -1) {
            stringBuilder.append(string.substring(n2, n));
            n2 = n + 2;
            stringBuilder.append("\\E\\\\E\\Q");
        }
        stringBuilder.append(string.substring(n2, string.length()));
        stringBuilder.append("\\E");
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.capturingGroupCount = 1;
        this.localCount = 0;
        this.compiled = false;
        if (this.pattern.length() == 0) {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
            this.compiled = true;
        }
    }

    private Pattern(String string, int n) {
        this.pattern = string;
        this.flags = n;
        this.capturingGroupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        int n;
        boolean bl = false;
        int n2 = -1;
        this.normalizedPattern = Normalizer.normalize(this.pattern, Normalizer.Form.NFD);
        this.patternLength = this.normalizedPattern.length();
        StringBuilder stringBuilder = new StringBuilder(this.patternLength);
        for (int i = 0; i < this.patternLength; i += Character.charCount(n)) {
            n = this.normalizedPattern.codePointAt(i);
            if (Character.getType(n) == 6 && n2 != -1) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n2);
                stringBuilder2.appendCodePoint(n);
                while (Character.getType(n) == 6 && (i += Character.charCount(n)) < this.patternLength) {
                    n = this.normalizedPattern.codePointAt(i);
                    stringBuilder2.appendCodePoint(n);
                }
                String string = this.produceEquivalentAlternation(stringBuilder2.toString());
                stringBuilder.setLength(stringBuilder.length() - Character.charCount(n2));
                stringBuilder.append("(?:").append(string).append(")");
            } else if (n == 91 && n2 != 92) {
                i = this.normalizeCharClass(stringBuilder, i);
            } else {
                stringBuilder.appendCodePoint(n);
            }
            n2 = n;
        }
        this.normalizedPattern = stringBuilder.toString();
    }

    private int normalizeCharClass(StringBuilder stringBuilder, int n) {
        int n2;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = null;
        int n3 = -1;
        ++n;
        stringBuilder2.append("[");
        while (true) {
            if ((n2 = this.normalizedPattern.codePointAt(n)) == 93 && n3 != 92) break;
            if (Character.getType(n2) == 6) {
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.appendCodePoint(n3);
                while (Character.getType(n2) == 6) {
                    stringBuilder4.appendCodePoint(n2);
                    if ((n += Character.charCount(n2)) >= this.normalizedPattern.length()) break;
                    n2 = this.normalizedPattern.codePointAt(n);
                }
                String string = this.produceEquivalentAlternation(stringBuilder4.toString());
                stringBuilder2.setLength(stringBuilder2.length() - Character.charCount(n3));
                if (stringBuilder3 == null) {
                    stringBuilder3 = new StringBuilder();
                }
                stringBuilder3.append('|');
                stringBuilder3.append(string);
            } else {
                stringBuilder2.appendCodePoint(n2);
                ++n;
            }
            if (n == this.normalizedPattern.length()) {
                throw this.error("Unclosed character class");
            }
            n3 = n2;
        }
        stringBuilder2.append((char)n2);
        String string = stringBuilder3 != null ? "(?:" + stringBuilder2.toString() + stringBuilder3.toString() + ")" : stringBuilder2.toString();
        stringBuilder.append(string);
        return n;
    }

    private String produceEquivalentAlternation(String string) {
        int n = Pattern.countChars(string, 0, 1);
        if (string.length() == n) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        String[] stringArray = this.producePermutations(string3);
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = string2 + stringArray[i];
            if (i > 0) {
                stringBuilder.append("|" + string4);
            }
            if ((string4 = this.composeOneStep(string4)) == null) continue;
            stringBuilder.append("|" + this.produceEquivalentAlternation(string4));
        }
        return stringBuilder.toString();
    }

    private String[] producePermutations(String string) {
        int n;
        int n2;
        if (string.length() == Pattern.countChars(string, 0, 1)) {
            return new String[]{string};
        }
        if (string.length() == Pattern.countChars(string, 0, 2)) {
            int n3 = Character.codePointAt(string, 0);
            int n4 = Character.codePointAt(string, Character.charCount(n3));
            if (this.getClass(n4) == this.getClass(n3)) {
                return new String[]{string};
            }
            String[] stringArray = new String[2];
            stringArray[0] = string;
            StringBuilder stringBuilder = new StringBuilder(2);
            stringBuilder.appendCodePoint(n4);
            stringBuilder.appendCodePoint(n3);
            stringArray[1] = stringBuilder.toString();
            return stringArray;
        }
        int n5 = 1;
        int n6 = Pattern.countCodePoints(string);
        for (int i = 1; i < n6; ++i) {
            n5 *= i + 1;
        }
        String[] stringArray = new String[n5];
        int[] nArray = new int[n6];
        int n7 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            n = Character.codePointAt(string, n7);
            nArray[n2] = this.getClass(n);
            n7 += Character.charCount(n);
        }
        n2 = 0;
        n = 0;
        int n8 = 0;
        while (n < n6) {
            block10: {
                n7 = Pattern.countChars(string, n8, 1);
                boolean bl = false;
                for (int i = n - 1; i >= 0; --i) {
                    if (nArray[i] != nArray[n]) {
                        continue;
                    }
                    break block10;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                String string2 = stringBuilder.delete(n8, n8 + n7).toString();
                String[] stringArray2 = this.producePermutations(string2);
                String string3 = string.substring(n8, n8 + n7);
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[n2++] = string3 + stringArray2[i];
                }
            }
            ++n;
            n8 += n7;
        }
        String[] stringArray3 = new String[n2];
        for (n8 = 0; n8 < n2; ++n8) {
            stringArray3[n8] = stringArray[n8];
        }
        return stringArray3;
    }

    private int getClass(int n) {
        return sun.text.Normalizer.getCombiningClass(n);
    }

    private String composeOneStep(String string) {
        int n = Pattern.countChars(string, 0, 2);
        String string2 = string.substring(0, n);
        String string3 = Normalizer.normalize(string2, Normalizer.Form.NFC);
        if (string3.equals(string2)) {
            return null;
        }
        String string4 = string.substring(n);
        return string3 + string4;
    }

    private void RemoveQEQuoting() {
        for (int i = 0; i < this.patternLength - 1; ++i) {
            if (this.temp[i] != 92 || this.temp[i + 1] != 81) continue;
            int n = i;
            int[] nArray = new int[n + 2 * (this.temp.length - n) - 6];
            System.arraycopy(this.temp, 0, nArray, 0, n);
            i += 2;
            boolean bl = true;
            while (i < this.patternLength) {
                int n2;
                if (!ASCII.isAscii(n2 = this.temp[i++]) || ASCII.isAlnum(n2)) {
                    nArray[n++] = n2;
                    continue;
                }
                if (n2 != 92) {
                    if (bl) {
                        nArray[n++] = 92;
                    }
                    nArray[n++] = n2;
                    continue;
                }
                if (bl) {
                    if (this.temp[i] == 69) {
                        ++i;
                        bl = false;
                        continue;
                    }
                    nArray[n++] = 92;
                    nArray[n++] = 92;
                    continue;
                }
                if (this.temp[i] == 81) {
                    ++i;
                    bl = true;
                    continue;
                }
                nArray[n++] = n2;
            }
            this.patternLength = n;
            int[] nArray2 = new int[this.patternLength + 2];
            System.arraycopy(nArray, 0, nArray2, 0, this.patternLength);
            this.temp = nArray2;
            return;
        }
    }

    private void compile() {
        int n;
        if (this.has(128) && !this.has(16)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new int[this.patternLength + 2];
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < this.patternLength; i += Character.charCount(n)) {
            n = this.normalizedPattern.codePointAt(i);
            if (Pattern.isSupplementary(n)) {
                bl = true;
            }
            this.temp[n2++] = n;
        }
        this.patternLength = n2;
        if (!this.has(16)) {
            this.RemoveQEQuoting();
        }
        this.buffer = new int[32];
        this.groupNodes = new GroupHead[10];
        if (this.has(16)) {
            this.matchRoot = this.newSlice(this.temp, this.patternLength, bl);
            this.matchRoot.next = lastAccept;
        } else {
            this.matchRoot = this.expr(lastAccept);
            if (this.patternLength != this.cursor) {
                if (this.peek() == 41) {
                    throw this.error("Unmatched closing ')'");
                }
                throw this.error("Unexpected internal error");
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = bl ? new StartS(this.matchRoot) : new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : (bl ? new StartS(this.matchRoot) : new Start(this.matchRoot));
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
        this.compiled = true;
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println(node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (node instanceof Loop) {
                System.out.println(node);
                Pattern.printObjectTree(((Loop)node).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println(node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else if (node instanceof GroupCurly) {
                System.out.println(node);
                Pattern.printObjectTree(((GroupCurly)node).atom);
                System.out.println("**** end contents GroupCurly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println(node);
                    System.out.println("Tail next is " + node.next);
                    return;
                }
                System.out.println(node);
            }
            node = node.next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (node != accept) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private boolean has(int n) {
        return (this.flags & n) != 0;
    }

    private void accept(int n, String string) {
        int n2 = this.temp[this.cursor++];
        if (this.has(4)) {
            n2 = this.parsePastWhitespace(n2);
        }
        if (n != n2) {
            throw this.error(string);
        }
    }

    private void mark(int n) {
        this.temp[this.patternLength] = n;
    }

    private int peek() {
        int n = this.temp[this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int read() {
        int n = this.temp[this.cursor++];
        if (this.has(4)) {
            n = this.parsePastWhitespace(n);
        }
        return n;
    }

    private int readEscaped() {
        int n = this.temp[this.cursor++];
        return n;
    }

    private int next() {
        int n = this.temp[++this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int nextEscaped() {
        int n = this.temp[++this.cursor];
        return n;
    }

    private int peekPastWhitespace(int n) {
        while (ASCII.isSpace(n) || n == 35) {
            while (ASCII.isSpace(n)) {
                n = this.temp[++this.cursor];
            }
            if (n != 35) continue;
            n = this.peekPastLine();
        }
        return n;
    }

    private int parsePastWhitespace(int n) {
        while (ASCII.isSpace(n) || n == 35) {
            while (ASCII.isSpace(n)) {
                n = this.temp[this.cursor++];
            }
            if (n != 35) continue;
            n = this.parsePastLine();
        }
        return n;
    }

    private int parsePastLine() {
        int n = this.temp[this.cursor++];
        while (n != 0 && !this.isLineSeparator(n)) {
            n = this.temp[this.cursor++];
        }
        return n;
    }

    private int peekPastLine() {
        int n = this.temp[++this.cursor];
        while (n != 0 && !this.isLineSeparator(n)) {
            n = this.temp[++this.cursor];
        }
        return n;
    }

    private boolean isLineSeparator(int n) {
        if (this.has(1)) {
            return n == 10;
        }
        return n == 10 || n == 13 || (n | 1) == 8233 || n == 133;
    }

    private int skip() {
        int n = this.cursor;
        int n2 = this.temp[n + 1];
        this.cursor = n + 2;
        return n2;
    }

    private void unread() {
        --this.cursor;
    }

    private PatternSyntaxException error(String string) {
        return new PatternSyntaxException(string, this.normalizedPattern, this.cursor - 1);
    }

    private boolean findSupplementary(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!Pattern.isSupplementary(this.temp[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isSupplementary(int n) {
        return n >= 65536 || Pattern.isSurrogate(n);
    }

    private Node expr(Node node) {
        Node node2 = null;
        Node node3 = null;
        BranchConn branchConn = null;
        while (true) {
            Node node4 = this.sequence(node);
            Node node5 = this.root;
            if (node2 == null) {
                node2 = node4;
                node3 = node5;
            } else {
                if (branchConn == null) {
                    branchConn = new BranchConn();
                    branchConn.next = node;
                }
                if (node4 == node) {
                    node4 = null;
                } else {
                    node5.next = branchConn;
                }
                if (node2 instanceof Branch) {
                    ((Branch)node2).add(node4);
                } else {
                    if (node2 == node) {
                        node2 = null;
                    } else {
                        node3.next = branchConn;
                    }
                    node2 = new Branch(node2, node4, branchConn);
                }
            }
            if (this.peek() != 124) {
                return node2;
            }
            this.next();
        }
    }

    private Node sequence(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        block12: while (true) {
            int n = this.peek();
            switch (n) {
                case 40: {
                    node4 = this.group0();
                    if (node4 == null) continue block12;
                    if (node2 == null) {
                        node2 = node4;
                    } else {
                        node3.next = node4;
                    }
                    node3 = this.root;
                    continue block12;
                }
                case 91: {
                    node4 = this.clazz(true);
                    break;
                }
                case 92: {
                    n = this.nextEscaped();
                    if (n == 112 || n == 80) {
                        boolean bl = true;
                        boolean bl2 = n == 80;
                        n = this.next();
                        if (n != 123) {
                            this.unread();
                        } else {
                            bl = false;
                        }
                        node4 = this.family(bl).maybeComplement(bl2);
                        break;
                    }
                    this.unread();
                    node4 = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node4 = new UnixCaret();
                            break;
                        }
                        node4 = new Caret();
                        break;
                    }
                    node4 = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node4 = new UnixDollar(this.has(8));
                        break;
                    }
                    node4 = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node4 = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node4 = new UnixDot();
                        break;
                    }
                    node4 = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node4 = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    throw this.error("Dangling meta character '" + (char)n + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node4 = this.atom();
                }
            }
            node4 = this.closure(node4);
            if (node2 == null) {
                node2 = node3 = node4;
                continue;
            }
            node3.next = node4;
            node3 = node4;
        }
        if (node2 == null) {
            return node;
        }
        node3.next = node;
        this.root = node3;
        return node2;
    }

    private Node atom() {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        int n3 = this.peek();
        block6: while (true) {
            switch (n3) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (n <= true) break block6;
                    this.cursor = n2;
                    --n;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    n3 = this.nextEscaped();
                    if (n3 == 112 || n3 == 80) {
                        if (n > 0) {
                            this.unread();
                            break block6;
                        }
                        boolean bl2 = n3 == 80;
                        boolean bl3 = true;
                        n3 = this.next();
                        if (n3 != 123) {
                            this.unread();
                        } else {
                            bl3 = false;
                        }
                        return this.family(bl3).maybeComplement(bl2);
                    }
                    this.unread();
                    n2 = this.cursor;
                    n3 = this.escape(false, n == 0);
                    if (n3 >= 0) {
                        this.append(n3, n);
                        ++n;
                        if (Pattern.isSupplementary(n3)) {
                            bl = true;
                        }
                        n3 = this.peek();
                        continue block6;
                    }
                    if (n == 0) {
                        return this.root;
                    }
                    this.cursor = n2;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    n2 = this.cursor;
                    this.append(n3, n);
                    ++n;
                    if (Pattern.isSupplementary(n3)) {
                        bl = true;
                    }
                    n3 = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (n == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, n, bl);
    }

    private void append(int n, int n2) {
        if (n2 >= this.buffer.length) {
            int[] nArray = new int[n2 + n2];
            System.arraycopy(this.buffer, 0, nArray, 0, n2);
            this.buffer = nArray;
        }
        this.buffer[n2] = n;
    }

    private Node ref(int n) {
        boolean bl = false;
        block3: while (!bl) {
            int n2 = this.peek();
            switch (n2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n3 = n * 10 + (n2 - 48);
                    if (this.capturingGroupCount - 1 < n3) {
                        bl = true;
                        continue block3;
                    }
                    n = n3;
                    this.read();
                    continue block3;
                }
            }
            bl = true;
        }
        if (this.has(2) || this.has(64)) {
            return new CIBackRef(n);
        }
        return new BackRef(n);
    }

    private int escape(boolean bl, boolean bl2) {
        int n = this.skip();
        switch (n) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl) break;
                if (bl2) {
                    this.root = this.ref(n - 48);
                }
                return -1;
            }
            case 65: {
                if (bl) break;
                if (bl2) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.NONE);
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (bl2) {
                    this.root = new Ctype(1024).complement();
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (bl) break;
                if (bl2) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 83: {
                if (bl2) {
                    this.root = new Ctype(2048).complement();
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (bl2) {
                    this.root = new Ctype(67328).complement();
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (bl) break;
                if (bl2) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.BOTH);
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (bl2) {
                    this.root = new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (bl2) {
                    this.root = new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (bl2) {
                    this.root = new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (bl) break;
                if (bl2) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return n;
            }
        }
        throw this.error("Illegal/unsupported escape squence");
    }

    private CharProperty clazz(boolean bl) {
        CharProperty charProperty = null;
        CharProperty charProperty2 = null;
        BitClass bitClass = new BitClass();
        boolean bl2 = true;
        boolean bl3 = true;
        int n = this.next();
        block7: while (true) {
            switch (n) {
                case 94: {
                    if (!bl3 || this.temp[this.cursor - 1] != 91) break;
                    n = this.next();
                    bl2 = !bl2;
                    continue block7;
                }
                case 91: {
                    bl3 = false;
                    charProperty2 = this.clazz(true);
                    charProperty = charProperty == null ? charProperty2 : Pattern.union(charProperty, charProperty2);
                    n = this.peek();
                    continue block7;
                }
                case 38: {
                    bl3 = false;
                    n = this.next();
                    if (n == 38) {
                        n = this.next();
                        CharProperty charProperty3 = null;
                        while (n != 93 && n != 38) {
                            if (n == 91) {
                                charProperty3 = charProperty3 == null ? this.clazz(true) : Pattern.union(charProperty3, this.clazz(true));
                            } else {
                                this.unread();
                                charProperty3 = this.clazz(false);
                            }
                            n = this.peek();
                        }
                        if (charProperty3 != null) {
                            charProperty2 = charProperty3;
                        }
                        if (charProperty == null) {
                            if (charProperty3 == null) {
                                throw this.error("Bad class syntax");
                            }
                            charProperty = charProperty3;
                            continue block7;
                        }
                        charProperty = Pattern.intersection(charProperty, charProperty2);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    bl3 = false;
                    if (this.cursor < this.patternLength) break;
                    throw this.error("Unclosed character class");
                }
                case 93: {
                    bl3 = false;
                    if (charProperty == null) break;
                    if (bl) {
                        this.next();
                    }
                    return charProperty;
                }
                default: {
                    bl3 = false;
                }
            }
            charProperty2 = this.range(bitClass);
            if (bl2) {
                if (charProperty == null) {
                    charProperty = charProperty2;
                } else if (charProperty != charProperty2) {
                    charProperty = Pattern.union(charProperty, charProperty2);
                }
            } else if (charProperty == null) {
                charProperty = charProperty2.complement();
            } else if (charProperty != charProperty2) {
                charProperty = Pattern.setDifference(charProperty, charProperty2);
            }
            n = this.peek();
        }
    }

    private CharProperty range(BitClass bitClass) {
        int n = this.peek();
        if (n == 92) {
            n = this.nextEscaped();
            if (n == 112 || n == 80) {
                boolean bl = n == 80;
                boolean bl2 = true;
                n = this.next();
                if (n != 123) {
                    this.unread();
                } else {
                    bl2 = false;
                }
                return this.family(bl2).maybeComplement(bl);
            }
            this.unread();
            n = this.escape(true, true);
            if (n == -1) {
                return (CharProperty)this.root;
            }
        } else {
            n = this.single();
        }
        if (n >= 0) {
            if (this.peek() == 45) {
                int n2 = this.temp[this.cursor + 1];
                if (n2 == 91) {
                    if (n < 256) {
                        return bitClass.add(n, this.flags());
                    }
                    return this.newSingle(n);
                }
                if (n2 != 93) {
                    this.next();
                    int n3 = this.single();
                    if (n3 < n) {
                        throw this.error("Illegal character range");
                    }
                    if (this.has(2) || this.has(64)) {
                        return Pattern.caseInsensitiveRangeFor(n, n3);
                    }
                    return Pattern.rangeFor(n, n3);
                }
            }
            if (n < 256) {
                return bitClass.add(n, this.flags());
            }
            return this.newSingle(n);
        }
        throw this.error("Unexpected character '" + (char)n + "'");
    }

    private int single() {
        int n = this.peek();
        switch (n) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return n;
    }

    private CharProperty family(boolean bl) {
        String string;
        this.next();
        if (bl) {
            int n = this.temp[this.cursor];
            string = !Character.isSupplementaryCodePoint(n) ? String.valueOf((char)n) : new String(this.temp, this.cursor, 1);
            this.read();
        } else {
            int n = this.cursor;
            this.mark(125);
            while (this.read() != 125) {
            }
            this.mark(0);
            int n2 = this.cursor;
            if (n2 > this.patternLength) {
                throw this.error("Unclosed character family");
            }
            if (n + 1 >= n2) {
                throw this.error("Empty character family");
            }
            string = new String(this.temp, n, n2 - n - 1);
        }
        if (string.startsWith("In")) {
            return this.unicodeBlockPropertyFor(string.substring(2));
        }
        if (string.startsWith("Is")) {
            string = string.substring(2);
        }
        return this.charPropertyNodeFor(string);
    }

    private CharProperty unicodeBlockPropertyFor(String string) {
        Character.UnicodeBlock unicodeBlock;
        try {
            unicodeBlock = Character.UnicodeBlock.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.error("Unknown character block name {" + string + "}");
        }
        return new CharProperty(){

            boolean isSatisfiedBy(int n) {
                return unicodeBlock == Character.UnicodeBlock.of(n);
            }
        };
    }

    private CharProperty charPropertyNodeFor(String string) {
        CharProperty charProperty = CharPropertyNames.charPropertyFor(string);
        if (charProperty == null) {
            throw this.error("Unknown character property name {" + string + "}");
        }
        return charProperty;
    }

    private Node group0() {
        Object object;
        boolean bl = false;
        Node node = null;
        Node node2 = null;
        int n = this.flags;
        this.root = null;
        int n2 = this.next();
        if (n2 == 63) {
            n2 = this.skip();
            switch (n2) {
                case 58: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
                case 33: 
                case 61: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    if (n2 == 61) {
                        node = node2 = new Pos(node);
                        break;
                    }
                    node = node2 = new Neg(node);
                    break;
                }
                case 62: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node = node2 = new Ques(node, 3);
                    break;
                }
                case 60: {
                    n2 = this.read();
                    int n3 = this.cursor;
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node2.next = lookbehindEnd;
                    object = new TreeInfo();
                    node.study((TreeInfo)object);
                    if (!((TreeInfo)object).maxValid) {
                        throw this.error("Look-behind group does not have an obvious maximum length");
                    }
                    boolean bl2 = this.findSupplementary(n3, this.patternLength);
                    if (n2 == 61) {
                        node2 = bl2 ? new BehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new Behind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    if (n2 == 33) {
                        node2 = bl2 ? new NotBehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new NotBehind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    throw this.error("Unknown look-behind group");
                }
                case 36: 
                case 64: {
                    throw this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    n2 = this.read();
                    if (n2 == 41) {
                        return null;
                    }
                    if (n2 != 58) {
                        throw this.error("Unknown inline modifier");
                    }
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
            }
        } else {
            bl = true;
            node = this.createGroup(false);
            node2 = this.root;
            node.next = this.expr(node2);
        }
        this.accept(41, "Unclosed group");
        this.flags = n;
        Node node3 = this.closure(node);
        if (node3 == node) {
            this.root = node2;
            return node3;
        }
        if (node == node2) {
            this.root = node3;
            return node3;
        }
        if (node3 instanceof Ques) {
            object = (Ques)node3;
            if (((Ques)object).type == 2) {
                this.root = node3;
                return node3;
            }
            node2 = node2.next = new BranchConn();
            node = ((Ques)object).type == 0 ? new Branch(node, null, node2) : new Branch(null, node, node2);
            this.root = node2;
            return node;
        }
        if (node3 instanceof Curly) {
            object = (Curly)node3;
            if (((Curly)object).type == 2) {
                this.root = node3;
                return node3;
            }
            TreeInfo treeInfo = new TreeInfo();
            if (node.study(treeInfo)) {
                GroupTail groupTail = (GroupTail)node2;
                node = this.root = new GroupCurly(node.next, ((Curly)object).cmin, ((Curly)object).cmax, ((Curly)object).type, ((GroupTail)node2).localIndex, ((GroupTail)node2).groupIndex, bl);
                return node;
            }
            int n4 = ((GroupHead)node).localIndex;
            Loop loop = ((Curly)object).type == 0 ? new Loop(this.localCount, n4) : new LazyLoop(this.localCount, n4);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = ((Curly)object).cmin;
            loop.cmax = ((Curly)object).cmax;
            loop.body = node;
            node2.next = loop;
            this.root = loop;
            return prolog;
        }
        throw this.error("Internal logic error");
    }

    private Node createGroup(boolean bl) {
        int n = this.localCount++;
        int n2 = 0;
        if (!bl) {
            n2 = this.capturingGroupCount++;
        }
        GroupHead groupHead = new GroupHead(n);
        this.root = new GroupTail(n, n2);
        if (!bl && n2 < 10) {
            this.groupNodes[n2] = groupHead;
        }
        return groupHead;
    }

    private void addFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 45: {
                    n = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private void subFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private Node closure(Node node) {
        int n = this.peek();
        switch (n) {
            case 63: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Ques(node, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Ques(node, 2);
                }
                return new Ques(node, 0);
            }
            case 42: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                n = this.temp[this.cursor + 1];
                if (ASCII.isDigit(n)) {
                    Curly curly;
                    this.skip();
                    int n2 = 0;
                    do {
                        n2 = n2 * 10 + (n - 48);
                    } while (ASCII.isDigit(n = this.read()));
                    int n3 = n2;
                    if (n == 44) {
                        n = this.read();
                        n3 = Integer.MAX_VALUE;
                        if (n != 125) {
                            n3 = 0;
                            while (ASCII.isDigit(n)) {
                                n3 = n3 * 10 + (n - 48);
                                n = this.read();
                            }
                        }
                    }
                    if (n != 125) {
                        throw this.error("Unclosed counted closure");
                    }
                    if ((n2 | n3 | n3 - n2) < 0) {
                        throw this.error("Illegal repetition range");
                    }
                    n = this.peek();
                    if (n == 63) {
                        this.next();
                        curly = new Curly(node, n2, n3, 1);
                    } else if (n == 43) {
                        this.next();
                        curly = new Curly(node, n2, n3, 2);
                    } else {
                        curly = new Curly(node, n2, n3, 0);
                    }
                    return curly;
                }
                throw this.error("Illegal repetition");
            }
        }
        return node;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        throw this.error("Illegal control escape sequence");
    }

    private int o() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int n2 = this.read();
            if ((n2 - 48 | 55 - n2) >= 0) {
                int n3 = this.read();
                if ((n3 - 48 | 55 - n3) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (n2 - 48) * 8 + (n3 - 48);
                }
                this.unread();
                return (n - 48) * 8 + (n2 - 48);
            }
            this.unread();
            return n - 48;
        }
        throw this.error("Illegal octal escape sequence");
    }

    private int x() {
        int n;
        int n2 = this.read();
        if (ASCII.isHexDigit(n2) && ASCII.isHexDigit(n = this.read())) {
            return ASCII.toDigit(n2) * 16 + ASCII.toDigit(n);
        }
        throw this.error("Illegal hexadecimal escape sequence");
    }

    private int u() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.read();
            if (!ASCII.isHexDigit(n2)) {
                throw this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + ASCII.toDigit(n2);
        }
        return n;
    }

    private static final boolean isSurrogate(int n) {
        return n >= 55296 && n <= 57343;
    }

    private static final int countChars(CharSequence charSequence, int n, int n2) {
        if (n2 == 1 && !Character.isHighSurrogate(charSequence.charAt(n))) {
            assert (n >= 0 && n < charSequence.length());
            return 1;
        }
        int n3 = charSequence.length();
        int n4 = n;
        if (n2 >= 0) {
            assert (n >= 0 && n < n3);
            for (int i = 0; n4 < n3 && i < n2; ++i) {
                if (!Character.isHighSurrogate(charSequence.charAt(n4++)) || n4 >= n3 || !Character.isLowSurrogate(charSequence.charAt(n4))) continue;
                ++n4;
            }
            return n4 - n;
        }
        assert (n >= 0 && n <= n3);
        if (n == 0) {
            return 0;
        }
        int n5 = -n2;
        for (int i = 0; n4 > 0 && i < n5; ++i) {
            if (!Character.isLowSurrogate(charSequence.charAt(--n4)) || n4 <= 0 || !Character.isHighSurrogate(charSequence.charAt(n4 - 1))) continue;
            --n4;
        }
        return n - n4;
    }

    private static final int countCodePoints(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ++n2;
            if (!Character.isHighSurrogate(charSequence.charAt(n3++)) || n3 >= n || !Character.isLowSurrogate(charSequence.charAt(n3))) continue;
            ++n3;
        }
        return n2;
    }

    private CharProperty newSingle(final int n) {
        if (this.has(64)) {
            final int n2 = Character.toLowerCase(Character.toUpperCase(n));
            return new CharProperty(){

                boolean isSatisfiedBy(int n) {
                    return n == n2 || Character.toLowerCase(Character.toUpperCase(n)) == n2;
                }
            };
        }
        if (this.has(2) && ASCII.isAscii(n)) {
            final int n3 = ASCII.toLower(n);
            return new BmpCharProperty(){

                boolean isSatisfiedBy(int n) {
                    return n == n3 || ASCII.toLower(n) == n3;
                }
            };
        }
        if (Pattern.isSupplementary(n)) {
            return new CharProperty(){

                boolean isSatisfiedBy(int n2) {
                    return n == n2;
                }
            };
        }
        return new BmpCharProperty(){

            boolean isSatisfiedBy(int n2) {
                return n == n2;
            }
        };
    }

    private Node newSlice(int[] nArray, int n, boolean bl) {
        int[] nArray2 = new int[n];
        int n2 = this.flags;
        if ((n2 & 0x42) == 0) {
            for (n2 = 0; n2 < n; ++n2) {
                nArray2[n2] = nArray[n2];
            }
            return bl ? new SliceS(nArray2) : new Slice(nArray2);
        }
        if ((n2 & 0x40) == 0) {
            for (n2 = 0; n2 < n; ++n2) {
                nArray2[n2] = (char)ASCII.toLower(nArray[n2]);
            }
            return new SliceA(nArray2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = nArray[n2];
            n3 = Character.toUpperCase(n3);
            nArray2[n2] = n3 = Character.toLowerCase(n3);
        }
        return new SliceU(nArray2);
    }

    private static boolean inRange(int n, int n2, int n3) {
        return n <= n2 && n2 <= n3;
    }

    private static CharProperty rangeFor(final int n, final int n2) {
        return new CharProperty(){

            boolean isSatisfiedBy(int n3) {
                return Pattern.inRange(n, n3, n2);
            }
        };
    }

    private static CharProperty caseInsensitiveRangeFor(final int n, final int n2) {
        return new CharProperty(){

            boolean isSatisfiedBy(int n3) {
                return Pattern.inRange(n, n3, n2) || Pattern.inRange(n, Character.toUpperCase(n3), n2) || Pattern.inRange(n, Character.toLowerCase(n3), n2);
            }
        };
    }

    private static CharProperty union(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            boolean isSatisfiedBy(int n) {
                return charProperty.isSatisfiedBy(n) || charProperty2.isSatisfiedBy(n);
            }
        };
    }

    private static CharProperty intersection(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            boolean isSatisfiedBy(int n) {
                return charProperty.isSatisfiedBy(n) && charProperty2.isSatisfiedBy(n);
            }
        };
    }

    private static CharProperty setDifference(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            boolean isSatisfiedBy(int n) {
                return !charProperty2.isSatisfiedBy(n) && charProperty.isSatisfiedBy(n);
            }
        };
    }

    private static boolean hasBaseCharacter(Matcher matcher, int n, CharSequence charSequence) {
        int n2 = !matcher.transparentBounds ? matcher.from : 0;
        for (int i = n; i >= n2; --i) {
            int n3 = Character.codePointAt(charSequence, i);
            if (Character.isLetterOrDigit(n3)) {
                return true;
            }
            if (Character.getType(n3) == 6) continue;
            return false;
        }
        return false;
    }

    static final class All
    extends CharProperty {
        All() {
        }

        boolean isSatisfiedBy(int n) {
            return true;
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int n) {
            this.groupIndex = n + n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.groups[this.groupIndex];
            int n3 = matcher.groups[this.groupIndex + 1];
            int n4 = n3 - n2;
            if (n2 < 0) {
                return false;
            }
            if (n + n4 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                if (charSequence.charAt(n + i) == charSequence.charAt(n2 + i)) continue;
                return false;
            }
            return this.next.match(matcher, n + n4, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.from : 0;
            if (n == n2 && this.next.match(matcher, n, charSequence)) {
                matcher.first = n;
                matcher.groups[0] = n;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.from;
            boolean bl = false;
            int n3 = !matcher.transparentBounds ? matcher.from : 0;
            int n4 = Math.max(n - this.rmax, n3);
            int n5 = matcher.lookbehindTo;
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - this.rmin; !bl && i >= n4; --i) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n2;
            matcher.lookbehindTo = n5;
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node node, int n, int n2) {
            super(node, n, n2);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = Pattern.countChars(charSequence, n, -this.rmax);
            int n3 = Pattern.countChars(charSequence, n, -this.rmin);
            int n4 = matcher.from;
            int n5 = !matcher.transparentBounds ? matcher.from : 0;
            boolean bl = false;
            int n6 = Math.max(n - n2, n5);
            int n7 = matcher.lookbehindTo;
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - n3; !bl && i >= n6; i -= i > n6 ? Pattern.countChars(charSequence, i, -1) : 1) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n4;
            matcher.lookbehindTo = n7;
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    private static final class BitClass
    extends BmpCharProperty {
        final boolean[] bits;

        BitClass() {
            this.bits = new boolean[256];
        }

        private BitClass(boolean[] blArray) {
            this.bits = blArray;
        }

        BitClass add(int n, int n2) {
            assert (n >= 0 && n <= 255);
            if ((n2 & 2) == 0) {
                this.bits[n] = true;
            } else if (ASCII.isAscii(n)) {
                this.bits[ASCII.toUpper((int)n)] = true;
                this.bits[ASCII.toLower((int)n)] = true;
            } else {
                this.bits[Character.toLowerCase((char)((char)n))] = true;
                this.bits[Character.toUpperCase((char)((char)n))] = true;
            }
            return this;
        }

        boolean isSatisfiedBy(int n) {
            return n > 255 ? false : this.bits[n];
        }
    }

    private static abstract class BmpCharProperty
    extends CharProperty {
        private BmpCharProperty() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                return this.isSatisfiedBy(charSequence.charAt(n)) && this.next.match(matcher, n + 1, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int n;
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] nArray = ((Slice)node).buffer;
            int n2 = nArray.length;
            if (n2 < 4) {
                return node;
            }
            int[] nArray2 = new int[128];
            int[] nArray3 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[nArray[n] & 0x7F] = n + 1;
            }
            block1: for (n = n2; n > 0; --n) {
                int n3;
                for (n3 = n2 - 1; n3 >= n; --n3) {
                    if (nArray[n3] != nArray[n3 - n]) continue block1;
                    nArray3[n3 - 1] = n;
                }
                while (n3 > 0) {
                    nArray3[--n3] = n;
                }
            }
            nArray3[n2 - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(nArray, nArray2, nArray3, node.next);
            }
            return new BnM(nArray, nArray2, nArray3, node.next);
        }

        BnM(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            this.buffer = nArray;
            this.lastOcc = nArray2;
            this.optoSft = nArray3;
            this.next = node;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            int n3 = matcher.to - n2;
            block0: while (n <= n3) {
                int n4;
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    char c = charSequence.charAt(n + n4);
                    if (c == nArray[n4]) continue;
                    n += Math.max(n4 + 1 - this.lastOcc[c & 0x7F], this.optoSft[n4]);
                    continue block0;
                }
                matcher.first = n;
                n4 = this.next.match(matcher, n + n2, charSequence) ? 1 : 0;
                if (n4 != 0) {
                    matcher.groups[0] = matcher.first = n;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n;
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            super(nArray, nArray2, nArray3, node);
            for (int i = 0; i < this.buffer.length; ++i) {
                this.lengthInChars += Character.charCount(this.buffer[i]);
            }
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            int n3 = matcher.to - this.lengthInChars;
            block0: while (n <= n3) {
                int n4 = Pattern.countChars(charSequence, n, n2);
                int n5 = n2 - 1;
                while (n4 > 0) {
                    int n6 = Character.codePointBefore(charSequence, n + n4);
                    if (n6 != nArray[n5]) {
                        int n7 = Math.max(n5 + 1 - this.lastOcc[n6 & 0x7F], this.optoSft[n5]);
                        n += Pattern.countChars(charSequence, n, n7);
                        continue block0;
                    }
                    n4 -= Character.charCount(n6);
                    --n5;
                }
                matcher.first = n;
                n4 = this.next.match(matcher, n + this.lengthInChars, charSequence) ? 1 : 0;
                if (n4 != 0) {
                    matcher.groups[0] = matcher.first = n;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                n += Pattern.countChars(charSequence, n, 1);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;

        Bound(int n) {
            this.type = n;
        }

        int check(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            boolean bl = false;
            int n3 = matcher.from;
            int n4 = matcher.to;
            if (matcher.transparentBounds) {
                n3 = 0;
                n4 = matcher.getTextLength();
            }
            if (n > n3) {
                n2 = Character.codePointBefore(charSequence, n);
                bl = n2 == 95 || Character.isLetterOrDigit(n2) || Character.getType(n2) == 6 && Pattern.hasBaseCharacter(matcher, n - 1, charSequence);
            }
            boolean bl2 = false;
            if (n < n4) {
                n2 = Character.codePointAt(charSequence, n);
                bl2 = n2 == 95 || Character.isLetterOrDigit(n2) || Character.getType(n2) == 6 && Pattern.hasBaseCharacter(matcher, n, charSequence);
            } else {
                matcher.hitEnd = true;
                matcher.requireEnd = true;
            }
            return bl ^ bl2 ? (bl2 ? LEFT : RIGHT) : NONE;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return (this.check(matcher, n, charSequence) & this.type) > 0 && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Branch
    extends Node {
        Node[] atoms = new Node[2];
        int size = 2;
        Node conn;

        Branch(Node node, Node node2, Node node3) {
            this.conn = node3;
            this.atoms[0] = node;
            this.atoms[1] = node2;
        }

        void add(Node node) {
            if (this.size >= this.atoms.length) {
                Node[] nodeArray = new Node[this.atoms.length * 2];
                System.arraycopy(this.atoms, 0, nodeArray, 0, this.atoms.length);
                this.atoms = nodeArray;
            }
            this.atoms[this.size++] = node;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.atoms[i] == null ? this.conn.next.match(matcher, n, charSequence) : this.atoms[i].match(matcher, n, charSequence))) continue;
                return true;
            }
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            int n3 = Integer.MAX_VALUE;
            int n4 = -1;
            for (int i = 0; i < this.size; ++i) {
                treeInfo.reset();
                if (this.atoms[i] != null) {
                    this.atoms[i].study(treeInfo);
                }
                n3 = Math.min(n3, treeInfo.minLength);
                n4 = Math.max(n4, treeInfo.maxLength);
                bl &= treeInfo.maxValid;
            }
            treeInfo.reset();
            this.conn.next.study(treeInfo);
            treeInfo.minLength += (n += n3);
            treeInfo.maxLength += (n2 += n4);
            treeInfo.maxValid &= bl;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class BranchConn
    extends Node {
        BranchConn() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            return treeInfo.deterministic;
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;

        CIBackRef(int n) {
            this.groupIndex = n + n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.groups[this.groupIndex];
            int n3 = matcher.groups[this.groupIndex + 1];
            int n4 = n3 - n2;
            if (n2 < 0) {
                return false;
            }
            if (n + n4 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n5 = n;
            for (int i = 0; i < n4; ++i) {
                int n6;
                int n7;
                int n8;
                int n9 = Character.codePointAt(charSequence, n5);
                if (n9 != (n8 = Character.codePointAt(charSequence, n2)) && (n7 = Character.toUpperCase(n9)) != (n6 = Character.toUpperCase(n8)) && (n7 = Character.toLowerCase(n7)) != (n6 = Character.toLowerCase(n6))) {
                    return false;
                }
                n5 += Character.charCount(n9);
                n2 += Character.charCount(n8);
            }
            return this.next.match(matcher, n + n4, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.from;
            int n3 = matcher.to;
            if (!matcher.anchoringBounds) {
                n2 = 0;
                n3 = matcher.getTextLength();
            }
            if (n == n3) {
                matcher.hitEnd = true;
                return false;
            }
            if (n > n2) {
                char c = charSequence.charAt(n - 1);
                if (c != '\n' && c != '\r' && (c | '\u0001') != 8233 && c != '\u0085') {
                    return false;
                }
                if (c == '\r' && charSequence.charAt(n) == '\n') {
                    return false;
                }
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class Category
    extends CharProperty {
        final int typeMask;

        Category(int n) {
            this.typeMask = n;
        }

        boolean isSatisfiedBy(int n) {
            return (this.typeMask & 1 << Character.getType(n)) != 0;
        }
    }

    private static abstract class CharProperty
    extends Node {
        private CharProperty() {
        }

        abstract boolean isSatisfiedBy(int var1);

        CharProperty complement() {
            return new CharProperty(){

                boolean isSatisfiedBy(int n) {
                    return !CharProperty.this.isSatisfiedBy(n);
                }
            };
        }

        CharProperty maybeComplement(boolean bl) {
            return bl ? this.complement() : this;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                int n2 = Character.codePointAt(charSequence, n);
                return this.isSatisfiedBy(n2) && this.next.match(matcher, n + Character.charCount(n2), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    private static class CharPropertyNames {
        private static final HashMap<String, CharPropertyFactory> map = new HashMap();

        private CharPropertyNames() {
        }

        static CharProperty charPropertyFor(String string) {
            CharPropertyFactory charPropertyFactory = map.get(string);
            return charPropertyFactory == null ? null : charPropertyFactory.make();
        }

        private static void defCategory(String string, final int n) {
            map.put(string, new CharPropertyFactory(){

                CharProperty make() {
                    return new Category(n);
                }
            });
        }

        private static void defRange(String string, final int n, final int n2) {
            map.put(string, new CharPropertyFactory(){

                CharProperty make() {
                    return Pattern.rangeFor(n, n2);
                }
            });
        }

        private static void defCtype(String string, final int n) {
            map.put(string, new CharPropertyFactory(){

                CharProperty make() {
                    return new Ctype(n);
                }
            });
        }

        private static void defClone(String string, final CloneableProperty cloneableProperty) {
            map.put(string, new CharPropertyFactory(){

                CharProperty make() {
                    return cloneableProperty.clone();
                }
            });
        }

        static {
            CharPropertyNames.defCategory("Cn", 1);
            CharPropertyNames.defCategory("Lu", 2);
            CharPropertyNames.defCategory("Ll", 4);
            CharPropertyNames.defCategory("Lt", 8);
            CharPropertyNames.defCategory("Lm", 16);
            CharPropertyNames.defCategory("Lo", 32);
            CharPropertyNames.defCategory("Mn", 64);
            CharPropertyNames.defCategory("Me", 128);
            CharPropertyNames.defCategory("Mc", 256);
            CharPropertyNames.defCategory("Nd", 512);
            CharPropertyNames.defCategory("Nl", 1024);
            CharPropertyNames.defCategory("No", 2048);
            CharPropertyNames.defCategory("Zs", 4096);
            CharPropertyNames.defCategory("Zl", 8192);
            CharPropertyNames.defCategory("Zp", 16384);
            CharPropertyNames.defCategory("Cc", 32768);
            CharPropertyNames.defCategory("Cf", 65536);
            CharPropertyNames.defCategory("Co", 262144);
            CharPropertyNames.defCategory("Cs", 524288);
            CharPropertyNames.defCategory("Pd", 0x100000);
            CharPropertyNames.defCategory("Ps", 0x200000);
            CharPropertyNames.defCategory("Pe", 0x400000);
            CharPropertyNames.defCategory("Pc", 0x800000);
            CharPropertyNames.defCategory("Po", 0x1000000);
            CharPropertyNames.defCategory("Sm", 0x2000000);
            CharPropertyNames.defCategory("Sc", 0x4000000);
            CharPropertyNames.defCategory("Sk", 0x8000000);
            CharPropertyNames.defCategory("So", 0x10000000);
            CharPropertyNames.defCategory("Pi", 0x20000000);
            CharPropertyNames.defCategory("Pf", 0x40000000);
            CharPropertyNames.defCategory("L", 62);
            CharPropertyNames.defCategory("M", 448);
            CharPropertyNames.defCategory("N", 3584);
            CharPropertyNames.defCategory("Z", 28672);
            CharPropertyNames.defCategory("C", 884736);
            CharPropertyNames.defCategory("P", 1643118592);
            CharPropertyNames.defCategory("S", 0x1E000000);
            CharPropertyNames.defCategory("LC", 14);
            CharPropertyNames.defCategory("LD", 574);
            CharPropertyNames.defRange("L1", 0, 255);
            map.put("all", new CharPropertyFactory(){

                CharProperty make() {
                    return new All();
                }
            });
            CharPropertyNames.defRange("ASCII", 0, 127);
            CharPropertyNames.defCtype("Alnum", 1792);
            CharPropertyNames.defCtype("Alpha", 768);
            CharPropertyNames.defCtype("Blank", 16384);
            CharPropertyNames.defCtype("Cntrl", 8192);
            CharPropertyNames.defRange("Digit", 48, 57);
            CharPropertyNames.defCtype("Graph", 5888);
            CharPropertyNames.defRange("Lower", 97, 122);
            CharPropertyNames.defRange("Print", 32, 126);
            CharPropertyNames.defCtype("Punct", 4096);
            CharPropertyNames.defCtype("Space", 2048);
            CharPropertyNames.defRange("Upper", 65, 90);
            CharPropertyNames.defCtype("XDigit", 32768);
            CharPropertyNames.defClone("javaLowerCase", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isLowerCase(n);
                }
            });
            CharPropertyNames.defClone("javaUpperCase", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isUpperCase(n);
                }
            });
            CharPropertyNames.defClone("javaTitleCase", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isTitleCase(n);
                }
            });
            CharPropertyNames.defClone("javaDigit", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isDigit(n);
                }
            });
            CharPropertyNames.defClone("javaDefined", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isDefined(n);
                }
            });
            CharPropertyNames.defClone("javaLetter", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isLetter(n);
                }
            });
            CharPropertyNames.defClone("javaLetterOrDigit", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isLetterOrDigit(n);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierStart", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isJavaIdentifierStart(n);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierPart", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isJavaIdentifierPart(n);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierStart", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isUnicodeIdentifierStart(n);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierPart", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isUnicodeIdentifierPart(n);
                }
            });
            CharPropertyNames.defClone("javaIdentifierIgnorable", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isIdentifierIgnorable(n);
                }
            });
            CharPropertyNames.defClone("javaSpaceChar", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isSpaceChar(n);
                }
            });
            CharPropertyNames.defClone("javaWhitespace", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isWhitespace(n);
                }
            });
            CharPropertyNames.defClone("javaISOControl", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isISOControl(n);
                }
            });
            CharPropertyNames.defClone("javaMirrored", new CloneableProperty(){

                boolean isSatisfiedBy(int n) {
                    return Character.isMirrored(n);
                }
            });
        }

        private static abstract class CharPropertyFactory {
            private CharPropertyFactory() {
            }

            abstract CharProperty make();
        }

        private static abstract class CloneableProperty
        extends CharProperty
        implements Cloneable {
            private CloneableProperty() {
            }

            public CloneableProperty clone() {
                try {
                    return (CloneableProperty)super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new AssertionError((Object)cloneNotSupportedException);
                }
            }
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        Conditional(Node node, Node node2, Node node3) {
            this.cond = node;
            this.yes = node2;
            this.not = node3;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (this.cond.match(matcher, n, charSequence)) {
                return this.yes.match(matcher, n, charSequence);
            }
            return this.not.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            treeInfo.reset();
            this.yes.study(treeInfo);
            int n3 = treeInfo.minLength;
            int n4 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.not.study(treeInfo);
            treeInfo.minLength = n + Math.min(n3, treeInfo.minLength);
            treeInfo.maxLength = n2 + Math.max(n4, treeInfo.maxLength);
            treeInfo.maxValid = bl & bl2 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Ctype
    extends BmpCharProperty {
        final int ctype;

        Ctype(int n) {
            this.ctype = n;
        }

        boolean isSatisfiedBy(int n) {
            return n < 128 && ASCII.isType(n, this.ctype);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int n, int n2, int n3) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            for (n2 = 0; n2 < this.cmin; ++n2) {
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                n = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, n, n2, charSequence);
            }
            if (this.type == 1) {
                return this.match1(matcher, n, n2, charSequence);
            }
            return this.match2(matcher, n, n2, charSequence);
        }

        boolean match0(Matcher matcher, int n, int n2, CharSequence charSequence) {
            int n3;
            if (n2 >= this.cmax) {
                return this.next.match(matcher, n, charSequence);
            }
            int n4 = n2++;
            if (this.atom.match(matcher, n, charSequence) && (n3 = matcher.last - n) != 0) {
                n = matcher.last;
                while (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                    if (n + n3 != matcher.last) {
                        if (!this.match0(matcher, matcher.last, n2 + 1, charSequence)) break;
                        return true;
                    }
                    n += n3;
                    ++n2;
                }
                while (n2 >= n4) {
                    if (this.next.match(matcher, n, charSequence)) {
                        return true;
                    }
                    n -= n3;
                    --n2;
                }
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean match1(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (!this.next.match(matcher, n, charSequence)) {
                if (n2 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                if (n == matcher.last) {
                    return false;
                }
                n = matcher.last;
                ++n2;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (n2 < this.cmax && this.atom.match(matcher, n, charSequence) && n != matcher.last) {
                n = matcher.last;
                ++n2;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean bl) {
            this.multiline = bl;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (!this.multiline) {
                if (n < n2 - 2) {
                    return false;
                }
                if (n == n2 - 2) {
                    c = charSequence.charAt(n);
                    if (c != '\r') {
                        return false;
                    }
                    c = charSequence.charAt(n + 1);
                    if (c != '\n') {
                        return false;
                    }
                }
            }
            if (n < n2) {
                c = charSequence.charAt(n);
                if (c == '\n') {
                    if (n > 0 && charSequence.charAt(n - 1) == '\r') {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n, charSequence);
                    }
                } else if (c == '\r' || c == '\u0085' || (c | '\u0001') == 8233) {
                    if (this.multiline) {
                        return this.next.match(matcher, n, charSequence);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class Dot
    extends CharProperty {
        Dot() {
        }

        boolean isSatisfiedBy(int n) {
            return n != 10 && n != 13 && (n | 1) != 8233 && n != 133;
        }
    }

    static final class End
    extends Node {
        End() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n == n2) {
                matcher.hitEnd = true;
                return this.next.match(matcher, n, charSequence);
            }
            return false;
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            while (true) {
                if (n > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (this.atom.match(matcher, n, charSequence)) {
                    return this.next.match(matcher, matcher.last, charSequence);
                }
                n += Pattern.countChars(charSequence, n, 1);
                ++matcher.first;
            }
        }

        boolean study(TreeInfo treeInfo) {
            this.atom.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;
        boolean capture;

        GroupCurly(Node node, int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
            this.localIndex = n4;
            this.groupIndex = n5;
            this.capture = bl;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int[] nArray2 = matcher.locals;
            int n2 = nArray2[this.localIndex];
            int n3 = 0;
            int n4 = 0;
            if (this.capture) {
                n3 = nArray[this.groupIndex];
                n4 = nArray[this.groupIndex + 1];
            }
            nArray2[this.localIndex] = -1;
            boolean bl = true;
            for (int i = 0; i < this.cmin; ++i) {
                if (this.atom.match(matcher, n, charSequence)) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n;
                        nArray[this.groupIndex + 1] = matcher.last;
                    }
                } else {
                    bl = false;
                    break;
                }
                n = matcher.last;
            }
            if (bl) {
                bl = this.type == 0 ? this.match0(matcher, n, this.cmin, charSequence) : (this.type == 1 ? this.match1(matcher, n, this.cmin, charSequence) : this.match2(matcher, n, this.cmin, charSequence));
            }
            if (!bl) {
                nArray2[this.localIndex] = n2;
                if (this.capture) {
                    nArray[this.groupIndex] = n3;
                    nArray[this.groupIndex + 1] = n4;
                }
            }
            return bl;
        }

        boolean match0(Matcher matcher, int n, int n2, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int n3 = 0;
            int n4 = 0;
            if (this.capture) {
                n3 = nArray[this.groupIndex];
                n4 = nArray[this.groupIndex + 1];
            }
            if (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                int n5 = matcher.last - n;
                if (n5 <= 0) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n;
                        nArray[this.groupIndex + 1] = n + n5;
                    }
                    n += n5;
                } else {
                    block13: {
                        do {
                            if (this.capture) {
                                nArray[this.groupIndex] = n;
                                nArray[this.groupIndex + 1] = n + n5;
                            }
                            if (++n2 >= this.cmax || !this.atom.match(matcher, n += n5, charSequence)) break block13;
                        } while (n + n5 == matcher.last);
                        if (this.match0(matcher, n, n2, charSequence)) {
                            return true;
                        }
                    }
                    while (n2 > this.cmin) {
                        if (this.next.match(matcher, n, charSequence)) {
                            if (this.capture) {
                                nArray[this.groupIndex + 1] = n;
                                nArray[this.groupIndex] = n - n5;
                            }
                            n -= n5;
                            return true;
                        }
                        if (this.capture) {
                            nArray[this.groupIndex + 1] = n;
                            nArray[this.groupIndex] = n - n5;
                        }
                        n -= n5;
                        --n2;
                    }
                }
            }
            if (this.capture) {
                nArray[this.groupIndex] = n3;
                nArray[this.groupIndex + 1] = n4;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean match1(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (!this.next.match(matcher, n, charSequence)) {
                if (n2 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                if (n == matcher.last) {
                    return false;
                }
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                n = matcher.last;
                ++n2;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                if (n == matcher.last) break;
                n = matcher.last;
                ++n2;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int n) {
            this.localIndex = n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = n;
            boolean bl = this.next.match(matcher, n, charSequence);
            matcher.locals[this.localIndex] = n2;
            return bl;
        }

        boolean matchRef(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~n;
            boolean bl = this.next.match(matcher, n, charSequence);
            matcher.locals[this.localIndex] = n2;
            return bl;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead groupHead) {
            this.head = groupHead;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.head.matchRef(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int n, int n2) {
            this.localIndex = n;
            this.groupIndex = n2 + n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            if (n2 >= 0) {
                int n3 = matcher.groups[this.groupIndex];
                int n4 = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = n2;
                matcher.groups[this.groupIndex + 1] = n;
                if (this.next.match(matcher, n, charSequence)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = n3;
                matcher.groups[this.groupIndex + 1] = n4;
                return false;
            }
            matcher.last = n;
            return true;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (matcher.acceptMode == 1 && n != matcher.to) {
                return false;
            }
            matcher.last = n;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int n, int n2) {
            super(n, n2);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.locals[this.beginIndex]) {
                int n2 = matcher.locals[this.countIndex];
                if (n2 < this.cmin) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                if (this.next.match(matcher, n, charSequence)) {
                    return true;
                }
                if (n2 < this.cmax) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean matchInit(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.countIndex];
            boolean bl = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            } else if (this.next.match(matcher, n, charSequence)) {
                bl = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            }
            matcher.locals[this.countIndex] = n2;
            return bl;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int n, int n2) {
            this.countIndex = n;
            this.beginIndex = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.locals[this.beginIndex]) {
                int n2 = matcher.locals[this.countIndex];
                if (n2 < this.cmin) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                if (n2 < this.cmax) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    } else {
                        return true;
                    }
                }
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean matchInit(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.countIndex];
            boolean bl = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
                if (!bl) {
                    bl = this.next.match(matcher, n, charSequence);
                }
            } else {
                bl = this.next.match(matcher, n, charSequence);
            }
            matcher.locals[this.countIndex] = n2;
            return bl;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.to;
            boolean bl = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                if (n < matcher.to) {
                    bl = !this.cond.match(matcher, n, charSequence);
                } else {
                    matcher.requireEnd = true;
                    bl = !this.cond.match(matcher, n, charSequence);
                }
            }
            finally {
                matcher.to = n2;
            }
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            matcher.last = n;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo treeInfo) {
            if (this.next != null) {
                return this.next.study(treeInfo);
            }
            return treeInfo.deterministic;
        }
    }

    static class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.lookbehindTo;
            int n3 = matcher.from;
            boolean bl = false;
            int n4 = !matcher.transparentBounds ? matcher.from : 0;
            int n5 = Math.max(n - this.rmax, n4);
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - this.rmin; !bl && i >= n5; --i) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n3;
            matcher.lookbehindTo = n2;
            return !bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node node, int n, int n2) {
            super(node, n, n2);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = Pattern.countChars(charSequence, n, -this.rmax);
            int n3 = Pattern.countChars(charSequence, n, -this.rmin);
            int n4 = matcher.from;
            int n5 = matcher.lookbehindTo;
            boolean bl = false;
            int n6 = !matcher.transparentBounds ? matcher.from : 0;
            int n7 = Math.max(n - n2, n6);
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - n3; !bl && i >= n7; i -= i > n7 ? Pattern.countChars(charSequence, i, -1) : 1) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n4;
            matcher.lookbehindTo = n5;
            return !bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.to;
            boolean bl = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                bl = this.cond.match(matcher, n, charSequence);
            }
            finally {
                matcher.to = n2;
            }
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.loop.matchInit(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            return this.loop.study(treeInfo);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int n) {
            this.atom = node;
            this.type = n;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence) || this.next.match(matcher, n, charSequence);
                }
                case 1: {
                    return this.next.match(matcher, n, charSequence) || this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
                }
                case 2: {
                    if (this.atom.match(matcher, n, charSequence)) {
                        n = matcher.last;
                    }
                    return this.next.match(matcher, n, charSequence);
                }
            }
            return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            if (this.type != 3) {
                int n = treeInfo.minLength;
                this.atom.study(treeInfo);
                treeInfo.minLength = n;
                treeInfo.deterministic = false;
                return this.next.study(treeInfo);
            }
            this.atom.study(treeInfo);
            return this.next.study(treeInfo);
        }
    }

    static class Slice
    extends Node {
        int[] buffer;

        Slice(int[] nArray) {
            this.buffer = nArray;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n + i >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (nArray[i] == charSequence.charAt(n + i)) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class SliceA
    extends Node {
        int[] buffer;

        SliceA(int[] nArray) {
            this.buffer = nArray;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n + i >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n3 = ASCII.toLower(charSequence.charAt(n + i));
                if (nArray[i] == n3) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class SliceS
    extends Slice {
        SliceS(int[] nArray) {
            super(nArray);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = n;
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n3 = Character.codePointAt(charSequence, n2);
                if (nArray[i] != n3) {
                    return false;
                }
                if ((n2 += Character.charCount(n3)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class SliceU
    extends Node {
        int[] buffer;

        SliceU(int[] nArray) {
            this.buffer = nArray;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = n;
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n3 = Character.codePointAt(charSequence, n2);
                int n4 = Character.toUpperCase(n3);
                if (nArray[i] != (n4 = Character.toLowerCase(n4))) {
                    return false;
                }
                if ((n2 += Character.charCount(n3)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo treeInfo = new TreeInfo();
            this.next.study(treeInfo);
            this.minLength = treeInfo.minLength;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            boolean bl = false;
            int n2 = matcher.to - this.minLength;
            while (n <= n2 && !(bl = this.next.match(matcher, n, charSequence))) {
                if (n == n2) {
                    matcher.hitEnd = true;
                }
                ++n;
            }
            if (bl) {
                matcher.groups[0] = matcher.first = n;
                matcher.groups[1] = matcher.last;
            }
            return bl;
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            boolean bl = false;
            int n2 = matcher.to - this.minLength;
            while (n <= n2 && !(bl = this.next.match(matcher, n, charSequence)) && n != n2) {
                if (Character.isHighSurrogate(charSequence.charAt(n++)) && n < charSequence.length() && Character.isLowSurrogate(charSequence.charAt(n))) {
                    ++n;
                }
                if (n != n2) continue;
                matcher.hitEnd = true;
            }
            if (bl) {
                matcher.groups[0] = matcher.first = n;
                matcher.groups[1] = matcher.last;
            }
            return bl;
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            int n2 = matcher.from;
            int n3 = matcher.to;
            if (!matcher.anchoringBounds) {
                n2 = 0;
                n3 = matcher.getTextLength();
            }
            if (n == n3) {
                matcher.hitEnd = true;
                return false;
            }
            if (n > n2 && (c = charSequence.charAt(n - 1)) != '\n') {
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean bl) {
            this.multiline = bl;
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n < n2) {
                char c = charSequence.charAt(n);
                if (c == '\n') {
                    if (!this.multiline && n != n2 - 1) {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n, charSequence);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, n, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class UnixDot
    extends CharProperty {
        UnixDot() {
        }

        boolean isSatisfiedBy(int n) {
            return n != 10;
        }
    }
}

