<?xml version="1.0"  encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
<html>
<head>
<link rel='stylesheet' href='common.css' type='text/css'/>
<meta http-equiv="content-type" content="text/html; charset=gb2312"></meta>
<style>
body {
}

a {
	color:black;
	cursor:hand;
}

#item #caption {
	background-color:#eeeeee;
	text-align:center;
	vertical-align:middle;
	font-size:9pt;
	padding-left:5px;
	padding-right:5px;
}

#item #value1 {
	background-color:#ffffff;
	text-align:left;
	vertical-align:middle;
	font-size:9pt;
}

#item #value2 {
	background-color:#ffffff;
	text-align:center;
	vertical-align:middle;
	font-size:9pt;
}

#item #value3 {
	background-color:#ffffff;
	text-align:right;
	vertical-align:middle;
	font-size:9pt;
}

#detail #caption {
	background-color:#eeeeee;
	text-align:center;
	vertical-align:middle;
	font-size:9pt;
	width:50px;
	border-bottom: 1px solid white;
}

#detail #value {
	text-align:left;
	vertical-align:top;
	font-size:9pt;
	word-break:break-all;
	border-bottom: 1px dotted silver;
}

</style>
<script language="javascript">
<![CDATA[
function showall(tag){
	var x=document.getElementsByName('btnDetail');
	for(i=x.length-1;i>=0;i--){
		_onBtnDetailClick(x[i],tag);
	}
	scroll(0,0);
}

function _onBtnDetailClick(element,tag){
	var item=getParentById(element,'item');
	if (item==null) return;
	var detail=getChildById(item.parentElement,'detail');
	if (detail==null) return;
	if (tag==1) element.innerText='չ';
	if (tag==2) element.innerText='';
	if (element.innerText=='չ'){
		element.innerText='';
		detail.style.display='inline';
	}else{
		element.innerText='չ';
		detail.style.display='none';
	}
	item.focus();
	
	
}

/// ȡָԪصĸԪ,:id=parentId
function getParentById(element,parentId){
	var x=element.parentElement;
	if (x==null) return null;
	if (x.id==parentId) return x;
	return getParentById(x,parentId);
}

/// ȡָԪصԪ,:id=childId
function getChildById(element,childId){
	var x,y,i;
	x=element.childNodes;
	if (x==null) return null;
	for(i=0;i<x.length;i++){
		y=x[i];
		if (y.id==childId) return y;
		z=getChildById(y,childId);
		if (z!=null) return z;
	}
	return null;
}

]]>
</script>
</head>

<body style="margin:2px">
 	<xsl:apply-templates select="log"/>
</body>
</html>
</xsl:template>

<xsl:template match="log">
<table width="100%">
	<tr>
		<td width="100%" style="font-size:9pt;">ڣ<xsl:value-of select="Date"/></td>
		<td nowrap="true" style="font-size:9pt;cursor:hand;text-decoration: underline;" onclick="javascript:showall(1);">ȫչ</td>
		<td nowrap="true" style="font-size:9pt;"> </td>
		<td nowrap="true" style="font-size:9pt;cursor:hand;text-decoration: underline;" onclick="javascript:showall(2);">ȫ</td>
		<td nowrap="true" style="font-size:9pt;"> </td>
		<td nowrap="true" style="font-size:9pt;cursor:hand;text-decoration: underline;" onclick="javascript:window.open(location);">´д</td>
	</tr>
</table>
<xsl:apply-templates select="item"/>
</xsl:template>

<xsl:template match="item">
	<div>
	<table id="item" cellspacing="1" cellpadding="3" border="0" width="100%" style="border-left:2px solid #999999; background-color:#cccccc;">
		<tr>
			<td nowrap="true" id="caption">Ŀ</td>
			<td id="value1" style="color:red" colspan="9"><xsl:value-of select="Project"/></td>
		</tr>
		<tr id="f1">
			<td nowrap="true" id="caption">½</td>
			<td nowrap="true" id="value3" width="30%"><xsl:value-of select="NewCount"/></td>
			<td nowrap="true" id="caption"></td>
			<td nowrap="true" id="value3" width="30%"><xsl:value-of select="UpdateCount"/></td>
			<td nowrap="true" id="caption">ɾ</td>
			<td nowrap="true" id="value3" width="30%"><xsl:value-of select="DeleteCount"/></td>
			<td nowrap="true" id="caption">ʼ</td>
			<td nowrap="true" id="value2" width="60px"><xsl:value-of select="BeginTime"/></td>
			<td nowrap="true" id="caption">ִ</td>
			<td nowrap="true" id="value2" width="40px"><xsl:value-of select="ProcessStatus"/></td>
		</tr>
		<tr id="f2">
			<td nowrap="true" id="caption">ʧ</td>
			<td nowrap="true" id="value3" style="color:red;"><xsl:value-of select="NewFailCount"/></td>
			<td nowrap="true" id="caption">ʧ</td>
			<td nowrap="true" id="value3" style="color:red;"><xsl:value-of select="UpdateFailCount"/></td>
			<td nowrap="true" id="caption">ʧ</td>
			<td nowrap="true" id="value3" style="color:red;"><xsl:value-of select="DeleteFailCount"/></td>
			<td nowrap="true" id="caption">ʱ</td>
			<td nowrap="true" id="value2"><xsl:value-of select="SpendTime"/></td>
			<td nowrap="true" id="caption">ϸ</td>
			<td nowrap="true" id="value2"><a id="btnDetail" style="font-size:9pt;cursor:hand;text-decoration: underline;" onclick="javascript:_onBtnDetailClick(this,0);">չ</a></td>
		</tr>
	</table>
	<table id="detail" style="display:none;margin-top:5px;" cellspacing="0" cellpadding="2" border="0" width="100%">
		<xsl:apply-templates select="New"/>
		<xsl:apply-templates select="NewFail"/>
		<xsl:apply-templates select="Update"/>
		<xsl:apply-templates select="UpdateFail"/>
		<xsl:apply-templates select="Delete"/>
		<xsl:apply-templates select="DeleteFail"/>
	</table>
	</div>
	<br/>
</xsl:template>

<xsl:template match="item/New">
		<tr>
			<td id="caption" nowrap="yes">½</td>
			<td id="value"><xsl:value-of select="."/></td>
		</tr>
</xsl:template>

<xsl:template match="item/NewFail">
		<tr>
			<td id="caption" nowrap="yes">½ʧ</td>
			<td id="value" style="color:red"><xsl:value-of select="."/></td>
		</tr>
</xsl:template>

<xsl:template match="item/Update">
		<tr>
			<td id="caption" nowrap="yes"></td>
			<td id="value"><xsl:value-of select="."/></td>
		</tr>
</xsl:template>

<xsl:template match="item/UpdateFail">
		<tr>
			<td id="caption" nowrap="yes">ʧ</td>
			<td id="value" style="color:red"><xsl:value-of select="."/></td>
		</tr>
</xsl:template>

<xsl:template match="item/Delete">
		<tr>
			<td id="caption" nowrap="yes">ɾ</td>
			<td id="value"><xsl:value-of select="."/></td>
		</tr>
</xsl:template>

<xsl:template match="item/DeleteFail">
		<tr>
			<td id="caption" nowrap="yes">ɾʧ</td>
			<td id="value" style="color:red"><xsl:value-of select="."/></td>
		</tr>
</xsl:template>

</xsl:stylesheet>
