--==========================================================================================================================
-- UNITS
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,							Kind)
VALUES	('UNIT_SUK_SHOTELAI',			'KIND_UNIT');		
--------------------------------------------------------------------------------------------------------------------------
-- Units
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Units	
		(UnitType,						Name, 											Description, 								TraitType,								BaseMoves, Cost, AdvisorType, BaseSightRange, ZoneOfControl, Domain, FormationClass, MandatoryObsoleteTech,	PurchaseYield, PromotionClass, Maintenance,	Combat)
SELECT  'UNIT_SUK_SHOTELAI',			'LOC_UNIT_SUK_SHOTELAI_NAME',					'LOC_UNIT_SUK_SHOTELAI_DESCRIPTION',		'TRAIT_CIVILIZATION_UNIT_SUK_SHOTELAI',	BaseMoves, Cost, AdvisorType, BaseSightRange, ZoneOfControl, Domain, FormationClass, MandatoryObsoleteTech,	PurchaseYield, PromotionClass, Maintenance,	Combat		
FROM Units WHERE UnitType = 'UNIT_SWORDSMAN';

UPDATE Units
SET	
	Cost			= 	(SELECT Cost FROM Units WHERE UnitType = 'UNIT_PIKEMAN'), 
	Combat			= 	(SELECT Combat FROM Units WHERE UnitType = 'UNIT_PIKEMAN'), 
	--PromotionClass 	= 	(SELECT PromotionClass FROM Units WHERE UnitType = 'UNIT_PIKEMAN'), 
	--Combat 			= 	(SELECT Combat FROM Units WHERE UnitType = 'UNIT_PIKEMAN'),
	PrereqCivic 	= 	'CIVIC_FEUDALISM'
WHERE UnitType = 'UNIT_SUK_SHOTELAI';
-----------------------------------------------------------------------------------
-- UnitReplaces
-----------------------------------------------------------------------------------
INSERT INTO UnitReplaces
			(CivUniqueUnitType,					ReplacesUnitType)
SELECT 		'UNIT_SUK_SHOTELAI',				ReplacesUnitType
FROM UnitReplaces WHERE CivUniqueUnitType = 'UNIT_JAPANESE_SAMURAI';
-----------------------------------------------------------------------------------
-- UnitUpgrades
-----------------------------------------------------------------------------------
INSERT INTO UnitUpgrades
			(Unit,								UpgradeUnit)
VALUES 		('UNIT_SUK_SHOTELAI',				'UNIT_MUSKETMAN');
-----------------------------------------------------------------------------------
-- UnitAiInfos
-----------------------------------------------------------------------------------
INSERT INTO UnitAiInfos
			(UnitType,							AiType)
SELECT 		'UNIT_SUK_SHOTELAI',				AiType
FROM UnitAiInfos WHERE UnitType = 'UNIT_SWORDSMAN';
-----------------------------------------------------------------------------------
-- TypeTags
-----------------------------------------------------------------------------------
INSERT INTO TypeTags
			(Type,							Tag)
SELECT 		'UNIT_SUK_SHOTELAI',			Tag
FROM TypeTags WHERE Type = 'UNIT_SWORDSMAN';

INSERT OR REPLACE INTO TypeTags
			(Type,							Tag)
VALUES		('UNIT_SUK_SHOTELAI',			'CLASS_ANTI_CAVALRY'),
			('UNIT_SUK_SHOTELAI',			'CLASS_SUK_SHOTELAI'),
			('ABILITY_SUK_SHOTELAI',		'CLASS_SUK_SHOTELAI');
-----------------------------------------------------------------------------------
-- Tags
-----------------------------------------------------------------------------------
INSERT INTO Tags
			(Tag,								Vocabulary)
VALUES		('CLASS_SUK_SHOTELAI',				'ABILITY_CLASS');		
--==========================================================================================================================
-- UNIT ABILITIES
--==========================================================================================================================
-- Types
-----------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,									Kind)
VALUES	('ABILITY_SUK_SHOTELAI',				'KIND_ABILITY');
-------------------------------------
-- UnitAbilities
-------------------------------------					
INSERT INTO UnitAbilities			
		(UnitAbilityType,				Name,									Description)
VALUES	('ABILITY_SUK_SHOTELAI',		'LOC_ABILITY_SUK_SHOTELAI_NAME',		'LOC_ABILITY_SUK_SHOTELAI_DESCRIPTION');
-------------------------------------
-- UnitAbilityModifiers
-------------------------------------
INSERT INTO UnitAbilityModifiers	
		(UnitAbilityType,						ModifierId)
VALUES	('ABILITY_SUK_SHOTELAI',				'ABILITY_SUK_SHOTELAI_MODIFIER');
--==========================================================================================================================
-- MODIFIERS
--==========================================================================================================================
-- Modifiers
-------------------------------------					
INSERT INTO Modifiers			
		(ModifierId,								ModifierType,											SubjectRequirementSetId)
VALUES	('ABILITY_SUK_SHOTELAI_MODIFIER',			'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',					'COSSACK_PLOT_IS_OWNER_OR_ADJACENT_REQUIREMENTS');
-------------------------------------
-- ModifierArguments
-------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,									Name,			Value)
VALUES	('ABILITY_SUK_SHOTELAI_MODIFIER',				'Amount',		(SELECT Combat FROM Units WHERE UnitType = 'UNIT_JAPANESE_SAMURAI') - (SELECT Combat FROM Units WHERE UnitType = 'UNIT_PIKEMAN'));
-------------------------------------
-- ModifierStrings
-------------------------------------
INSERT INTO ModifierStrings
		(ModifierId,									Context,			'Text')
VALUES	('ABILITY_SUK_SHOTELAI_MODIFIER',				'Preview',			'LOC_ABILITY_COSSACK_LOCAL_COMBAT_MODIFIER_DESCRIPTION');
--==========================================================================================================================
--==========================================================================================================================