--==========================================================================================================================
-- LOADING INFO
--==========================================================================================================================
-- LoadingInfo
-------------------------------------	
INSERT INTO LoadingInfo	
		(LeaderType,					ForegroundImage,						BackgroundImage,				PlayDawnOfManAudio)
VALUES	('LEADER_ANT_TAIZU',			'LEADER_ANT_TAIZU_NEUTRAL',				'LEADER_MONTEZUMA_BACKGROUND',	0);	
--==========================================================================================================================
-- DIPLOMACY INFO
--==========================================================================================================================
-- DiplomacyInfo
-------------------------------------	
-- INSERT INTO DiplomacyInfo	
-- 			(Type,						BackgroundImage)
-- VALUES	('LEADER_ANT_TAIZU',		'FALLBACK_NEUTRAL_ANT_TAIZU.dds');
--==========================================================================================================================
-- COLOURS
--==========================================================================================================================
-- PlayerColors
-------------------------------------	
INSERT INTO PlayerColors	
		(Type,							Usage,				PrimaryColor, 							SecondaryColor,							TextColor)
VALUES	('LEADER_ANT_TAIZU',			'Unique',			'COLOR_PLAYER_ANT_TAIZU_PRIMARY',		'COLOR_PLAYER_ANT_TAIZU_SECONDARY', 	'COLOR_PLAYER_WHITE_TEXT');	

INSERT INTO Colors 
		(Type, 										Red, 	Green, 	Blue, 	Alpha)
VALUES	('COLOR_PLAYER_ANT_TAIZU_PRIMARY', 			0.340,	0.418,	0.621,	1),
		('COLOR_PLAYER_ANT_TAIZU_SECONDARY', 		0.656,	0.680,	0.449,	1);
--==========================================================================================================================
-- LEADERS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,							Kind)
VALUES	('LEADER_ANT_TAIZU',			'KIND_LEADER');	
-------------------------------------
-- Leaders
-------------------------------------	
INSERT INTO Leaders	
		(LeaderType,					Name,												InheritFrom,		SceneLayers)
VALUES	('LEADER_ANT_TAIZU',			'LOC_LEADER_ANT_TAIZU_NAME',						'LEADER_DEFAULT',	4);	
-------------------------------------
-- LeaderQuotes
-------------------------------------	
INSERT INTO LeaderQuotes	
		(LeaderType,					Quote)
VALUES	('LEADER_ANT_TAIZU',			'LOC_LEADER_ANT_TAIZU_QUOTE');	
-------------------------------------
-- LeaderTraits
-------------------------------------	
INSERT INTO LeaderTraits	
		(LeaderType,					TraitType)
VALUES	('LEADER_ANT_TAIZU',			'TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS');	
-- -------------------------------------
-- HistoricalAgendas
-- -------------------------------------	
INSERT INTO HistoricalAgendas	
		(LeaderType,					AgendaType)
VALUES	('LEADER_ANT_TAIZU',			'AGENDA_ANT_INVENTIONS_OF_SONG');	
-- -------------------------------------
-- FavoredReligions
-- -------------------------------------	
INSERT OR REPLACE INTO FavoredReligions
       (LeaderType,						ReligionType)
VALUES   ('LEADER_ANT_TAIZU',		    'RELIGION_CONFUCIANISM');

CREATE TRIGGER AntTaizu_HR
AFTER INSERT ON Religions WHEN 'RELIGION_ZOROASTRIANISM' = NEW.ReligionType
BEGIN
   INSERT OR REPLACE INTO FavoredReligions
		    (LeaderType,				ReligionType)
   VALUES   ('LEADER_ANT_TAIZU',			'RELIGION_CONFUCIANISM');
END;
--==========================================================================================================================
-- TRAITS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,													Kind)
VALUES	('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS',				'KIND_TRAIT');	
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,												Name,												Description)
VALUES	('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS',				'LOC_TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS_NAME',	'LOC_TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,												ModifierId)
VALUES	('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CITY_CENTER_DISTRICT_SCIENCE_ADJACENCY'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_AERODROME_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_CAMPUS_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_COMMERCIAL_HUB_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_ENCAMPMENT_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_ENTERTAINMENT_COMPLEX_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_HARBOR_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_HOLY_SITE_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_INDUSTRIAL_ZONE_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_THEATER_PRODUCTION'),
		('TRAIT_LEADER_ANT_IMPERIAL_EXAMINATIONS', 				'TRAIT_ANT_CAPITAL_CITY_EXTRA_DISTRICTS');
--==========================================================================================================================
-- AGENDAS
--==========================================================================================================================
-- Agendas			
-------------------------------------				
INSERT INTO Agendas				
		(AgendaType,									Name,											Description)
VALUES	('AGENDA_ANT_INVENTIONS_OF_SONG',				'LOC_AGENDA_ANT_INVENTIONS_OF_SONG_NAME',		'LOC_AGENDA_ANT_INVENTIONS_OF_SONG_DESCRIPTION');	
-------------------------------------
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,											Kind)
VALUES	('TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG',			'KIND_TRAIT');
-------------------------------------			
-- AgendaTraits			
-------------------------------------				
INSERT INTO AgendaTraits				
		(AgendaType,									TraitType)
VALUES	('AGENDA_ANT_INVENTIONS_OF_SONG',				'TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG');
-------------------------------------			
-- ExclusiveAgendas
-------------------------------------
INSERT INTO ExclusiveAgendas				
		(AgendaOne,										AgendaTwo)
VALUES	('AGENDA_ANT_INVENTIONS_OF_SONG',				'AGENDA_TECHNOPHILE');					
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,										Name,											Description)
VALUES	('TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG',			'LOC_AGENDA_ANT_INVENTIONS_OF_SONG_NAME',		'LOC_AGENDA_ANT_INVENTIONS_OF_SONG_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,													ModifierId)
VALUES	('TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG', 					'AGENDA_ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE'),
		('TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG', 					'AGENDA_ANT_INVENTIONS_OF_SONG_LOW_SCIENCE');
--==========================================================================================================================
-- MODIFIERS 
--==========================================================================================================================
-- Modifiers
-------------------------------------
INSERT INTO Modifiers			
		(ModifierId,													ModifierType,													SubjectRequirementSetId)
VALUES	('TRAIT_ANT_CITY_CENTER_DISTRICT_SCIENCE_ADJACENCY',			'MODIFIER_PLAYER_CITIES_DISTRICT_ADJACENCY',					'ANT_PLAYER_HAS_EDUCATION'),
		('TRAIT_ANT_CAPITAL_CITY_AERODROME_PRODUCTION',					'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_CAMPUS_PRODUCTION',					'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_COMMERCIAL_HUB_PRODUCTION',			'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_ENCAMPMENT_PRODUCTION',				'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_ENTERTAINMENT_COMPLEX_PRODUCTION',		'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_HARBOR_PRODUCTION',					'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_HOLY_SITE_PRODUCTION',					'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_INDUSTRIAL_ZONE_PRODUCTION',			'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_THEATER_PRODUCTION',					'MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'ANT_CITY_HAS_PALACE'),
		('TRAIT_ANT_CAPITAL_CITY_EXTRA_DISTRICTS',						'MODIFIER_PLAYER_CITIES_EXTRA_DISTRICT',						'ANT_CITY_HAS_PALACE'),
		('AGENDA_ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',					'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',					'ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE'),
		('AGENDA_ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',					'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',					'ANT_INVENTIONS_OF_SONG_LOW_SCIENCE');
-------------------------------------
-- ModifierArguments
-------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,													Name,							Value)
VALUES	('TRAIT_ANT_CITY_CENTER_DISTRICT_SCIENCE_ADJACENCY',			'DistrictType',					'DISTRICT_CITY_CENTER'),
		('TRAIT_ANT_CITY_CENTER_DISTRICT_SCIENCE_ADJACENCY',			'YieldType',					'YIELD_SCIENCE'),
		('TRAIT_ANT_CITY_CENTER_DISTRICT_SCIENCE_ADJACENCY',			'Amount',						1),
		('TRAIT_ANT_CITY_CENTER_DISTRICT_SCIENCE_ADJACENCY',			'Description',					'LOC_ANT_CAPITAL_CITY_CENTER_2_SCIENCE'),
		
		('TRAIT_ANT_CAPITAL_CITY_AERODROME_PRODUCTION',					'DistrictType',					'DISTRICT_AERODROME'),
		('TRAIT_ANT_CAPITAL_CITY_AERODROME_PRODUCTION',					'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_CAMPUS_PRODUCTION',					'DistrictType',					'DISTRICT_CAMPUS'),
		('TRAIT_ANT_CAPITAL_CITY_CAMPUS_PRODUCTION',					'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_COMMERCIAL_HUB_PRODUCTION',			'DistrictType',					'DISTRICT_COMMERCIAL_HUB'),
		('TRAIT_ANT_CAPITAL_CITY_COMMERCIAL_HUB_PRODUCTION',			'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_ENCAMPMENT_PRODUCTION',				'DistrictType',					'DISTRICT_ENCAMPMENT'),
		('TRAIT_ANT_CAPITAL_CITY_ENCAMPMENT_PRODUCTION',				'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_ENTERTAINMENT_COMPLEX_PRODUCTION',		'DistrictType',					'DISTRICT_ENTERTAINMENT_COMPLEX'),
		('TRAIT_ANT_CAPITAL_CITY_ENTERTAINMENT_COMPLEX_PRODUCTION',		'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_HARBOR_PRODUCTION',					'DistrictType',					'DISTRICT_HARBOR'),
		('TRAIT_ANT_CAPITAL_CITY_HARBOR_PRODUCTION',					'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_HOLY_SITE_PRODUCTION',					'DistrictType',					'DISTRICT_HOLY_SITE'),
		('TRAIT_ANT_CAPITAL_CITY_HOLY_SITE_PRODUCTION',					'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_INDUSTRIAL_ZONE_PRODUCTION',			'DistrictType',					'DISTRICT_INDUSTRIAL_ZONE'),
		('TRAIT_ANT_CAPITAL_CITY_INDUSTRIAL_ZONE_PRODUCTION',			'Amount',						25),
		('TRAIT_ANT_CAPITAL_CITY_THEATER_PRODUCTION',					'DistrictType',					'DISTRICT_THEATER'),
		('TRAIT_ANT_CAPITAL_CITY_THEATER_PRODUCTION',					'Amount',						25),

		('TRAIT_ANT_CAPITAL_CITY_EXTRA_DISTRICTS',						'Amount',						1),
		
		('AGENDA_ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',					'InitialValue',					-10),
		('AGENDA_ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',					'StatementKey',					'LOC_DIPLO_KUDO_LEADER_ANT_TAIZU_REASON_ANY'),
		('AGENDA_ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',					'SimpleModifierDescription',	'LOC_DIPLO_MODIFIER_ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE'),

		('AGENDA_ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',					'InitialValue',					7),
		('AGENDA_ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',					'StatementKey',					'LOC_DIPLO_WARNING_LEADER_ANT_TAIZU_REASON_ANY'),
		('AGENDA_ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',					'SimpleModifierDescription',	'LOC_DIPLO_MODIFIER_ANT_INVENTIONS_OF_SONG_LOW_SCIENCE');
-------------------------------------
-- Types
-------------------------------------
INSERT INTO Types	
		(Type,															Kind)
VALUES	('MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'KIND_MODIFIER');
-------------------------------------
-- DynamicModifiers
-------------------------------------
INSERT INTO DynamicModifiers
		(ModifierType,													CollectionType,							EffectType)
VALUES	('MODIFIER_ANT_CITY_DISTRICT_PRODUCTION',						'COLLECTION_PLAYER_CITIES',				'EFFECT_ADJUST_DISTRICT_PRODUCTION');
-------------------------------------
-- ModifierStrings
-------------------------------------
INSERT INTO ModifierStrings
		(ModifierId,													Context,						Text)
VALUES	('AGENDA_ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',					'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL'),
		('AGENDA_ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',					'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL');
--==========================================================================================================================
-- REQUIREMENTS
--==========================================================================================================================
-- RequirementSets
-------------------------------------
INSERT INTO RequirementSets
		(RequirementSetId,											RequirementSetType)
VALUES	('ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',				'REQUIREMENTSET_TEST_ALL'),
		('ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',				'REQUIREMENTSET_TEST_ALL'),
		('ANT_CITY_HAS_PALACE',								'REQUIREMENTSET_TEST_ALL'),
		('ANT_PLAYER_HAS_EDUCATION',						'REQUIREMENTSET_TEST_ALL');
-------------------------------------
-- RequirementSetRequirements
-------------------------------------
INSERT INTO RequirementSetRequirements
		(RequirementSetId,									RequirementId)
VALUES	('ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',				'REQUIRES_HAS_HIGH_SCIENCE'),
		('ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',				'REQUIRES_MAJOR_CIV_OPPONENT'),
		('ANT_INVENTIONS_OF_SONG_HIGH_SCIENCE',				'REQUIRES_MET_10_TURNS_AGO'),

		('ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',				'REQUIRES_HAS_LOW_SCIENCE'),
		('ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',				'REQUIRES_MAJOR_CIV_OPPONENT'),
		('ANT_INVENTIONS_OF_SONG_LOW_SCIENCE',				'REQUIRES_MET_10_TURNS_AGO'),

		('ANT_CITY_HAS_PALACE',								'REQUIRES_ANT_CITY_HAS_PALACE'),
		('ANT_PLAYER_HAS_EDUCATION',						'REQUIRES_ANT_PLAYER_HAS_EDUCATION');
-------------------------------------
-- Requirements
-------------------------------------
INSERT INTO Requirements
		(RequirementId,										RequirementType)
VALUES	('REQUIRES_ANT_CITY_HAS_PALACE',					'REQUIREMENT_CITY_HAS_BUILDING'),
		('REQUIRES_ANT_PLAYER_HAS_EDUCATION',				'REQUIREMENT_PLAYER_HAS_TECHNOLOGY');
-------------------------------------
-- RequirementArguments
-------------------------------------
INSERT INTO RequirementArguments
		(RequirementId,										Name,							Value)
VALUES	('REQUIRES_ANT_CITY_HAS_PALACE',					'BuildingType',					'BUILDING_PALACE'),
		('REQUIRES_ANT_PLAYER_HAS_EDUCATION',				'TechnologyType',				'TECH_EDUCATION');
--==========================================================================================================================
-- AI
--==========================================================================================================================
-- AiListTypes
-------------------------------------	
INSERT INTO AiListTypes	
		(ListType)
VALUES	('Ant_Taizu_Wonders'),
		('Ant_Taizu_Civics'),
		('Ant_Taizu_Techs'),
		('Ant_Taizu_FavorScientificVictory');
-------------------------------------
-- AiLists 
-------------------------------------
INSERT INTO AiLists	
		(ListType,								AgendaType,										System)
VALUES	('Ant_Taizu_Wonders',					'TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG',			'Buildings'),
		('Ant_Taizu_Civics',					'TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG',			'Civics'),
		('Ant_Taizu_Techs',						'TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG',			'Technologies'),
		('Ant_Taizu_FavorScientificVictory',	'TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG',			'Strategies'),
		('ScienceLoverSciencePreference',		'TRAIT_AGENDA_ANT_INVENTIONS_OF_SONG',			'Yields');	
-------------------------------------		
-- AiFavoredItems (VICTORY_STRATEGY_SCIENCE_VICTORY)
-------------------------------------
INSERT INTO AiFavoredItems	
		(ListType,						Item)
VALUES	('Ant_Taizu_Wonders',			'BUILDING_GREAT_LIBRARY'),
		('Ant_Taizu_Wonders',			'BUILDING_OXFORD_UNIVERSITY'),

		('Ant_Taizu_Civics',			'CIVIC_RECORDED_HISTORY'),
		('Ant_Taizu_Civics',			'CIVIC_THE_ENLIGHTENMENT'),
		('Ant_Taizu_Civics',			'CIVIC_SPACE_RACE'),

		('Ant_Taizu_Techs',				'TECH_WRITING'),
		('Ant_Taizu_Techs',				'TECH_MASONRY'),
		('Ant_Taizu_Techs',				'TECH_CASTLES'),
		('Ant_Taizu_Techs',				'TECH_FLIGHT'),
		('Ant_Taizu_Techs',				'TECH_EDUCATION'),
		('Ant_Taizu_Techs',				'TECH_SCIENTIFIC_THEORY'),
		('Ant_Taizu_Techs',				'TECH_CHEMISTRY'),
		('Ant_Taizu_Techs',				'TECH_ROCKETRY'),
		('Ant_Taizu_Techs',				'TECH_SATELLITES'),
		('Ant_Taizu_Techs',				'TECH_ROBOTICS'),
		('Ant_Taizu_Techs',				'TECH_NUCLEAR_FUSION'),
		('Ant_Taizu_Techs',				'TECH_NANOTECHNOLOGY');
-------------------------------------		
-- AiFavoredItems (Victory Strategy)
-------------------------------------
INSERT INTO AiFavoredItems	
		(ListType,									Item,									Value)
VALUES	('Ant_Taizu_FavorScientificVictory',		'VICTORY_STRATEGY_SCIENCE_VICTORY',		-1);
--==========================================================================================================================
-- CivilizationLeaders
--==========================================================================================================================
INSERT INTO CivilizationLeaders
		(LeaderType, 				CivilizationType,			CapitalName)
VALUES  ('LEADER_ANT_TAIZU',		'CIVILIZATION_CHINA',		'LOC_CITY_NAME_KAIFENG');
--==========================================================================================================================
--==========================================================================================================================