/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomItems;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.commands.CommandSlay;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.constants.EnumModelType;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.entity.EntityNPCDwarfFemale;
import noppes.npcs.entity.EntityNPCDwarfMale;
import noppes.npcs.entity.EntityNPCElfFemale;
import noppes.npcs.entity.EntityNPCElfMale;
import noppes.npcs.entity.EntityNPCEnderman;
import noppes.npcs.entity.EntityNPCFurryFemale;
import noppes.npcs.entity.EntityNPCFurryMale;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNPCHumanFemale;
import noppes.npcs.entity.EntityNPCHumanMale;
import noppes.npcs.entity.EntityNPCOrcFemale;
import noppes.npcs.entity.EntityNPCOrcMale;
import noppes.npcs.entity.EntityNPCPony;
import noppes.npcs.entity.EntityNPCVillager;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcEnderchibi;
import noppes.npcs.entity.EntityNpcMonsterFemale;
import noppes.npcs.entity.EntityNpcMonsterMale;
import noppes.npcs.entity.EntityNpcNagaFemale;
import noppes.npcs.entity.EntityNpcNagaMale;
import noppes.npcs.entity.EntityNpcSkeleton;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;

@Mod(modid="customnpcs", name="CustomNpcs", version="1.7.2")
public class CustomNpcs {
    public static boolean TextureSelection = false;
    @ConfigProp
    public static boolean DisableExtraNpcItems = false;
    @ConfigProp(info="Uses unique entities ids")
    public static boolean UseUniqueEntities = true;
    @ConfigProp(info="To use this UseUniqueEntities has to be false")
    public static int EntityStartId = 120;
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp
    public static boolean InventoryGuiEnabled = true;
    public static long ticks;
    @SidedProxy(clientSide="noppes.npcs.client.ClientProxy", serverSide="noppes.npcs.CommonProxy")
    public static CommonProxy proxy;
    @ConfigProp(info="Enables CustomNpcs startup update message")
    public static boolean EnableUpdateChecker;
    public static CustomNpcs instance;
    public static boolean FreezeNPCs;
    @ConfigProp(info="Only ops can create and edit npcs")
    public static boolean OpsOnly;
    public static File Dir;
    public static FMLEventChannel Channel;
    public static FMLEventChannel ChannelPlayer;

    public CustomNpcs() {
        instance = this;
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent ev) {
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCs");
        ChannelPlayer = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCsPlayer");
        MinecraftServer server = MinecraftServer.func_71276_C();
        String dir = "";
        dir = server != null ? new File(".").getAbsolutePath() : Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
        Dir = new File(dir, "customnpcs");
        Dir.mkdir();
        ConfigLoader configLoader = new ConfigLoader(this.getClass(), new File(dir, "config"), "CustomNpcs");
        configLoader.loadConfig();
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        CustomItems.load();
        proxy.load();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        this.registerNpc(EntityNPCHumanMale.class, EnumModelType.HumanMale.entityName, EnumModelType.HumanMale.id);
        this.registerNpc(EntityNPCVillager.class, "npcvillager", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCPony.class, "npcpony", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCHumanFemale.class, "npchumanfemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCDwarfMale.class, "npcdwarfmale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCFurryMale.class, "npcfurrymale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcMonsterMale.class, "npczombiemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcMonsterFemale.class, "npczombiefemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcSkeleton.class, "npcskeleton", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCDwarfFemale.class, "npcdwarffemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCFurryFemale.class, "npcfurryfemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCOrcMale.class, "npcorcfmale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCOrcFemale.class, "npcorcfemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCElfMale.class, "npcelfmale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCElfFemale.class, "npcelffemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcCrystal.class, "npccrystal", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcEnderchibi.class, "npcenderchibi", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcNagaMale.class, "npcnagamale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcNagaFemale.class, "npcnagafemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcSlime.class, "NpcSlime", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcDragon.class, "NpcDragon", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCEnderman.class, "npcEnderman", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCGolem.class, "npcGolem", CustomNpcs.getEntityId());
        int thowid = CustomNpcs.getEntityId();
        EntityRegistry.registerGlobalEntityID(EntityProjectile.class, (String)"throwableitem", (int)thowid);
        EntityRegistry.registerModEntity(EntityProjectile.class, (String)"throwableitem", (int)thowid, (Object)this, (int)64, (int)3, (boolean)true);
    }

    @Mod.EventHandler
    public void setAboutToStart(FMLServerAboutToStartEvent event) {
        new PlayerDataController();
        new QuestController();
        new DialogController();
        new BankController();
        new RecipeController();
        new FactionController();
        new TransportController();
        new GlobalDataController();
    }

    @Mod.EventHandler
    public void serverstart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSlay());
    }

    public static int getEntityId() {
        if (UseUniqueEntities) {
            return EntityRegistry.findGlobalUniqueEntityId();
        }
        return EntityStartId++;
    }

    private void registerNpc(Class<? extends Entity> cl, String name, int id) {
        EntityRegistry.registerGlobalEntityID(cl, (String)name, (int)id);
        EntityRegistry.registerModEntity(cl, (String)name, (int)id, (Object)this, (int)80, (int)3, (boolean)true);
    }

    public static void GivePlayerItem(Entity entity, EntityPlayer player, ItemStack item) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        item = item.func_77946_l();
        float f = 0.7f;
        double d = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d1 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d2 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t + d, entity.field_70163_u + d1, entity.field_70161_v + d2, item);
        entityitem.field_145804_b = 2;
        entity.field_70170_p.func_72838_d((Entity)entityitem);
        int i = item.field_77994_a;
        if (player.field_71071_by.func_70441_a(item)) {
            entity.field_70170_p.func_72956_a((Entity)entityitem, "random.pop", 0.2f, ((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)entityitem, i);
            if (item.field_77994_a <= 0) {
                entityitem.func_70106_y();
            }
        }
    }

    public static File getWorldSaveDirectory() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        File saves = new File(".");
        if (server != null && !server.func_71262_S()) {
            saves = new File(Minecraft.func_71410_x().field_71412_D, "saves");
        }
        if (server != null) {
            File savedir = new File(new File(saves, server.func_71270_I()), "customnpcs");
            if (!savedir.exists()) {
                savedir.mkdir();
            }
            return savedir;
        }
        return null;
    }

    static {
        EnableUpdateChecker = true;
        FreezeNPCs = false;
        OpsOnly = false;
    }
}

