/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.ModelPartData;

public class EntityCustomNpc
extends EntityNPCInterface {
    public Entity renderEntity;
    public String renderEntityName = "";
    public ModelPartConfig arms = new ModelPartConfig();
    public ModelPartConfig body = new ModelPartConfig();
    public ModelPartConfig legs = new ModelPartConfig();
    public ModelPartConfig head = new ModelPartConfig();
    public ModelPartData legParts = new ModelPartData();
    private HashMap<String, ModelPartData> parts = new HashMap();
    public byte breasts = 0;
    public int animationStart;

    public EntityCustomNpc(World world) {
        super(world);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRenderEntityName(compound.func_74779_i("RenderEntityName"));
        this.arms.readFromNBT(compound.func_74775_l("ArmsConfig"));
        this.body.readFromNBT(compound.func_74775_l("BodyConfig"));
        this.legs.readFromNBT(compound.func_74775_l("LegsConfig"));
        this.head.readFromNBT(compound.func_74775_l("HeadConfig"));
        this.legParts.readFromNBT(compound.func_74775_l("LegParts"));
        HashMap<String, ModelPartData> parts = new HashMap<String, ModelPartData>();
        NBTTagList list = compound.func_150295_c("Parts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            ModelPartData part = new ModelPartData();
            part.readFromNBT(item);
            parts.put(item.func_74779_i("PartName"), part);
        }
        this.parts = parts;
        this.breasts = compound.func_74771_c("Breasts");
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("RenderEntityName", this.renderEntityName);
        compound.func_74782_a("ArmsConfig", (NBTBase)this.arms.writeToNBT());
        compound.func_74782_a("BodyConfig", (NBTBase)this.body.writeToNBT());
        compound.func_74782_a("LegsConfig", (NBTBase)this.legs.writeToNBT());
        compound.func_74782_a("HeadConfig", (NBTBase)this.head.writeToNBT());
        compound.func_74782_a("LegParts", (NBTBase)this.legParts.writeToNBT());
        NBTTagList list = new NBTTagList();
        for (String name : this.parts.keySet()) {
            NBTTagCompound item = this.parts.get(name).writeToNBT();
            item.func_74778_a("PartName", name);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Parts", (NBTBase)list);
        compound.func_74774_a("Breasts", this.breasts);
    }

    private void setRenderEntityName(String name) {
        this.renderEntity = null;
        try {
            Class<?> cls = Class.forName(name);
            if (EntityLivingBase.class.isAssignableFrom(cls)) {
                this.renderEntity = (Entity)cls.getConstructor(World.class).newInstance(this.field_70170_p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ModelPartData getPartData(String part) {
        return this.parts.get(part);
    }

    public float getBodyY() {
        if (this.legParts.type == 3) {
            return (0.9f - this.body.scaleY) * 0.75f + this.getLegsY();
        }
        if (this.legParts.type == 3) {
            return (0.5f - this.body.scaleY) * 0.75f + this.getLegsY();
        }
        return (1.0f - this.body.scaleY) * 0.75f + this.getLegsY();
    }

    public float getLegsY() {
        if (this.legParts.type == 3) {
            return (0.87f - this.legs.scaleY) * 1.0f;
        }
        return (1.0f - this.legs.scaleY) * 0.75f;
    }
}

