/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomTeleporter;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.QuestLogData;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumOptionType;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.containers.ContainerNPCFollower;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.BankData;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Line;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.PlayerTransportData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.roles.RoleFollower;

public class NoppesUtilPlayer {
    public static void changeFollowerState(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Follower) {
            return;
        }
        RoleFollower role = (RoleFollower)npc.roleInterface;
        EntityPlayer owner = role.getOwner();
        if (owner == null || !owner.func_70005_c_().equals(player.func_70005_c_())) {
            return;
        }
        role.isFollowing = !role.isFollowing;
    }

    public static void hireFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Follower) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCFollowerHire)) {
            return;
        }
        ContainerNPCFollowerHire container = (ContainerNPCFollowerHire)con;
        RoleFollower role = (RoleFollower)npc.roleInterface;
        NoppesUtilPlayer.followerBuy(role, (IInventory)container.currencyMatrix, player, npc);
    }

    public static void extendFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Follower) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCFollower)) {
            return;
        }
        ContainerNPCFollower container = (ContainerNPCFollower)con;
        RoleFollower role = (RoleFollower)npc.roleInterface;
        NoppesUtilPlayer.followerBuy(role, container.currencyMatrix, player, npc);
    }

    public static void transport(EntityPlayerMP player, EntityNPCInterface npc, String location) {
        TransportLocation loc = TransportController.getInstance().getTransport(location);
        PlayerTransportData playerdata = PlayerDataController.instance.getTransportData((EntityPlayer)player);
        if (loc == null || !loc.isDefault() && !playerdata.transports.contains(loc.id)) {
            return;
        }
        if (player.field_71093_bK != loc.dimension) {
            int dim = player.field_71093_bK;
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer wor = server.func_71218_a(player.field_71093_bK);
            player.field_71135_a.func_147364_a(loc.posX, loc.posY, loc.posZ, player.field_70177_z, player.field_70125_A);
            server.func_71203_ab().transferPlayerToDimension(player, loc.dimension, (Teleporter)new CustomTeleporter(wor));
            if (dim == 1 && player.func_70089_S()) {
                player.func_70012_b(loc.posX, loc.posY, loc.posZ, player.field_70177_z, player.field_70125_A);
                wor.func_72838_d((Entity)player);
            }
            player.field_70170_p.func_72866_a((Entity)player, false);
        } else {
            player.field_71135_a.func_147364_a(loc.posX, loc.posY, loc.posZ, player.field_70177_z, player.field_70125_A);
            player.field_70170_p.func_72866_a((Entity)player, false);
        }
    }

    private static void followerBuy(RoleFollower role, IInventory currencyInv, EntityPlayerMP player, EntityNPCInterface npc) {
        ItemStack currency = currencyInv.func_70301_a(0);
        if (currency == null) {
            return;
        }
        HashMap<ItemStack, Integer> cd = new HashMap<ItemStack, Integer>();
        for (int i : role.inventory.items.keySet()) {
            ItemStack is = role.inventory.items.get(i);
            if (is == null || is.func_77973_b() != currency.func_77973_b() || is.func_77981_g() && is.func_77960_j() != currency.func_77960_j()) continue;
            int days = 1;
            if (role.rates.containsKey(i)) {
                days = role.rates.get(i);
            }
            cd.put(is, days);
        }
        if (cd.size() == 0) {
            return;
        }
        int stackSize = currency.field_77994_a;
        int days = 0;
        int possibleDays = 0;
        int possibleSize = stackSize;
        while (true) {
            for (ItemStack item : cd.keySet()) {
                int newStackSize;
                int size;
                int posDays;
                int rDays = (Integer)cd.get(item);
                int rValue = item.field_77994_a;
                if (rValue > stackSize || possibleDays > (posDays = (size = stackSize - (newStackSize = stackSize % rValue)) / rValue * rDays)) continue;
                possibleDays = posDays;
                possibleSize = newStackSize;
            }
            if (stackSize == possibleSize) break;
            stackSize = possibleSize;
            days += possibleDays;
            possibleDays = 0;
        }
        if (days == 0) {
            return;
        }
        if (stackSize <= 0) {
            currencyInv.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(stackSize);
        }
        npc.say((EntityPlayer)player, new Line(role.dialogHire.replaceAll("\\{days\\}", days + "")));
        role.setOwner(player.func_70005_c_());
        role.addDays(days);
    }

    public static void bankUpgrade(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Bank) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return;
        }
        ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
        Bank bank = BankController.getInstance().getBank(container.bankid);
        ItemStack item = bank.upgradeInventory.func_70301_a(container.slot);
        if (item == null) {
            return;
        }
        int price = item.field_77994_a;
        ItemStack currency = container.currencyMatrix.func_70301_a(0);
        if (currency == null || price > currency.field_77994_a) {
            return;
        }
        if (currency.field_77994_a - price == 0) {
            container.currencyMatrix.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(price);
        }
        PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
        BankData bankData = data.getBank(bank.id);
        bankData.upgradedSlots.put(container.slot, true);
        PlayerDataController.instance.savePlayerData((EntityPlayer)player, data);
        bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
    }

    public static void bankUnlock(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Bank) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return;
        }
        ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
        Bank bank = BankController.getInstance().getBank(container.bankid);
        ItemStack item = bank.currencyInventory.func_70301_a(container.slot);
        if (item == null) {
            return;
        }
        int price = item.field_77994_a;
        ItemStack currency = container.currencyMatrix.func_70301_a(0);
        if (currency == null || price > currency.field_77994_a) {
            return;
        }
        if (currency.field_77994_a - price == 0) {
            container.currencyMatrix.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(price);
        }
        PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
        BankData bankData = data.getBank(bank.id);
        if (bankData.unlockedSlots + 1 <= bank.maxSlots) {
            ++bankData.unlockedSlots;
        }
        PlayerDataController.instance.savePlayerData((EntityPlayer)player, data);
        bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
    }

    public static void sendData(EnumPlayerPacket enu, Object ... obs) {
        try {
            CustomNpcs.ChannelPlayer.sendToServer(new FMLProxyPacket(Server.getBytes(enu, obs), "CustomNPCsPlayer"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dialogSelected(int dialogId, int optionId, EntityPlayer player, EntityNPCInterface npc) {
        Dialog dialog = DialogController.instance.dialogs.get(dialogId);
        if (dialog == null || !dialog.hasDialogs(player) && !dialog.hasOtherOptions()) {
            return;
        }
        DialogOption option = dialog.options.get(optionId);
        if (option == null || option.optionType == EnumOptionType.DialogOption && (!option.isAvailable(player) || !option.hasDialog()) || option.optionType == EnumOptionType.Disabled) {
            return;
        }
        if (option.optionType == EnumOptionType.RoleOption) {
            if (npc.roleInterface != null) {
                npc.roleInterface.interact(player);
            }
        } else if (option.optionType == EnumOptionType.DialogOption) {
            NoppesUtilServer.openDialog(player, npc, option.getDialog());
        } else if (option.optionType == EnumOptionType.CommandBlock) {
            NoppesUtilServer.runCommand(player, npc.func_70005_c_(), option.command);
        }
    }

    public static void sendQuestLogData(EntityPlayerMP player) {
        if (!PlayerQuestController.hasActiveQuests((EntityPlayer)player)) {
            return;
        }
        QuestLogData data = new QuestLogData();
        data.setData((EntityPlayer)player);
        Server.sendData(player, EnumPackets.GuiData, data.writeNBT());
    }

    public static void questCompletion(EntityPlayerMP player, int questId) {
        PlayerQuestData playerdata = PlayerDataController.instance.getQuestData((EntityPlayer)player);
        QuestData data = playerdata.activeQuests.get(questId);
        if (data == null) {
            return;
        }
        if (!data.quest.questInterface.isCompleted((EntityPlayer)player)) {
            return;
        }
        data.quest.questInterface.handleComplete((EntityPlayer)player);
        if (data.quest.rewardExp > 0) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            player.func_71023_q(data.quest.rewardExp);
        }
        data.quest.factionOptions.addPoints((EntityPlayer)player);
        if (data.quest.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_70005_c_(), data.quest.mail);
        }
        for (ItemStack item : data.quest.rewardItems.items.values()) {
            CustomNpcs.GivePlayerItem((Entity)player, (EntityPlayer)player, item);
        }
        if (!data.quest.command.isEmpty()) {
            NoppesUtilServer.runCommand((EntityPlayer)player, "QuestCompletion", data.quest.command);
        }
        PlayerQuestController.setQuestFinished(data.quest, (EntityPlayer)player);
        if (data.quest.hasNewQuest()) {
            PlayerQuestController.addActiveQuest(data.quest.getNextQuest(), (EntityPlayer)player);
        }
    }

    public static boolean compareItems(ItemStack var9, ItemStack var10, boolean ignoreDamage) {
        if (var10 == null && var9 != null || var10 != null && var9 == null) {
            return false;
        }
        if (var9.func_77973_b() != var10.func_77973_b()) {
            return false;
        }
        if (var9.func_77960_j() != -1 && var9.func_77960_j() != var10.func_77960_j() && !ignoreDamage) {
            return false;
        }
        return var9.field_77990_d == null || var10.field_77990_d != null && var9.field_77990_d.equals((Object)var10.field_77990_d);
    }
}

