/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogCategory;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.IPlayerData;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerFactionData;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.PlayerTransportData;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestCategory;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.TransportCategory;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.roles.RoleTransporter;

public class NoppesUtilServer {
    private static HashMap<String, EntityNPCInterface> selectedNpcs = new HashMap();
    private static HashMap<String, Quest> editingQuests = new HashMap();

    public static void setEditingNpc(EntityPlayer player, EntityNPCInterface npc) {
        selectedNpcs.put(player.func_70005_c_(), npc);
        if (npc != null) {
            Server.sendData((EntityPlayerMP)player, EnumPackets.EditingNpc, npc.func_145782_y());
        }
    }

    public static EntityNPCInterface getEditingNpc(EntityPlayer player) {
        return selectedNpcs.get(player.func_70005_c_());
    }

    public static void setEditingQuest(EntityPlayer player, Quest quest) {
        editingQuests.put(player.func_70005_c_(), quest);
    }

    public static Quest getEditingQuest(EntityPlayer player) {
        return editingQuests.get(player.func_70005_c_());
    }

    private static void sendRoleData(EntityPlayer player, EntityNPCInterface npc) {
        if (npc.advanced.role == EnumRoleType.None) {
            return;
        }
        NBTTagCompound comp = new NBTTagCompound();
        npc.roleInterface.writeEntityToNBT(comp);
        comp.func_74768_a("EntityId", npc.func_145782_y());
        comp.func_74768_a("Role", npc.advanced.role.ordinal());
        Server.sendData((EntityPlayerMP)player, EnumPackets.SaveRole, comp);
    }

    public static void sendFactionDataAll(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Faction faction : FactionController.getInstance().factions.values()) {
            map.put(faction.name, faction.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendBankDataAll(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Bank bank : BankController.getInstance().banks.values()) {
            map.put(bank.name, bank.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void openDialog(EntityPlayer player, EntityNPCInterface npc, Dialog dia) {
        Dialog dialog = dia.copy(player);
        Server.sendData((EntityPlayerMP)player, EnumPackets.Dialog, npc.func_145782_y(), dialog.writeToNBT(new NBTTagCompound()));
        dia.factionOptions.addPoints(player);
        if (dialog.hasQuest()) {
            PlayerQuestController.addActiveQuest(dialog.getQuest(), player);
        }
        if (!dialog.command.isEmpty()) {
            NoppesUtilServer.runCommand(player, npc.func_70005_c_(), dialog.command);
        }
        if (dialog.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_70005_c_(), dialog.mail);
        }
        PlayerDataController.instance.setDialogRead(dialog.id, player);
        NoppesUtilServer.setEditingNpc(player, npc);
    }

    public static void runCommand(EntityPlayer player, String name, String command) {
        command = command.replaceAll("@dp", player.func_70005_c_());
        TileEntityCommandBlock tile = new TileEntityCommandBlock();
        tile.func_145834_a(player.field_70170_p);
        tile.field_145851_c = MathHelper.func_76128_c((double)player.field_70165_t);
        tile.field_145848_d = MathHelper.func_76128_c((double)player.field_70163_u);
        tile.field_145849_e = MathHelper.func_76128_c((double)player.field_70161_v);
        CommandBlockLogic logic = tile.func_145993_a();
        logic.func_145752_a(command);
        logic.func_145754_b("@" + name);
        logic.func_145755_a(player.field_70170_p);
    }

    public static DataOutputStream getDataOutputStream(ByteArrayOutputStream stream) throws IOException {
        return new DataOutputStream(new GZIPOutputStream(stream));
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        NoppesUtilServer.sendOpenGui(player, gui, npc, 0, 0, 0);
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc, int i, int j, int k) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        NoppesUtilServer.sendExtraData(player, npc, gui, i, j, k);
        if (CustomNpcs.proxy.getServerGuiElement(gui.ordinal(), player, player.field_70170_p, i, j, k) != null) {
            player.openGui((Object)CustomNpcs.instance, gui.ordinal(), player.field_70170_p, i, j, k);
            return;
        }
        Server.sendData((EntityPlayerMP)player, EnumPackets.Gui, gui.ordinal());
        ArrayList<String> list = NoppesUtilServer.getScrollData(player, gui, npc);
        if (list == null || list.isEmpty()) {
            return;
        }
        Server.sendData((EntityPlayerMP)player, EnumPackets.ScrollList, list);
    }

    private static void sendExtraData(EntityPlayer player, EntityNPCInterface npc, EnumGuiType gui, int i, int j, int k) {
        if (gui == EnumGuiType.PlayerFollower || gui == EnumGuiType.PlayerFollowerHire || gui == EnumGuiType.PlayerTrader || gui == EnumGuiType.PlayerTransporter) {
            NoppesUtilServer.sendRoleData(player, npc);
        }
    }

    private static ArrayList<String> getScrollData(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        if (gui == EnumGuiType.PlayerTransporter) {
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            ArrayList<String> list = new ArrayList<String>();
            TransportLocation location = role.getLocation();
            String name = role.getLocation().name;
            for (TransportLocation loc : location.category.getDefaultLocations()) {
                if (list.contains(loc.name)) continue;
                list.add(loc.name);
            }
            PlayerTransportData playerdata = PlayerDataController.instance.getTransportData(player);
            for (int i : playerdata.transports) {
                TransportLocation loc = TransportController.getInstance().getTransport(i);
                if (loc == null || !location.category.locations.containsKey(loc.id) || list.contains(loc.name)) continue;
                list.add(loc.name);
            }
            list.remove(name);
            return list;
        }
        return null;
    }

    public static void spawnParticle(Entity entity, String particle, int dimension) {
        Server.sendAssociatedData(entity, EnumPackets.Particle, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Float.valueOf(entity.field_70131_O), Float.valueOf(entity.field_70130_N), Float.valueOf(entity.field_70129_M), particle);
    }

    public static void deleteNpc(EntityNPCInterface npc, EntityPlayer player) {
        Server.sendAssociatedData((Entity)npc, EnumPackets.Delete, npc.func_145782_y());
    }

    public static void createMobSpawner(ByteBufInputStream dis, EntityPlayer player) {
        try {
            MobSpawnerBaseLogic logic;
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            NBTTagCompound comp = CompressedStreamTools.func_74794_a((DataInput)dis);
            if (comp.func_74779_i("id").equalsIgnoreCase("entityhorse")) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("Currently you cant create horse spawner, its a minecraft bug", new Object[0]));
                return;
            }
            player.field_70170_p.func_147449_b(x, y, z, Blocks.field_150474_ac);
            TileEntityMobSpawner tile = (TileEntityMobSpawner)player.field_70170_p.func_147438_o(x, y, z);
            MobSpawnerBaseLogic mobSpawnerBaseLogic = logic = tile.func_145881_a();
            mobSpawnerBaseLogic.getClass();
            logic.func_98277_a(new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, comp, comp.func_74779_i("id")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendDialogCategoryData(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DialogCategory category : DialogController.instance.categories.values()) {
            map.put(category.title, category.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendQuestCategoryData(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (QuestCategory category : QuestController.instance.categories.values()) {
            map.put(category.title, category.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendPlayerData(EnumPlayerData type, EntityPlayerMP player, String name) throws IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (type == EnumPlayerData.Players) {
            File loc = PlayerDataController.instance.getSaveDir();
            for (File file : loc.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(".dat")) continue;
                map.put(file.getName().substring(0, file.getName().length() - 4), 0);
            }
        } else {
            IPlayerData data;
            PlayerData playerdata = new PlayerData(PlayerDataController.instance.loadPlayerData(name));
            if (type == EnumPlayerData.Dialog) {
                data = playerdata.dialogData;
                for (int questId : ((PlayerDialogData)data).dialogsRead) {
                    Dialog dialog = DialogController.instance.dialogs.get(questId);
                    if (dialog == null) continue;
                    map.put(dialog.category.title + ": " + dialog.title, questId);
                }
            } else if (type == EnumPlayerData.Quest) {
                Quest quest;
                data = playerdata.questData;
                for (int questId : ((PlayerQuestData)data).activeQuests.keySet()) {
                    quest = QuestController.instance.quests.get(questId);
                    if (quest == null) continue;
                    map.put(quest.category.title + ": " + quest.title + "(Active quest)", questId);
                }
                for (int questId : ((PlayerQuestData)data).finishedQuests.keySet()) {
                    quest = QuestController.instance.quests.get(questId);
                    if (quest == null) continue;
                    map.put(quest.category.title + ": " + quest.title + "(Finished quest)", questId);
                }
            } else if (type == EnumPlayerData.Transport) {
                data = playerdata.transportData;
                for (int questId : ((PlayerTransportData)data).transports) {
                    TransportLocation location = TransportController.getInstance().getTransport(questId);
                    if (location == null) continue;
                    map.put(location.category.title + ": " + location.name, questId);
                }
            } else if (type == EnumPlayerData.Bank) {
                data = playerdata.bankData;
                for (int bankId : ((PlayerBankData)data).banks.keySet()) {
                    Bank bank = BankController.getInstance().banks.get(bankId);
                    if (bank == null) continue;
                    map.put(bank.name, bankId);
                }
            } else if (type == EnumPlayerData.Factions) {
                data = playerdata.factionData;
                for (int factionId : ((PlayerFactionData)data).factionData.keySet()) {
                    Faction faction = FactionController.getInstance().factions.get(factionId);
                    if (faction == null) continue;
                    map.put(faction.name + "(" + ((PlayerFactionData)data).getFactionPoints(factionId) + ")", factionId);
                }
            }
        }
        HashMap toSend = new HashMap();
        for (String s : map.keySet()) {
            if (toSend.size() == 1000) {
                Server.sendData(player, EnumPackets.ScrollData, toSend);
                toSend = new HashMap();
            }
            toSend.put(s, map.get(s));
        }
        Server.sendData(player, EnumPackets.ScrollData, toSend);
    }

    public static void removePlayerData(ByteBufInputStream dis, EntityPlayerMP player) throws IOException {
        EntityPlayer pl;
        IPlayerData data;
        int id = dis.readInt();
        if (EnumPlayerData.values().length <= id) {
            return;
        }
        String name = dis.readUTF();
        EnumPlayerData type = EnumPlayerData.values()[id];
        PlayerData playerdata = new PlayerData(PlayerDataController.instance.loadPlayerData(name));
        if (type == EnumPlayerData.Players) {
            File file = new File(PlayerDataController.instance.getSaveDir(), name + ".dat");
            if (!file.exists()) {
                return;
            }
            file.delete();
        }
        if (type == EnumPlayerData.Quest) {
            data = playerdata.questData;
            int questId = dis.readInt();
            data.activeQuests.remove(questId);
            data.finishedQuests.remove(questId);
            PlayerDataController.instance.savePlayerData(name, playerdata.getNBT());
        }
        if (type == EnumPlayerData.Dialog) {
            data = playerdata.dialogData;
            ((PlayerDialogData)data).dialogsRead.remove(dis.readInt());
            PlayerDataController.instance.savePlayerData(name, playerdata.getNBT());
        }
        if (type == EnumPlayerData.Transport) {
            data = playerdata.transportData;
            ((PlayerTransportData)data).transports.remove(dis.readInt());
            PlayerDataController.instance.savePlayerData(name, playerdata.getNBT());
        }
        if (type == EnumPlayerData.Bank) {
            data = playerdata.bankData;
            ((PlayerBankData)data).banks.remove(dis.readInt());
            PlayerDataController.instance.savePlayerData(name, playerdata.getNBT());
        }
        if (type == EnumPlayerData.Factions) {
            data = playerdata.factionData;
            ((PlayerFactionData)data).factionData.remove(dis.readInt());
            PlayerDataController.instance.savePlayerData(name, playerdata.getNBT());
        }
        if ((pl = player.field_70170_p.func_72924_a(name)) != null) {
            pl.getEntityData().func_82580_o("CustomNpcsId");
        }
        NoppesUtilServer.sendPlayerData(type, player, name);
    }

    public static void sendRecipeData(EntityPlayerMP player, int size) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (size == 3) {
            for (RecipeCarpentry recipe : RecipeController.instance.globalRecipes.values()) {
                map.put(recipe.name, recipe.id);
            }
        } else {
            for (RecipeCarpentry recipe : RecipeController.instance.anvilRecipes.values()) {
                map.put(recipe.name, recipe.id);
            }
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendDialogData(EntityPlayerMP player, DialogCategory category) {
        if (category == null) {
            return;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Dialog dialog : category.dialogs.values()) {
            map.put(dialog.title, dialog.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendQuestData(EntityPlayerMP player, QuestCategory category) {
        if (category == null) {
            return;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Quest quest : category.quests.values()) {
            map.put(quest.title, quest.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendTransportCategoryData(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (TransportCategory category : TransportController.getInstance().categories.values()) {
            map.put(category.title, category.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendTransportData(EntityPlayerMP player, int categoryid) {
        TransportCategory category = TransportController.getInstance().categories.get(categoryid);
        if (category == null) {
            return;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (TransportLocation transport : category.locations.values()) {
            map.put(transport.name, transport.id);
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendNpcDialogs(EntityPlayer player) {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        if (npc == null) {
            return;
        }
        for (int pos : npc.dialogs.keySet()) {
            DialogOption option = npc.dialogs.get(pos);
            if (option == null || !option.hasDialog()) continue;
            NBTTagCompound compound = option.writeNBT();
            compound.func_74768_a("Position", pos);
            Server.sendData((EntityPlayerMP)player, EnumPackets.GuiData, compound);
        }
    }

    public static DialogOption setNpcDialog(int slot, int dialogId, EntityPlayer player) throws IOException {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        if (npc == null) {
            return null;
        }
        if (!npc.dialogs.containsKey(slot)) {
            npc.dialogs.put(slot, new DialogOption());
        }
        DialogOption option = npc.dialogs.get(slot);
        option.dialogId = dialogId;
        if (option.hasDialog()) {
            option.title = option.getDialog().title;
        }
        return option;
    }

    public static void saveTileEntity(EntityPlayerMP player, ByteBufInputStream dis) throws IOException {
        int z;
        int y;
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
        int x = compound.func_74762_e("x");
        TileEntity tile = player.field_70170_p.func_147438_o(x, y = compound.func_74762_e("y"), z = compound.func_74762_e("z"));
        if (tile != null) {
            tile.func_145839_a(compound);
        }
    }

    public static void setRecipeGui(EntityPlayerMP player, RecipeCarpentry recipe) {
        if (recipe == null) {
            return;
        }
        if (!(player.field_71070_bA instanceof ContainerManageRecipes)) {
            return;
        }
        ContainerManageRecipes container = (ContainerManageRecipes)player.field_71070_bA;
        container.setRecipe(recipe);
        Server.sendData(player, EnumPackets.GuiData, recipe.writeNBT());
    }

    public static void sendBank(EntityPlayerMP player, Bank bank) {
        NBTTagCompound compound = new NBTTagCompound();
        bank.writeEntityToNBT(compound);
        Server.sendData(player, EnumPackets.GuiData, compound);
        if (player.field_71070_bA instanceof ContainerManageBanks) {
            ((ContainerManageBanks)player.field_71070_bA).setBank(bank);
        }
        player.func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
    }

    public static void sendNearbyNpcs(EntityPlayerMP player) {
        List npcs = player.field_70170_p.func_72872_a(EntityNPCInterface.class, player.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (EntityNPCInterface npc : npcs) {
            if (npc.field_70128_L) continue;
            float distance = player.func_70032_d((Entity)npc);
            DecimalFormat df = new DecimalFormat("#.#");
            String s = df.format(distance);
            if (distance < 10.0f) {
                s = "0" + s;
            }
            map.put(s + " : " + npc.display.name, npc.func_145782_y());
        }
        Server.sendData(player, EnumPackets.ScrollData, map);
    }

    public static void sendGuiError(EntityPlayer player, int i) {
        Server.sendData((EntityPlayerMP)player, EnumPackets.GuiError, i, new NBTTagCompound());
    }

    public static void sendGuiClose(EntityPlayerMP player, int i, NBTTagCompound comp) {
        Server.sendData(player, EnumPackets.GuiClose, i, comp);
    }
}

