/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogCategory;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestCategory;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.permissions.CustomNpcsPermissions;
import noppes.npcs.roles.RoleTransporter;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBufInputStream dis = new ByteBufInputStream(event.packet.payload());
        try {
            this.server(event.packet.payload(), dis, player);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void server(ByteBuf buffer, ByteBufInputStream dis, EntityPlayerMP player) throws IOException {
        EnumPackets type = EnumPackets.values()[dis.readInt()];
        if (CustomNpcs.OpsOnly && !MinecraftServer.func_71276_C().func_71203_ab().func_72376_i().contains(player.func_70005_c_().toLowerCase())) {
            MinecraftServer.func_71276_C().func_71236_h(player.func_70005_c_() + ": tried to use custom npcs without being an op");
            return;
        }
        if (type.hasPermission() && !CustomNpcsPermissions.Instance.hasPermission(player.func_70005_c_(), type.permission)) {
            return;
        }
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
        if (type.needsNpc && npc == null) {
            return;
        }
        if (type == EnumPackets.Delete) {
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
        } else if (type == EnumPackets.ChangeModel) {
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            npc = (EntityNPCInterface)EntityList.func_75615_a((NBTTagCompound)CompressedStreamTools.func_74794_a((DataInput)dis), (World)player.field_70170_p);
            npc.startPos = new int[]{x, y, z};
            npc.func_70107_b((float)x + 0.5f, npc.getStartYPos(), (float)z + 0.5f);
            npc.func_70606_j(npc.func_110138_aP());
            player.field_70170_p.func_72838_d((Entity)npc);
            NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
        } else if (type == EnumPackets.Bank) {
            BankController.getInstance().loadBanks(dis);
            BankController.getInstance().saveBanks();
        } else if (type == EnumPackets.BanksGet) {
            NoppesUtilServer.sendBankDataAll(player);
        } else if (type == EnumPackets.BankGet) {
            Bank bank = BankController.getInstance().getBank(dis.readInt());
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPackets.BankSave) {
            Bank bank = new Bank();
            bank.readEntityFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            BankController.getInstance().saveBank(bank);
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPackets.BankRemove) {
            BankController.getInstance().removeBank(dis.readInt());
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, new Bank());
        } else if (type == EnumPackets.SaveNpc) {
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            npc.func_70020_e(compound);
            npc.reset();
            Server.sendAssociatedData((Entity)npc, EnumPackets.UpdateNpc, npc.copy());
        } else if (type == EnumPackets.RemoteMainMenu) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)entity);
        } else if (type == EnumPackets.RemoteDelete) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
            NoppesUtilServer.sendNearbyNpcs(player);
        } else if (type == EnumPackets.RemoteNpcsGet) {
            NoppesUtilServer.sendNearbyNpcs(player);
            Server.sendData(player, EnumPackets.ScrollSelected, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPackets.RemoteFreeze) {
            CustomNpcs.FreezeNPCs = !CustomNpcs.FreezeNPCs;
            Server.sendData(player, EnumPackets.ScrollSelected, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPackets.RemoteReset) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.reset();
        } else if (type == EnumPackets.RemoteTpToNpc) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            player.field_71135_a.func_147364_a(npc.field_70165_t, npc.field_70163_u, npc.field_70161_v, 0.0f, 0.0f);
        } else if (type == EnumPackets.SpawnMob) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)CompressedStreamTools.func_74794_a((DataInput)dis), (World)player.field_70170_p);
            player.field_70170_p.func_72838_d(entity);
        } else if (type == EnumPackets.SpawnRider) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)CompressedStreamTools.func_74794_a((DataInput)dis), (World)player.field_70170_p);
            player.field_70170_p.func_72838_d(entity);
            entity.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPackets.PlayerRider) {
            player.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPackets.SpawnNpc) {
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            npc = (EntityNPCInterface)EntityList.func_75615_a((NBTTagCompound)CompressedStreamTools.func_74794_a((DataInput)dis), (World)player.field_70170_p);
            npc.startPos = new int[]{x, y, z};
            npc.func_70107_b((float)x + 0.5f, npc.getStartYPos(), (float)z + 0.5f);
            npc.func_70606_j(npc.func_110138_aP());
            player.field_70170_p.func_72838_d((Entity)npc);
            NoppesUtilServer.setEditingNpc((EntityPlayer)player, npc);
        } else if (type == EnumPackets.MobSpawner) {
            NoppesUtilServer.createMobSpawner(dis, (EntityPlayer)player);
        } else if (type == EnumPackets.Gui) {
            EnumGuiType gui = EnumGuiType.values()[dis.readInt()];
            int i = dis.readInt();
            int j = dis.readInt();
            int k = dis.readInt();
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, gui, NoppesUtilServer.getEditingNpc((EntityPlayer)player), i, j, k);
        } else if (type == EnumPackets.RecipesGet) {
            NoppesUtilServer.sendRecipeData(player, dis.readInt());
        } else if (type == EnumPackets.RecipeGet) {
            RecipeCarpentry recipe = RecipeController.instance.getRecipe(dis.readInt());
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPackets.RecipeRemove) {
            RecipeCarpentry recipe = RecipeController.instance.removeRecipe(dis.readInt());
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, new RecipeCarpentry());
        } else if (type == EnumPackets.RecipeSave) {
            RecipeCarpentry recipe = RecipeController.instance.saveRecipe(dis);
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPackets.DialogCategoriesGet) {
            NoppesUtilServer.sendDialogCategoryData(player);
        } else if (type == EnumPackets.DialogCategorySave) {
            DialogCategory category = new DialogCategory();
            category.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            DialogController.instance.saveCategory(category);
            NoppesUtilServer.sendDialogCategoryData(player);
        } else if (type == EnumPackets.DialogCategoryRemove) {
            DialogController.instance.removeCategory(dis);
            NoppesUtilServer.sendDialogCategoryData(player);
        } else if (type == EnumPackets.DialogCategoryGet) {
            DialogCategory category = DialogController.instance.categories.get(dis.readInt());
            if (category != null) {
                Server.sendData(player, EnumPackets.GuiData, category.writeNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPackets.DialogsGet) {
            NoppesUtilServer.sendDialogData(player, DialogController.instance.categories.get(dis.readInt()));
        } else if (type == EnumPackets.DialogGet) {
            Dialog dialog = DialogController.instance.dialogs.get(dis.readInt());
            if (dialog != null) {
                NBTTagCompound compound = dialog.writeToNBT(new NBTTagCompound());
                Quest quest = QuestController.instance.quests.get(dialog.quest);
                if (quest != null) {
                    compound.func_74778_a("DialogQuestName", quest.title);
                }
                Server.sendData(player, EnumPackets.GuiData, compound);
            }
        } else if (type == EnumPackets.DialogsGetFromDialog) {
            Dialog dialog = DialogController.instance.dialogs.get(dis.readInt());
            if (dialog == null) {
                return;
            }
            NoppesUtilServer.sendDialogData(player, dialog.category);
        } else if (type == EnumPackets.DialogSave) {
            int category = dis.readInt();
            Dialog dialog = new Dialog();
            dialog.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            DialogController.instance.saveDialog(category, dialog);
            if (dialog.category != null) {
                NoppesUtilServer.sendDialogData(player, dialog.category);
            }
        } else if (type == EnumPackets.QuestOpenGui) {
            Quest quest = new Quest();
            int gui = dis.readInt();
            quest.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            NoppesUtilServer.setEditingQuest((EntityPlayer)player, quest);
            player.openGui((Object)CustomNpcs.instance, gui, player.field_70170_p, 0, 0, 0);
        } else if (type == EnumPackets.DialogEdit) {
            Dialog dialog = DialogController.instance.dialogs.get(dis.readInt());
            if (dialog != null) {
                Server.sendData(player, EnumPackets.GuiData, dialog.writeToNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPackets.DialogRemove) {
            Dialog dialog = DialogController.instance.dialogs.get(dis.readInt());
            if (dialog != null && dialog.category != null) {
                DialogController.instance.removeDialog(dialog);
                NoppesUtilServer.sendDialogData(player, dialog.category);
            }
        } else if (type == EnumPackets.DialogNpcGet) {
            NoppesUtilServer.sendNpcDialogs((EntityPlayer)player);
        } else if (type == EnumPackets.DialogNpcSet) {
            int dialog;
            int slot = dis.readInt();
            DialogOption option = NoppesUtilServer.setNpcDialog(slot, dialog = dis.readInt(), (EntityPlayer)player);
            if (option != null && option.hasDialog()) {
                NBTTagCompound compound = option.writeNBT();
                compound.func_74768_a("Position", slot);
                Server.sendData(player, EnumPackets.GuiData, compound);
            }
        } else if (type == EnumPackets.DialogNpcRemove) {
            npc.dialogs.remove(dis.readInt());
        } else if (type == EnumPackets.QuestGet) {
            Quest quest = QuestController.instance.quests.get(dis.readInt());
            if (quest != null) {
                NBTTagCompound compound = new NBTTagCompound();
                if (quest.hasNewQuest()) {
                    compound.func_74778_a("NextQuestTitle", quest.getNextQuest().title);
                }
                Server.sendData(player, EnumPackets.GuiData, quest.writeToNBT(compound));
            }
        } else if (type == EnumPackets.QuestCategoryGet) {
            QuestCategory category = QuestController.instance.categories.get(dis.readInt());
            if (category != null) {
                Server.sendData(player, EnumPackets.GuiData, category.writeNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPackets.QuestCategorySave) {
            QuestCategory category = new QuestCategory();
            category.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            QuestController.instance.saveCategory(category);
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPackets.QuestCategoriesGet) {
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPackets.QuestCategoryRemove) {
            QuestController.instance.removeCategory(dis);
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPackets.QuestsGet) {
            QuestCategory category = QuestController.instance.categories.get(dis.readInt());
            NoppesUtilServer.sendQuestData(player, category);
        } else if (type == EnumPackets.QuestsGetFromQuest) {
            Quest quest = QuestController.instance.quests.get(dis.readInt());
            if (quest == null) {
                return;
            }
            NoppesUtilServer.sendQuestData(player, quest.category);
        } else if (type == EnumPackets.QuestEdit) {
            Quest quest = QuestController.instance.quests.get(dis.readInt());
            if (quest != null) {
                Server.sendData(player, EnumPackets.GuiData, quest.writeToNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPackets.QuestSave) {
            Quest quest = QuestController.instance.saveQuest(dis);
            if (quest.category != null) {
                NoppesUtilServer.sendQuestData(player, quest.category);
            }
        } else if (type == EnumPackets.QuestRemove) {
            Quest quest = QuestController.instance.quests.get(dis.readInt());
            if (quest != null) {
                QuestController.instance.removeQuest(quest);
                NoppesUtilServer.sendQuestData(player, quest.category);
            }
        } else if (type == EnumPackets.TransportCategoriesGet) {
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPackets.TransportCategorySave) {
            TransportController.getInstance().saveCategory(dis);
        } else if (type == EnumPackets.TransportCategoryRemove) {
            TransportController.getInstance().removeCategory(dis.readInt());
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPackets.TransportRemove) {
            int id = dis.readInt();
            TransportController.getInstance().removeLocation(id);
            NoppesUtilServer.sendTransportData(player, id);
        } else if (type == EnumPackets.TransportsGet) {
            NoppesUtilServer.sendTransportData(player, dis.readInt());
        } else if (type == EnumPackets.TransportSave) {
            int cat = dis.readInt();
            TransportLocation location = TransportController.getInstance().saveLocation(cat, dis, player, NoppesUtilServer.getEditingNpc((EntityPlayer)player));
            if (location != null) {
                if (npc.advanced.role != EnumRoleType.Transporter) {
                    return;
                }
                RoleTransporter role = (RoleTransporter)npc.roleInterface;
                role.setTransport(location);
                Server.sendAssociatedData((Entity)npc, EnumPackets.UpdateNpc, npc.copy());
            }
        } else if (type == EnumPackets.SaveTileEntity) {
            NoppesUtilServer.saveTileEntity(player, dis);
        } else if (type == EnumPackets.TransportGetLocation) {
            if (npc.advanced.role != EnumRoleType.Transporter) {
                return;
            }
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            if (role.hasTransport()) {
                Server.sendData(player, EnumPackets.GuiData, role.getLocation().writeNBT());
                Server.sendData(player, EnumPackets.ScrollSelected, role.getLocation().category.title);
            }
        } else if (type == EnumPackets.FactionsGet) {
            NoppesUtilServer.sendFactionDataAll(player);
        } else if (type == EnumPackets.FactionSet) {
            npc.setFaction(dis.readInt());
        } else if (type == EnumPackets.FactionSave) {
            Faction faction = new Faction();
            faction.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            FactionController.getInstance().saveFaction(faction);
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            faction.writeNBT(compound);
            Server.sendData(player, EnumPackets.GuiData, compound);
        } else if (type == EnumPackets.FactionRemove) {
            FactionController.getInstance().removeFaction(dis.readInt());
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            new Faction().writeNBT(compound);
            Server.sendData(player, EnumPackets.GuiData, compound);
        } else if (type == EnumPackets.FactionGet) {
            NBTTagCompound compound = new NBTTagCompound();
            Faction faction = FactionController.getInstance().getFaction(dis.readInt());
            faction.writeNBT(compound);
            Server.sendData(player, EnumPackets.GuiData, compound);
        } else if (type == EnumPackets.PlayerDataGet) {
            int id = dis.readInt();
            if (EnumPlayerData.values().length <= id) {
                return;
            }
            String name = null;
            EnumPlayerData datatype = EnumPlayerData.values()[id];
            if (datatype != EnumPlayerData.Players) {
                name = dis.readUTF();
            }
            NoppesUtilServer.sendPlayerData(datatype, player, name);
        } else if (type == EnumPackets.PlayerDataRemove) {
            NoppesUtilServer.removePlayerData(dis, player);
        } else if (type == EnumPackets.MainmenuDisplayGet) {
            Server.sendData(player, EnumPackets.GuiData, npc.display.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPackets.MainmenuDisplaySave) {
            npc.display.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            Server.sendAssociatedData((Entity)npc, EnumPackets.UpdateNpc, npc.copy());
        } else if (type == EnumPackets.MainmenuStatsGet) {
            Server.sendData(player, EnumPackets.GuiData, npc.stats.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPackets.MainmenuStatsSave) {
            npc.stats.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            Server.sendAssociatedData((Entity)npc, EnumPackets.UpdateNpc, npc.copy());
        } else if (type == EnumPackets.MainmenuInvGet) {
            Server.sendData(player, EnumPackets.GuiData, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
        } else if (type == EnumPackets.MainmenuInvSave) {
            npc.inventory.readEntityFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            npc.updateTasks();
            Server.sendAssociatedData((Entity)npc, EnumPackets.UpdateNpc, npc.copy());
        } else if (type == EnumPackets.MainmenuAIGet) {
            Server.sendData(player, EnumPackets.GuiData, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPackets.MainmenuAISave) {
            npc.ai.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            npc.updateTasks();
            Server.sendAssociatedData((Entity)npc, EnumPackets.UpdateNpc, npc.copy());
        } else if (type == EnumPackets.MainmenuAdvancedGet) {
            Server.sendData(player, EnumPackets.GuiData, npc.advanced.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPackets.MainmenuAdvancedSave) {
            npc.advanced.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            npc.updateTasks();
            Server.sendAssociatedData((Entity)npc, EnumPackets.UpdateNpc, npc.copy());
        } else if (type == EnumPackets.MerchantUpdate) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityVillager)) {
                return;
            }
            MerchantRecipeList list = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ((EntityVillager)entity).func_70930_a(list);
        }
    }
}

