/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.client.controllers.CloneController;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.items.ItemExcalibur;
import noppes.npcs.items.ItemShield;
import noppes.npcs.permissions.CustomNpcsPermissions;
import noppes.npcs.quests.QuestKill;

public class ServerEventsHandler {
    public static EntityVillager Merchant;
    public static Entity mounted;

    @SubscribeEvent
    public void invoke(EntityInteractEvent event) {
        ItemStack item = event.entityPlayer.func_71045_bC();
        if (item == null) {
            return;
        }
        boolean isRemote = event.entityPlayer.field_70170_p.field_72995_K;
        boolean npcInteracted = event.target instanceof EntityNPCInterface;
        if (item.func_77973_b() == CustomItems.wand && npcInteracted && !isRemote) {
            if (!CustomNpcsPermissions.Instance.hasPermission(event.entityPlayer.func_70005_c_(), "customnpcs.npc.edit")) {
                return;
            }
            event.setCanceled(true);
            NoppesUtilServer.sendOpenGui(event.entityPlayer, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)event.target);
        } else if (item.func_77973_b() == CustomItems.cloner && isRemote) {
            CloneController.toClone = event.target;
            CustomNpcs.proxy.openGui(0, 0, 0, EnumGuiType.MobSpawnerAdd, event.entityPlayer);
        } else if (item.func_77973_b() == CustomItems.mount) {
            mounted = event.target;
            if (isRemote) {
                CustomNpcs.proxy.openGui(MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70165_t), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70163_u), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70161_v), EnumGuiType.MobSpawnerMounter, event.entityPlayer);
            }
        } else if (item.func_77973_b() == CustomItems.wand && event.target instanceof EntityVillager) {
            event.setCanceled(true);
            Merchant = (EntityVillager)event.target;
            if (!isRemote) {
                EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.MerchantAdd.ordinal(), player.field_70170_p, 0, 0, 0);
                MerchantRecipeList merchantrecipelist = Merchant.func_70934_b((EntityPlayer)player);
                if (merchantrecipelist != null) {
                    Server.sendData(player, EnumPackets.MerchantAdd, merchantrecipelist);
                }
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingHurtEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (event.source.func_76363_c() || event.source.func_76347_k()) {
            return;
        }
        if (!player.func_70632_aY()) {
            return;
        }
        ItemStack item = player.func_71045_bC();
        if (item == null || !(item.func_77973_b() instanceof ItemShield)) {
            return;
        }
        float damage = (float)item.func_77960_j() + event.ammount;
        item.func_77972_a((int)event.ammount, (EntityLivingBase)player);
        if (damage > (float)item.func_77958_k()) {
            event.ammount = damage - (float)item.func_77958_k();
        } else {
            event.ammount = 0.0f;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Block block = player.field_70170_p.func_147439_a(event.x, event.y, event.z);
        if (block != Blocks.field_150462_ai || player.field_70170_p.field_72995_K) {
            return;
        }
        RecipeController controller = RecipeController.instance;
        NBTTagList list = new NBTTagList();
        for (RecipeCarpentry recipe : controller.globalRecipes.values()) {
            list.func_74742_a((NBTBase)recipe.writeNBT());
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("recipes", (NBTBase)list);
        Server.sendData((EntityPlayerMP)player, EnumPackets.SyncRecipes, compound);
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (event.source.func_76346_g() == null || !(event.source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        this.doExcalibur(player, event.entityLiving);
        this.doQuest(player, event.entityLiving);
        if (event.entityLiving instanceof EntityNPCInterface) {
            this.doFactionPoints(player, (EntityNPCInterface)event.entityLiving);
        }
    }

    private void doExcalibur(EntityPlayer player, EntityLivingBase entity) {
        ItemStack item = player.func_71045_bC();
        if (item == null || item.func_77973_b() != CustomItems.excalibur) {
            return;
        }
        Server.sendData((EntityPlayerMP)player, EnumPackets.PlayMusic, "customnpcs:songs.excalibur");
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("<" + StatCollector.func_74838_a((String)(item.func_77973_b().func_77658_a() + ".name")) + "> " + ItemExcalibur.quotes[player.func_70681_au().nextInt(ItemExcalibur.quotes.length)], new Object[0]));
    }

    private void doFactionPoints(EntityPlayer player, EntityNPCInterface npc) {
        npc.advanced.factions.addPoints(player);
    }

    private void doQuest(EntityPlayer player, EntityLivingBase entity) {
        PlayerQuestData playerdata = PlayerDataController.instance.getQuestData(player);
        boolean change = false;
        String entityName = EntityList.func_75621_b((Entity)entity);
        for (QuestData data : playerdata.activeQuests.values()) {
            if (data.quest.type != EnumQuestType.Kill) continue;
            String name = entityName;
            QuestKill quest = (QuestKill)data.quest.questInterface;
            if (quest.targets.containsKey(entity.func_70005_c_())) {
                name = entity.func_70005_c_();
            } else if (!quest.targets.containsKey(name)) continue;
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (killed.containsKey(name) && killed.get(name) >= quest.targets.get(name)) continue;
            int amount = 0;
            if (killed.containsKey(name)) {
                amount = killed.get(name);
            }
            killed.put(name, amount + 1);
            quest.setKilled(data, killed);
            change = true;
        }
        if (!change) {
            return;
        }
        playerdata.checkQuestCompletion(player, EnumQuestType.Kill);
        PlayerDataController.instance.savePlayerData(player, playerdata);
    }

    public void pickUp(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        PlayerQuestData playerdata = PlayerDataController.instance.getQuestData(event.entityPlayer);
        playerdata.checkQuestCompletion(event.entityPlayer, EnumQuestType.Item);
    }
}

