/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.quests.QuestLocation;

public class TileWaypoint
extends TileEntity {
    public String name = "";
    private int ticks = 10;
    private List<EntityPlayer> recentlyChecked = new ArrayList<EntityPlayer>();
    private List<EntityPlayer> toCheck;
    public int range = 10;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 10;
        this.toCheck = this.getPlayerList(this.range, this.range, this.range);
        this.toCheck.removeAll(this.recentlyChecked);
        List<EntityPlayer> listMax = this.getPlayerList(this.range + 10, this.range + 10, this.range + 10);
        this.recentlyChecked.retainAll(listMax);
        this.recentlyChecked.addAll(this.toCheck);
        if (this.toCheck.isEmpty()) {
            return;
        }
        for (EntityPlayer player : this.toCheck) {
            PlayerQuestData playerdata = PlayerDataController.instance.getQuestData(player);
            for (QuestData data : playerdata.activeQuests.values()) {
                if (data.quest.type != EnumQuestType.Location) continue;
                QuestLocation quest = (QuestLocation)data.quest.questInterface;
                quest.setFound(data, this.name);
                if (playerdata.checkQuestCompletion(player, EnumQuestType.Location)) continue;
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(this.name + " " + StatCollector.func_74838_a((String)"quest.found"), new Object[0]));
            }
        }
    }

    private List<EntityPlayer> getPlayerList(int x, int y, int z) {
        return this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)x, (double)y, (double)z));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.name = compound.func_74779_i("LocationName");
        this.range = compound.func_74762_e("LocationRange");
        if (this.range < 2) {
            this.range = 2;
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (!this.name.isEmpty()) {
            compound.func_74778_a("LocationName", this.name);
        }
        compound.func_74768_a("LocationRange", this.range);
    }
}

