/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.Client;
import noppes.npcs.client.fx.EntityEnderFX;
import noppes.npcs.client.gui.player.GuiDialogInteract;
import noppes.npcs.client.gui.player.GuiQuestCompletion;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.Quest;
import noppes.npcs.entity.EntityNpcEnderchibi;

public class NoppesUtil {
    private static EntityNPCInterface lastNpc;

    public static void requestOpenGUI(EnumGuiType gui) {
        NoppesUtil.requestOpenGUI(gui, 0, 0, 0);
    }

    public static void requestOpenGUI(EnumGuiType gui, int i, int j, int k) {
        Client.sendData(EnumPackets.Gui, gui.ordinal(), i, j, k);
    }

    public static void spawnParticle(ByteBufInputStream dis) {
        try {
            double posX = dis.readDouble();
            double posY = dis.readDouble();
            double posZ = dis.readDouble();
            float height = dis.readFloat();
            float width = dis.readFloat();
            float yOffset = dis.readFloat();
            String particle = dis.readUTF();
            WorldClient worldObj = Minecraft.func_71410_x().field_71441_e;
            Random rand = worldObj.field_73012_v;
            if (particle.equals("heal")) {
                for (int k = 0; k < 6; ++k) {
                    worldObj.func_72869_a("instantSpell", posX + (rand.nextDouble() - 0.5) * (double)width, posY + rand.nextDouble() * (double)height - (double)yOffset, posZ + (rand.nextDouble() - 0.5) * (double)width, 0.0, 0.0, 0.0);
                    worldObj.func_72869_a("spell", posX + (rand.nextDouble() - 0.5) * (double)width, posY + rand.nextDouble() * (double)height - (double)yOffset, posZ + (rand.nextDouble() - 0.5) * (double)width, 0.0, 0.0, 0.0);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static EntityNPCInterface getLastNpc() {
        return lastNpc;
    }

    public static void setLastNpc(EntityNPCInterface npc) {
        lastNpc = npc;
    }

    public static void openGUI(EntityPlayer player, Object guiscreen) {
        CustomNpcs.proxy.openGui(player, guiscreen);
    }

    public static void setScrollList(ByteBufInputStream dis) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null || !(gui instanceof IScrollData)) {
            return;
        }
        Vector<String> data = new Vector<String>();
        try {
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                data.add(dis.readUTF());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ((IScrollData)gui).setData(data, null);
    }

    public static void setScrollData(ByteBufInputStream dis) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return;
        }
        Vector<String> list = new Vector<String>();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        try {
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                int id = dis.readInt();
                String name = dis.readUTF();
                data.put(name, id);
                list.add(name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (gui instanceof GuiNPCInterface2 && ((GuiNPCInterface2)gui).hasSubGui()) {
            gui = ((GuiNPCInterface2)gui).getSubGui();
        }
        if (gui instanceof GuiContainerNPCInterface2 && ((GuiContainerNPCInterface2)gui).hasSubGui()) {
            gui = ((GuiContainerNPCInterface2)gui).getSubGui();
        }
        if (gui instanceof IScrollData) {
            ((IScrollData)gui).setData(list, data);
        }
    }

    public static void guiQuestCompletion(EntityPlayer player, NBTTagCompound read) {
        Quest quest = new Quest();
        quest.readNBT(read);
        if (!quest.completeText.equals("")) {
            NoppesUtil.openGUI(player, new GuiQuestCompletion(quest));
        } else {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestCompletion, quest.id);
        }
    }

    public static void openDialog(ByteBufInputStream dis, EntityNPCInterface npc, EntityPlayer player) throws IOException {
        if (DialogController.instance == null) {
            DialogController.instance = new DialogController();
        }
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
        Dialog dialog = new Dialog();
        dialog.readNBT(compound);
        CustomNpcs.proxy.openGui(player, (Object)new GuiDialogInteract(npc, dialog));
    }

    public static void bankData(ByteBufInputStream dis) throws IOException {
        BankController controller = BankController.getInstance();
        controller.loadBanks(dis);
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui != null) {
            gui.func_73866_w_();
        }
    }

    public static void spawnEnderchibi(EntityNpcEnderchibi chibi) {
        Random rand = chibi.field_70170_p.field_73012_v;
        EntityEnderFX fx = new EntityEnderFX(chibi, chibi.field_70165_t + (rand.nextDouble() - 0.5) * (double)chibi.field_70130_N, chibi.field_70163_u + rand.nextDouble() * (double)chibi.field_70131_O, chibi.field_70161_v + (rand.nextDouble() - 0.5) * (double)chibi.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public static void saveRedstoneBlock(EntityPlayer player, ByteBufInputStream dis) throws IOException {
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
        int x = compound.func_74762_e("x");
        int y = compound.func_74762_e("y");
        int z = compound.func_74762_e("z");
        TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
        tile.func_145839_a(compound);
        CustomNpcs.proxy.openGui(x, y, z, EnumGuiType.RedstoneBlock, player);
    }

    public static void saveWayPointBlock(EntityPlayer player, ByteBufInputStream dis) throws IOException {
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
        int x = compound.func_74762_e("x");
        int y = compound.func_74762_e("y");
        int z = compound.func_74762_e("z");
        TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
        tile.func_145839_a(compound);
        CustomNpcs.proxy.openGui(x, y, z, EnumGuiType.Waypoint, player);
    }
}

