/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.PacketHandlerServer;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.QuestAchievement;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiError;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;

public class PacketHandlerClient
extends PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBufInputStream buf = new ByteBufInputStream(event.packet.payload());
        try {
            this.client(buf, (EntityPlayer)player, EnumPackets.values()[buf.readInt()], event.packet.payload());
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void client(ByteBufInputStream dis, EntityPlayer player, EnumPackets type, ByteBuf buf) throws IOException {
        if (type == EnumPackets.Bank) {
            NoppesUtil.bankData(dis);
        } else if (type == EnumPackets.Chat) {
            String message = "";
            try {
                while (true) {
                    String str = dis.readUTF();
                    message = message + StatCollector.func_74838_a((String)str);
                }
            }
            catch (EOFException e) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            }
        } else if (type == EnumPackets.Message) {
            String description = StatCollector.func_74838_a((String)dis.readUTF());
            String message = dis.readUTF();
            QuestAchievement ach = new QuestAchievement(message, description);
            Minecraft.func_71410_x().field_71458_u.func_146256_a((Achievement)ach);
            ObfuscationReflectionHelper.setPrivateValue(GuiAchievement.class, (Object)Minecraft.func_71410_x().field_71458_u, (Object)ach.func_75989_e(), (int)4);
        } else if (type == EnumPackets.SyncRecipes) {
            NBTTagList list = CompressedStreamTools.func_74794_a((DataInput)dis).func_150295_c("recipes", 10);
            HashMap<Integer, RecipeCarpentry> recipes = new HashMap<Integer, RecipeCarpentry>();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                RecipeCarpentry recipe = new RecipeCarpentry();
                recipe.readNBT(list.func_150305_b(i));
                recipes.put(recipe.id, recipe);
            }
            RecipeController.reloadGlobalRecipes(recipes);
        } else if (type == EnumPackets.Dialog) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.openDialog(dis, (EntityNPCInterface)entity, player);
        } else if (type == EnumPackets.QuestCompletion) {
            NoppesUtil.guiQuestCompletion(player, CompressedStreamTools.func_74794_a((DataInput)dis));
        } else if (type == EnumPackets.EditingNpc) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPackets.PlayMusic) {
            MusicController.Instance.playMusic(dis.readUTF(), (Entity)player);
        } else if (type == EnumPackets.PlaySound) {
            MusicController.Instance.playSound(dis.readUTF(), dis.readFloat(), dis.readFloat(), dis.readFloat());
        } else if (type == EnumPackets.UpdateNpc) {
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            entity.func_70020_e(compound);
        } else if (type == EnumPackets.SaveRole) {
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).advanced.setRole(compound.func_74762_e("Role"));
            ((EntityNPCInterface)entity).roleInterface.readEntityFromNBT(compound);
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPackets.Gui) {
            EnumGuiType gui = EnumGuiType.values()[dis.readInt()];
            CustomNpcs.proxy.openGui(NoppesUtil.getLastNpc(), gui);
        } else if (type == EnumPackets.Particle) {
            NoppesUtil.spawnParticle(dis);
        } else if (type == EnumPackets.Delete) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).delete();
        } else if (type == EnumPackets.ScrollList) {
            NoppesUtil.setScrollList(dis);
        } else if (type == EnumPackets.ScrollData) {
            NoppesUtil.setScrollData(dis);
        } else if (type == EnumPackets.ScrollSelected) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IScrollData)) {
                return;
            }
            String selected = dis.readUTF();
            ((IScrollData)gui).setSelected(selected);
        } else if (type == EnumPackets.RedstoneBlockSave) {
            NoppesUtil.saveRedstoneBlock(player, dis);
        } else if (type == EnumPackets.WaypointSave) {
            NoppesUtil.saveWayPointBlock(player, dis);
        } else if (type == EnumPackets.GuiData) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCInterface2 && ((GuiNPCInterface2)gui).hasSubGui()) {
                gui = ((GuiNPCInterface2)gui).getSubGui();
            }
            if (gui instanceof IGuiData) {
                ((IGuiData)gui).setGuiData(CompressedStreamTools.func_74794_a((DataInput)dis));
            }
        } else if (type == EnumPackets.GuiError) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IGuiError)) {
                return;
            }
            int i = dis.readInt();
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            ((IGuiError)gui).setError(i, compound);
        } else if (type == EnumPackets.GuiClose) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            int i = dis.readInt();
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            if (gui instanceof IGuiClose) {
                ((IGuiClose)gui).setClose(i, compound);
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a(null);
            mc.func_71381_h();
        } else if (type == EnumPackets.MerchantAdd) {
            MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buf));
            ServerEventsHandler.Merchant.func_70930_a(merchantrecipelist);
        }
    }
}

