/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;

public class CloneController {
    public static Entity toClone = null;

    private static ArrayList<NBTTagCompound> loadClones() {
        try {
            File file = new File(CustomNpcs.Dir, "clonednpcs.dat");
            if (!file.exists()) {
                return new ArrayList<NBTTagCompound>();
            }
            return CloneController.loadClones(file);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            try {
                File file = new File(CustomNpcs.Dir, "clonednpcs.dat_old");
                return CloneController.loadClones(file);
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
                return new ArrayList<NBTTagCompound>();
            }
        }
    }

    private static ArrayList<NBTTagCompound> loadClones(File file) throws Exception {
        ArrayList<NBTTagCompound> clones = new ArrayList<NBTTagCompound>();
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        NBTTagList list = nbttagcompound1.func_150295_c("Data", 10);
        if (list == null) {
            return clones;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = list.func_150305_b(i);
            if (!nbttagcompound.func_74764_b("ClonedDate")) {
                nbttagcompound.func_74772_a("ClonedDate", System.currentTimeMillis());
                nbttagcompound.func_74778_a("ClonedName", nbttagcompound.func_74779_i("Name"));
            }
            clones.add(nbttagcompound);
        }
        return clones;
    }

    public static void saveClones(Collection<NBTTagCompound> clones) {
        try {
            NBTTagList list = new NBTTagList();
            for (NBTTagCompound nbt : clones) {
                list.func_74742_a((NBTBase)nbt);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("Data", (NBTBase)list);
            File file = new File(CustomNpcs.Dir, "clonednpcs.dat_new");
            File file1 = new File(CustomNpcs.Dir, "clonednpcs.dat_old");
            File file2 = new File(CustomNpcs.Dir, "clonednpcs.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static ArrayList<NBTTagCompound> getClones() {
        return CloneController.loadClones();
    }

    public static void addClone(Entity entity, String name, int tab) {
        ArrayList<NBTTagCompound> clones = CloneController.getClones();
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        entity.func_70039_c(nbttagcompound);
        nbttagcompound.func_74772_a("ClonedDate", System.currentTimeMillis());
        nbttagcompound.func_74778_a("ClonedName", name);
        nbttagcompound.func_74768_a("ClonedTab", tab);
        clones.add(nbttagcompound);
        CloneController.saveClones(clones);
    }
}

