/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.HashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.GuiNPCDialogSelection;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumOptionType;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogOption;

public class GuiNPCDialogOptions
extends GuiNPCInterface
implements ITextfieldListener,
GuiSelectionListener {
    private GuiScreen parent;
    private Dialog dialog;
    public HashMap<Integer, DialogOption> options = new HashMap();
    private int selectedSlot;

    public GuiNPCDialogOptions(EntityNPCInterface npc, GuiScreen parent, Dialog dialog) {
        super(npc);
        this.parent = parent;
        this.dialog = dialog;
        this.options = dialog.options;
        this.title = "";
        this.drawDefaultBackground = false;
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        for (i = 0; i < 6; ++i) {
            if (this.options.containsKey(i)) continue;
            this.options.put(i, new DialogOption());
        }
        for (i = 0; i < 6; ++i) {
            DialogOption option = this.options.get(i);
            int y = 6 + i % 3 * 70;
            int x = (this.field_146294_l - 420) / 4 + this.field_146294_l / 2 + 1;
            if (i > 2) {
                x -= this.field_146294_l / 2;
            }
            this.addButton(new GuiNpcButton(i, x, y, 92, 20, new String[]{"dialog.quitoption", "dialog.option", " gui.disabled", "dialog.roleoption", "dialogcommandoption"}, option.optionType.ordinal()));
            this.addTextField(new GuiNpcTextField(i, this, this.field_146289_q, x + 2, y + 22, 196, 20, option.title));
            this.addButton(new GuiNpcButton(i + 6, x, y + 44, 196, 20, "dialog.selectoption"));
            String color = Integer.toHexString(option.optionColor);
            while (color.length() < 6) {
                color = 0 + color;
            }
            this.addLabel(new GuiNpcLabel(i, "gui.color", x + 98, y + 4, 0xFFFFFF));
            this.addTextField(new GuiNpcTextField(i + 6, this, this.field_146289_q, x + 130, y, 45, 20, color));
            this.addTextField(new GuiNpcTextField(i + 12, this, this.field_146289_q, x + 2, y + 44, 196, 20, option.command));
            this.getTextField((int)(i + 12)).enabled = option.optionType == EnumOptionType.CommandBlock;
            this.getButton(i + 6).setEnabled(option.optionType == EnumOptionType.DialogOption);
            this.getButton(i + 6).setVisible(option.optionType == EnumOptionType.DialogOption);
            this.getTextField((int)i).enabled = option.optionType != EnumOptionType.Disabled;
            this.getTextField((int)(i + 6)).enabled = option.optionType != EnumOptionType.Disabled;
            this.getLabel((int)i).enabled = option.optionType != EnumOptionType.Disabled;
        }
        this.addButton(new GuiNpcButton(66, this.field_146294_l / 2 - 49, 215, 98, 20, "gui.back"));
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        this.func_146276_q_();
        this.func_73728_b(this.field_146294_l / 2, 0, this.field_146295_m, -1);
        this.func_73730_a(0, this.field_146294_l, 74, -1);
        this.func_73730_a(0, this.field_146294_l, 144, -1);
        super.func_73863_a(i, j, f);
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        DialogOption option;
        GuiNpcButton button = (GuiNpcButton)guibutton;
        if (button.field_146127_k >= 0 && button.field_146127_k < 6) {
            option = this.options.get(button.field_146127_k);
            option.optionType = EnumOptionType.values()[button.getValue()];
            this.func_73866_w_();
        }
        if (button.field_146127_k >= 6 && button.field_146127_k < 12) {
            this.save();
            this.selectedSlot = button.field_146127_k - 6;
            option = this.options.get(this.selectedSlot);
            int id = -1;
            if (option != null) {
                id = option.dialogId;
            }
            NoppesUtil.openGUI(this.player, new GuiNPCDialogSelection(this.npc, this, id));
        }
        if (button.field_146127_k == 66) {
            this.save();
            NoppesUtil.openGUI(this.player, this.parent);
        }
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
        DialogOption option;
        if (textfield.id >= 0 && textfield.id < 6) {
            option = this.options.get(textfield.id);
            if (textfield.isEmpty()) {
                option.optionType = EnumOptionType.Disabled;
                this.func_73866_w_();
            } else {
                option.title = textfield.func_146179_b();
            }
        }
        if (textfield.id >= 6 && textfield.id < 12) {
            option = this.options.get(textfield.id - 6);
            int color = 0xE0E0E0;
            try {
                color = Integer.parseInt(textfield.func_146179_b(), 16);
            }
            catch (NumberFormatException e) {
                color = 0xE0E0E0;
            }
            option.optionColor = color;
            String colors = Integer.toHexString(option.optionColor);
            while (colors.length() < 6) {
                colors = 0 + colors;
            }
            textfield.func_146180_a(colors);
        }
        if (textfield.id >= 12 && textfield.id < 18) {
            option = this.options.get(textfield.id - 12);
            option.command = textfield.func_146179_b();
        }
    }

    @Override
    public void save() {
        this.dialog.options = this.options;
    }

    @Override
    public void selected(int id, String name) {
        if (!this.options.containsKey(this.selectedSlot)) {
            this.options.put(this.selectedSlot, new DialogOption());
        }
        DialogOption option = this.options.get(this.selectedSlot);
        option.dialogId = id;
    }
}

