/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import noppes.npcs.client.Client;
import noppes.npcs.client.controllers.CloneController;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.constants.EnumPackets;

public class GuiNpcMobSpawner
extends GuiNPCInterface {
    private GuiCustomScroll scroll;
    private int posX;
    private int posY;
    private int posZ;
    private HashMap<String, NBTTagCompound> cloneData = new HashMap();
    private List<NBTTagCompound> data = new ArrayList<NBTTagCompound>();
    private ArrayList<String> list;
    private static boolean showingClones = true;
    private static String search = "";
    private int activeTab = 1;

    public GuiNpcMobSpawner(int i, int j, int k) {
        this.xSize = 256;
        this.posX = i;
        this.posY = j;
        this.posZ = k;
        this.closeOnEsc = true;
        this.setBackground("menubg.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop += 10;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(165, 188);
            this.scroll.guiLeft = this.guiLeft + 4;
            this.scroll.guiTop = this.guiTop + 26;
        } else {
            this.scroll.clear();
        }
        this.addScroll(this.scroll, this.field_146297_k);
        this.addTextField(new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 4, this.guiTop + 4, 165, 20, search));
        GuiMenuTopButton button = new GuiMenuTopButton(3, this.guiLeft + 4, this.guiTop - 17, "spawner.clones");
        this.addTopButton(button);
        button.active = showingClones;
        button = new GuiMenuTopButton(4, button, "spawner.entities");
        this.addTopButton(button);
        button.active = !showingClones;
        this.addButton(new GuiNpcButton(1, this.guiLeft + 170, this.guiTop + 6, 82, 20, "item.monsterPlacer.name"));
        this.addButton(new GuiNpcButton(2, this.guiLeft + 170, this.guiTop + 100, 82, 20, "spawner.mobspawner"));
        if (showingClones) {
            this.addSideButton(new GuiMenuSideButton(21, this.guiLeft - 69, this.guiTop + 2, 70, 22, "Tab 1"));
            this.addSideButton(new GuiMenuSideButton(22, this.guiLeft - 69, this.guiTop + 23, 70, 22, "Tab 2"));
            this.addSideButton(new GuiMenuSideButton(23, this.guiLeft - 69, this.guiTop + 44, 70, 22, "Tab 3"));
            this.addSideButton(new GuiMenuSideButton(24, this.guiLeft - 69, this.guiTop + 65, 70, 22, "Tab 4"));
            this.addSideButton(new GuiMenuSideButton(25, this.guiLeft - 69, this.guiTop + 86, 70, 22, "Tab 5"));
            this.addSideButton(new GuiMenuSideButton(26, this.guiLeft - 69, this.guiTop + 107, 70, 22, "Tab 6"));
            this.addSideButton(new GuiMenuSideButton(27, this.guiLeft - 69, this.guiTop + 128, 70, 22, "Tab 7"));
            this.addSideButton(new GuiMenuSideButton(28, this.guiLeft - 69, this.guiTop + 149, 70, 22, "Tab 8"));
            this.addSideButton(new GuiMenuSideButton(29, this.guiLeft - 69, this.guiTop + 170, 70, 22, "Tab 9"));
            this.getSideButton((int)(20 + this.activeTab)).active = true;
            this.showClones();
        } else {
            this.showEntities();
        }
    }

    private void showEntities() {
        Map data = EntityList.field_75625_b;
        ArrayList<String> list = new ArrayList<String>();
        for (Object name : data.keySet()) {
            Class c = (Class)data.get(name);
            try {
                if (!EntityLiving.class.isAssignableFrom(c) || c.getConstructor(World.class) == null || Modifier.isAbstract(c.getModifiers())) continue;
                list.add(name.toString());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {}
        }
        this.list = list;
        this.scroll.setList(this.getSearchList());
    }

    private void showClones() {
        this.addButton(new GuiNpcButton(5, this.guiLeft + 170, this.guiTop + 30, 82, 20, "gui.remove"));
        this.cloneData.clear();
        ArrayList<String> list = new ArrayList<String>();
        this.data = CloneController.getClones();
        for (NBTTagCompound comp : CloneController.getClones()) {
            String name = comp.func_74779_i("ClonedName");
            int i = 1;
            while (list.contains(name)) {
                name = String.format("%s%s", comp.func_74779_i("ClonedName"), ++i);
            }
            int tab = 1;
            if (comp.func_74764_b("ClonedTab")) {
                tab = comp.func_74762_e("ClonedTab");
            }
            if (this.activeTab != tab) continue;
            list.add(name);
            this.cloneData.put(name, comp);
        }
        this.list = list;
        this.scroll.setList(this.getSearchList());
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (search.equals(this.getTextField(1).func_146179_b())) {
            return;
        }
        search = this.getTextField(1).func_146179_b().toLowerCase();
        this.scroll.setList(this.getSearchList());
    }

    private List<String> getSearchList() {
        if (search.isEmpty()) {
            return new ArrayList<String>(this.list);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.list) {
            if (!name.toLowerCase().contains(search)) continue;
            list.add(name);
        }
        return list;
    }

    private NBTTagCompound getCompound() {
        String sel = this.scroll.getSelected();
        if (sel == null) {
            return null;
        }
        if (showingClones) {
            NBTTagCompound compound = this.cloneData.get(sel);
            compound.func_82580_o("StartPos");
            compound.func_82580_o("Pos");
            return compound;
        }
        Entity entity = EntityList.func_75620_a((String)sel, (World)Minecraft.func_71410_x().field_71441_e);
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_70039_c(compound);
        return compound;
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        NBTTagCompound compound;
        int id = guibutton.field_146127_k;
        if (id == 0) {
            this.close();
        }
        if (id == 1 && (compound = this.getCompound()) != null) {
            compound.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList((double)this.posX + 0.5, this.posY + 1, (double)this.posZ + 0.5));
            compound.func_74768_a("ItemGiverId", 0);
            compound.func_74768_a("TransporterId", -1);
            Client.sendData(EnumPackets.SpawnMob, compound);
            this.close();
        }
        if (id == 2 && (compound = this.getCompound()) != null) {
            Client.sendData(EnumPackets.MobSpawner, this.posX, this.posY, this.posZ, compound);
            this.close();
        }
        if (id == 3) {
            showingClones = true;
            this.func_73866_w_();
        }
        if (id == 4) {
            showingClones = false;
            this.func_73866_w_();
        }
        if (id == 5 && this.scroll.getSelected() != null) {
            NBTTagCompound toCheck = this.cloneData.get(this.scroll.getSelected());
            this.data.remove(toCheck);
            CloneController.saveClones(this.data);
            this.scroll.selected = -1;
            this.func_73866_w_();
        }
        if (id > 20) {
            this.activeTab = id - 20;
            this.func_73866_w_();
        }
    }

    protected NBTTagList newDoubleNBTList(double ... par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble = par1ArrayOfDouble;
        int i = par1ArrayOfDouble.length;
        for (int j = 0; j < i; ++j) {
            double d1 = adouble[j];
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    @Override
    public void save() {
    }
}

