/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.gui.util.GuiButtonNextPage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMailmanWrite
extends GuiScreen {
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private final NBTTagCompound itemstackBook;
    private int updateCount;
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private NBTTagList bookPages;
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private boolean canEdit;
    private GuiScreen parent;
    private Minecraft mc = Minecraft.func_71410_x();

    public GuiMailmanWrite(GuiScreen parent, NBTTagCompound compound, boolean canEdit) {
        this.parent = parent;
        this.itemstackBook = compound;
        this.canEdit = canEdit;
        if (this.itemstackBook.func_74764_b("pages")) {
            this.bookPages = this.itemstackBook.func_150295_c("pages", 8);
        }
        if (this.bookPages != null) {
            this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
            this.bookTotalPages = this.bookPages.func_74745_c();
            if (this.bookTotalPages < 1) {
                this.bookTotalPages = 1;
            }
        } else {
            this.bookPages = new NBTTagList();
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            this.bookTotalPages = 1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButton(0, this.getWidth() / 2 - 100, 4 + this.bookImageHeight, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        int i = (this.getWidth() - this.bookImageWidth) / 2;
        int b0 = 2;
        this.buttonNextPage = new GuiButtonNextPage(1, i + 120, b0 + 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonNextPage(2, i + 38, b0 + 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonNextPage.setVisible(this.currPage < this.bookTotalPages - 1 || this.canEdit);
        this.buttonPreviousPage.setVisible(this.currPage > 0);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            int id = par1GuiButton.field_146127_k;
            if (id == 0) {
                this.close();
            } else if (id == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                } else if (this.canEdit) {
                    this.addNewPage();
                    if (this.currPage < this.bookTotalPages - 1) {
                        ++this.currPage;
                    }
                }
            } else if (id == 2 && this.currPage > 0) {
                --this.currPage;
            }
            this.updateButtons();
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.func_74745_c() < 50) {
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            ++this.bookTotalPages;
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.close();
        }
        if (this.canEdit) {
            this.keyTypedInBook(par1, par2);
        }
    }

    private void keyTypedInBook(char par1, int par2) {
        switch (par1) {
            case '\u0016': {
                this.func_74160_b(GuiScreen.func_146277_j());
                return;
            }
        }
        switch (par2) {
            case 14: {
                String s = this.func_74158_i();
                if (s.length() > 0) {
                    this.func_74159_a(s.substring(0, s.length() - 1));
                }
                return;
            }
            case 28: 
            case 156: {
                this.func_74160_b("\n");
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)par1)) {
            this.func_74160_b(Character.toString(par1));
        }
    }

    private String func_74158_i() {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
            return this.bookPages.func_150307_f(this.currPage);
        }
        return "";
    }

    private void func_74159_a(String par1Str) {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
            this.bookPages.func_150304_a(this.currPage, (NBTBase)new NBTTagString(par1Str));
        }
    }

    private void func_74160_b(String par1Str) {
        String s1 = this.func_74158_i();
        String s2 = s1 + par1Str;
        int i = this.mc.field_71466_p.func_78267_b(s2 + "" + EnumChatFormatting.BLACK + "_", 118);
        if (i <= 118 && s2.length() < 256) {
            this.func_74159_a(s2);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(bookGuiTextures);
        int k = (this.getWidth() - this.bookImageWidth) / 2;
        int b0 = 2;
        this.func_73729_b(k, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
        String s = String.format(I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[0]), this.currPage + 1, this.bookTotalPages);
        String s1 = "";
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
            s1 = this.bookPages.func_150307_f(this.currPage);
        }
        if (this.canEdit) {
            s1 = this.mc.field_71466_p.func_78260_a() ? s1 + "_" : (this.updateCount / 6 % 2 == 0 ? s1 + "" + EnumChatFormatting.BLACK + "_" : s1 + "" + EnumChatFormatting.GRAY + "_");
        }
        int l = this.mc.field_71466_p.func_78256_a(s);
        this.mc.field_71466_p.func_78276_b(s, k - l + this.bookImageWidth - 44, b0 + 16, 0);
        this.mc.field_71466_p.func_78279_b(s1, k + 36, b0 + 16 + 16, 116, 0);
        super.func_73863_a(par1, par2, par3);
    }

    public void close() {
        this.itemstackBook.func_74782_a("pages", (NBTBase)this.bookPages);
        this.mc.func_147108_a(this.parent);
    }

    static ResourceLocation func_110404_g() {
        return bookGuiTextures;
    }

    private int getWidth() {
        return this.field_146294_l;
    }
}

