/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ITopButtonListener;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.Quest;
import org.lwjgl.opengl.GL11;

public class GuiQuestCompletion
extends GuiNPCInterface
implements ITopButtonListener {
    private int xSize = 176;
    private int ySize = 222;
    private int guiLeft;
    private int guiTop;
    private Quest quest;
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/smallbg.png");

    public GuiQuestCompletion(Quest quest) {
        this.quest = quest;
        this.drawDefaultBackground = false;
        this.title = "";
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.addButton(new GuiNpcButton(0, this.guiLeft + 38, this.guiTop + this.ySize - 24, 100, 20, StatCollector.func_74838_a((String)"quest.complete")));
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.resource);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        String questTitle = this.quest.title;
        int left = (this.xSize - this.field_146289_q.func_78256_a(questTitle)) / 2;
        this.addLabel(new GuiNpcLabel(0, questTitle, this.guiLeft + left, this.guiTop + 5, 0x404040));
        this.drawQuestText();
        super.func_73863_a(i, j, f);
    }

    private void drawQuestText() {
        int x = 0;
        int yoffset = this.guiTop + 20;
        int xoffset = this.guiLeft + 4;
        String text = NoppesStringUtils.formatText(this.quest.completeText, this.player.func_70005_c_());
        String line = "";
        for (char c : text.toCharArray()) {
            if (c == '\r' || c == '\n') {
                this.field_146289_q.func_78276_b(line, xoffset, yoffset + x * this.field_146289_q.field_78288_b, 0x404040);
                line = "";
                ++x;
                continue;
            }
            if (this.field_146289_q.func_78256_a(line + c) > 176) {
                this.field_146289_q.func_78276_b(line, xoffset, yoffset + x * this.field_146289_q.field_78288_b, 0x404040);
                line = "";
                ++x;
            }
            line = line + c;
        }
        this.field_146289_q.func_78276_b(line, xoffset, yoffset + x * this.field_146289_q.field_78288_b, 0x404040);
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestCompletion, this.quest.id);
            this.close();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
    }

    @Override
    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 || this.isInventoryKey(i)) {
            this.close();
        }
    }

    @Override
    public void save() {
    }
}

