/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiNPCInterface
extends GuiScreen {
    public EntityPlayer player;
    public boolean drawDefaultBackground = true;
    public EntityNPCInterface npc;
    private HashMap<Integer, GuiNpcButton> buttons = new HashMap();
    private HashMap<Integer, GuiMenuTopButton> topbuttons = new HashMap();
    private HashMap<Integer, GuiMenuSideButton> sidebuttons = new HashMap();
    private HashMap<Integer, GuiNpcTextField> textfields = new HashMap();
    private HashMap<Integer, GuiNpcLabel> labels = new HashMap();
    private HashMap<Integer, GuiCustomScroll> scrolls = new HashMap();
    private HashMap<Integer, GuiNpcSlider> sliders = new HashMap();
    public String title;
    private ResourceLocation background = null;
    public boolean closeOnEsc = false;
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;

    public GuiNPCInterface(EntityNPCInterface npc) {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.npc = npc;
        this.title = "";
        this.xSize = 200;
        this.ySize = 222;
    }

    public GuiNPCInterface() {
        this(null);
    }

    public void setBackground(String texture) {
        this.background = new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.labels.clear();
        this.textfields.clear();
        this.buttons.clear();
        this.sidebuttons.clear();
        this.topbuttons.clear();
        this.scrolls.clear();
        this.sliders.clear();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73876_c() {
        for (GuiNpcTextField tf : this.textfields.values()) {
            if (!tf.enabled) continue;
            tf.func_146178_a();
        }
        super.func_73876_c();
    }

    public void func_73864_a(int i, int j, int k) {
        for (GuiNpcTextField tf : this.textfields.values().toArray(new GuiNpcTextField[this.textfields.size()])) {
            if (!tf.enabled) continue;
            tf.func_146192_a(i, j, k);
        }
        if (k == 0) {
            for (GuiCustomScroll scroll : this.scrolls.values()) {
                scroll.func_73864_a(i, j, k);
            }
        }
        super.func_73864_a(i, j, k);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        this.buttonEvent(par1GuiButton);
    }

    public void buttonEvent(GuiButton guibutton) {
    }

    public void func_73869_a(char c, int i) {
        for (GuiNpcTextField tf : this.textfields.values()) {
            tf.func_146201_a(c, i);
        }
        if (this.closeOnEsc && i == 1) {
            this.close();
        }
    }

    public void close() {
        this.displayGuiScreen(null);
        this.field_146297_k.func_71381_h();
        this.save();
    }

    public void addButton(int i, GuiNpcButton button) {
        this.buttons.put(i, button);
        this.field_146292_n.add(button);
    }

    public void addButton(GuiNpcButton button) {
        this.buttons.put(button.field_146127_k, button);
        this.field_146292_n.add(button);
    }

    public void addTopButton(GuiMenuTopButton button) {
        this.topbuttons.put(button.field_146127_k, button);
        this.field_146292_n.add(button);
    }

    public void addSideButton(GuiMenuSideButton button) {
        this.sidebuttons.put(button.field_146127_k, button);
        this.field_146292_n.add(button);
    }

    public GuiNpcButton getButton(int i) {
        return this.buttons.get(i);
    }

    public GuiMenuSideButton getSideButton(int i) {
        return this.sidebuttons.get(i);
    }

    public void addTextField(int i, GuiNpcTextField tf) {
        this.textfields.put(i, tf);
    }

    public void addTextField(GuiNpcTextField tf) {
        this.textfields.put(tf.id, tf);
    }

    public GuiNpcTextField getTextField(int i) {
        return this.textfields.get(i);
    }

    public void addLabel(GuiNpcLabel label) {
        this.labels.put(label.id, label);
    }

    public GuiNpcLabel getLabel(int i) {
        return this.labels.get(i);
    }

    public void addScroll(GuiCustomScroll scroll, Minecraft mc) {
        scroll.func_146280_a(mc, 350, 250);
        this.scrolls.put(scroll.id, scroll);
    }

    public void addSlider(GuiNpcSlider slider) {
        this.sliders.put(slider.field_146127_k, slider);
        this.field_146292_n.add(slider);
    }

    public GuiNpcSlider getSlider(int i) {
        return this.sliders.get(i);
    }

    public GuiCustomScroll getScroll(int id) {
        return this.scrolls.get(id);
    }

    public abstract void save();

    public void func_73863_a(int i, int j, float f) {
        if (this.drawDefaultBackground) {
            this.func_146276_q_();
        }
        if (this.background != null && this.field_146297_k.field_71446_o != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.background);
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 10, 0xFFFFFF);
        for (GuiNpcLabel label : this.labels.values()) {
            label.drawLabel(this, this.field_146289_q);
        }
        for (GuiNpcTextField tf : this.textfields.values()) {
            tf.func_146194_f();
        }
        for (GuiCustomScroll scroll : this.scrolls.values()) {
            scroll.func_73863_a(i, j, f);
        }
        super.func_73863_a(i, j, f);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean drawSlot(int i, int j, int k, int l, Tessellator tessellator, String drawString) {
        return false;
    }

    public void elementClicked() {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void doubleClicked() {
    }

    public boolean isInventoryKey(int i) {
        return i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
    }

    public void func_146276_q_() {
        super.func_146276_q_();
    }

    public void displayGuiScreen(GuiScreen gui) {
        this.field_146297_k.func_147108_a(gui);
    }
}

