/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.util.StatCollector;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPackets;
import org.lwjgl.input.Keyboard;

public class GuiNpcMenu {
    private GuiScreen parent;
    private HashMap<Integer, GuiNpcButton> buttons = new HashMap();
    private HashMap<Integer, GuiNpcSlider> sliders = new HashMap();
    private HashMap<Integer, GuiNpcTextField> textfields = new HashMap();
    private HashMap<Integer, GuiNpcLabel> labels = new HashMap();
    private HashMap<Integer, GuiCustomScroll> scrolls = new HashMap();
    private GuiMenuTopButton[] topButtons;
    private int activeMenu;
    private EntityNPCInterface npc;

    public GuiNpcMenu(GuiScreen parent, int activeMenu, EntityNPCInterface npc) {
        this.parent = parent;
        this.activeMenu = activeMenu;
        this.npc = npc;
    }

    public void initGui(int guiLeft, int guiTop, int width) {
        this.labels.clear();
        this.textfields.clear();
        this.buttons.clear();
        this.sliders.clear();
        this.scrolls.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        GuiMenuTopButton display = new GuiMenuTopButton(1, guiLeft + 4, guiTop - 17, "menu.display");
        GuiMenuTopButton stats = new GuiMenuTopButton(2, display.field_146128_h + display.getWidth(), guiTop - 17, "menu.stats");
        GuiMenuTopButton ai = new GuiMenuTopButton(6, stats.field_146128_h + stats.getWidth(), guiTop - 17, "menu.ai");
        GuiMenuTopButton inv = new GuiMenuTopButton(3, ai.field_146128_h + ai.getWidth(), guiTop - 17, "menu.inventory");
        GuiMenuTopButton advanced = new GuiMenuTopButton(4, inv.field_146128_h + inv.getWidth(), guiTop - 17, "menu.advanced");
        GuiMenuTopButton global = new GuiMenuTopButton(5, advanced.field_146128_h + advanced.getWidth(), guiTop - 17, "menu.global");
        GuiMenuTopButton close = new GuiMenuTopButton(0, guiLeft + width - 22, guiTop - 17, "X");
        GuiMenuTopButton delete = new GuiMenuTopButton(66, guiLeft + width - 72, guiTop - 17, "selectWorld.deleteButton");
        delete.field_146128_h = close.field_146128_h - delete.getWidth();
        for (GuiMenuTopButton button : this.topButtons = new GuiMenuTopButton[]{display, stats, ai, inv, advanced, global, close, delete}) {
            button.active = button.field_146127_k == this.activeMenu;
        }
    }

    private void topButtonPressed(GuiMenuTopButton button) {
        if (button.field_146126_j.equals(this.activeMenu)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GuiHelper.clickSound();
        int id = button.field_146127_k;
        if (id == 0) {
            this.close();
            return;
        }
        if (id == 66) {
            GuiYesNo guiyesno = new GuiYesNo(this.parent, "Confirm", StatCollector.func_74838_a((String)"gui.delete"), 0);
            mc.func_147108_a((GuiScreen)guiyesno);
            return;
        }
        this.save();
        if (id == 1) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuDisplay);
        } else if (id == 2) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuStats);
        } else if (id == 3) {
            NoppesUtil.requestOpenGUI(EnumGuiType.MainMenuInv);
        } else if (id == 4) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        } else if (id == 5) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
        } else if (id == 6) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAI);
        }
        this.activeMenu = id;
    }

    private void save() {
        GuiNpcTextField.unfocus();
        if (this.parent instanceof GuiContainerNPCInterface2) {
            ((GuiContainerNPCInterface2)this.parent).save();
        }
        if (this.parent instanceof GuiNPCInterface2) {
            ((GuiNPCInterface2)this.parent).save();
        }
    }

    private void close() {
        if (this.parent instanceof GuiContainerNPCInterface2) {
            ((GuiContainerNPCInterface2)this.parent).close();
        }
        if (this.parent instanceof GuiNPCInterface2) {
            ((GuiNPCInterface2)this.parent).close();
        }
        if (this.npc != null) {
            this.npc.reset();
            Client.sendData(EnumPackets.RemoteReset, this.npc.func_145782_y());
        }
    }

    public void updateScreen() {
        for (GuiNpcTextField tf : this.textfields.values()) {
            if (!tf.enabled) continue;
            tf.func_146178_a();
        }
    }

    public void mouseClicked(int i, int j, int k) {
        for (GuiNpcTextField tf : this.textfields.values()) {
            if (!tf.enabled) continue;
            tf.func_146192_a(i, j, k);
        }
        if (k == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            for (GuiMenuTopButton button : this.topButtons) {
                if (!button.func_146116_c(mc, i, j)) continue;
                this.topButtonPressed(button);
            }
            for (GuiCustomScroll scroll : this.scrolls.values()) {
                scroll.func_73864_a(i, j, k);
            }
        }
    }

    public void keyTyped(char c, int i) {
        for (GuiNpcTextField tf : this.textfields.values()) {
            tf.func_146201_a(c, i);
        }
        if (i == 1) {
            this.close();
        }
    }

    public void addButton(GuiNpcButton button) {
        this.buttons.put(button.field_146127_k, button);
    }

    public GuiNpcButton getButton(int i) {
        return this.buttons.get(i);
    }

    public void addSlider(GuiNpcSlider slider) {
        this.sliders.put(slider.field_146127_k, slider);
    }

    public GuiNpcSlider getSlider(int i) {
        return this.sliders.get(i);
    }

    public void addTextField(GuiNpcTextField tf) {
        this.textfields.put(tf.id, tf);
    }

    public GuiNpcTextField getTextField(int i) {
        return this.textfields.get(i);
    }

    public void addLabel(GuiNpcLabel label) {
        this.labels.put(label.id, label);
    }

    public GuiNpcLabel getLabel(int i) {
        return this.labels.get(i);
    }

    public void addScroll(GuiCustomScroll scroll, Minecraft mc) {
        scroll.func_146280_a(mc, 350, 250);
        this.scrolls.put(scroll.id, scroll);
    }

    public void drawElements(FontRenderer fontRenderer, int i, int j, Minecraft mc, float f) {
        for (GuiNpcLabel label : this.labels.values()) {
            label.drawLabel(this.parent, fontRenderer);
        }
        for (GuiNpcTextField tf : this.textfields.values()) {
            tf.func_146194_f();
        }
        for (GuiMenuTopButton button : this.topButtons) {
            button.func_146112_a(mc, i, j);
        }
        for (GuiCustomScroll scroll : this.scrolls.values()) {
            scroll.func_73863_a(i, j, f);
        }
    }

    public void clearAllTextFields() {
        for (GuiNpcTextField textfield : this.textfields.values()) {
            textfield.func_146180_a("0");
        }
    }
}

