/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.IPlayerData;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerFactionData;
import noppes.npcs.controllers.PlayerItemGiverData;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.controllers.PlayerMailData;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.PlayerTransportData;
import org.apache.commons.lang3.RandomStringUtils;

public class PlayerDataController {
    private static final String id = RandomStringUtils.random((int)12, (boolean)true, (boolean)true);
    public static PlayerDataController instance;

    public PlayerDataController() {
        instance = this;
    }

    public File getSaveDir() {
        try {
            File file = new File(CustomNpcs.getWorldSaveDirectory(), "playerdata");
            if (!file.exists()) {
                file.mkdir();
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public NBTTagCompound loadPlayerData(String player) {
        File saveDir = this.getSaveDir();
        String filename = player;
        if (filename.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".dat";
        try {
            File file = new File(saveDir, filename);
            if (!file.exists()) {
                return new NBTTagCompound();
            }
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            try {
                File file = new File(saveDir, filename + "_old");
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
                return new NBTTagCompound();
            }
        }
    }

    public void savePlayerData(EntityPlayer player, IPlayerData data) {
        this.savePlayerData(player.func_70005_c_(), data.writeNBT(this.getData(player)));
    }

    public void savePlayerData(String username, NBTTagCompound compound) {
        String filename = username;
        if (filename.isEmpty()) {
            filename = "noplayername";
        } else {
            EntityPlayer player = MinecraftServer.func_71276_C().field_71305_c[0].func_72924_a(username);
            if (player != null) {
                player.getEntityData().func_74778_a("CustomNpcsId", id);
                player.getEntityData().func_74782_a("CustomNpcsData", (NBTBase)compound);
            }
        }
        filename = filename + ".dat";
        try {
            File saveDir = this.getSaveDir();
            File file = new File(saveDir, filename + "_new");
            File file1 = new File(saveDir, filename + "_old");
            File file2 = new File(saveDir, filename);
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public PlayerBankData getBankData(EntityPlayer player) {
        PlayerBankData data = new PlayerBankData();
        data.readNBT(this.getData(player));
        return data;
    }

    public PlayerBankData getBankData(EntityPlayer player, int bankId) {
        Bank bank = BankController.getInstance().getBank(bankId);
        PlayerBankData data = this.getBankData(player);
        if (!data.hasBank(bank.id)) {
            data.loadNew(bank.id);
            this.savePlayerData(player, data);
        }
        return data;
    }

    public PlayerDialogData getDialogData(EntityPlayer player) {
        PlayerDialogData data = new PlayerDialogData();
        data.readNBT(this.getData(player));
        return data;
    }

    public PlayerQuestData getQuestData(EntityPlayer player) {
        PlayerQuestData data = new PlayerQuestData();
        data.readNBT(this.getData(player));
        return data;
    }

    public PlayerTransportData getTransportData(EntityPlayer player) {
        PlayerTransportData data = new PlayerTransportData();
        data.readNBT(this.getData(player));
        return data;
    }

    public PlayerItemGiverData getItemGiverData(EntityPlayer player) {
        PlayerItemGiverData data = new PlayerItemGiverData();
        data.readNBT(this.getData(player));
        return data;
    }

    public void setDialogRead(int dialog, EntityPlayer player) {
        PlayerDialogData data = this.getDialogData(player);
        if (!data.dialogsRead.contains(dialog)) {
            data.dialogsRead.add(dialog);
            this.savePlayerData(player, data);
        }
    }

    public boolean hasDialogBeenRead(int dialog, EntityPlayer player) {
        PlayerDialogData data = this.getDialogData(player);
        return data.dialogsRead.contains(dialog);
    }

    public void addTransport(int transportId, EntityPlayer player) {
        PlayerTransportData data = this.getTransportData(player);
        data.transports.add(transportId);
        this.savePlayerData(player, data);
    }

    public PlayerFactionData getFactionData(EntityPlayer player) {
        PlayerFactionData data = new PlayerFactionData();
        data.readNBT(this.getData(player));
        return data;
    }

    private NBTTagCompound getData(EntityPlayer player) {
        NBTTagCompound compound = player.getEntityData();
        if (compound.func_74779_i("CustomNpcsId").equals(id) && compound.func_74779_i("CustomNpcsUsername").equals(player.func_70005_c_())) {
            return compound.func_74775_l("CustomNpcsData");
        }
        compound.func_74778_a("CustomNpcsId", id);
        compound.func_74778_a("CustomNpcsUsername", player.func_70005_c_());
        compound.func_74782_a("CustomNpcsData", (NBTBase)this.loadPlayerData(player.func_70005_c_()));
        return compound;
    }

    public String hasPlayer(String username) {
        for (String file : this.getSaveDir().list()) {
            if (!file.equalsIgnoreCase(username + ".dat")) continue;
            return file.substring(0, file.length() - 4);
        }
        return "";
    }

    public void addPlayerMessage(String username, PlayerMail mail) {
        mail.time = System.currentTimeMillis();
        PlayerData data = new PlayerData(this.loadPlayerData(username));
        data.mailData.playermail.add(mail);
        this.savePlayerData(username, data.getNBT());
    }

    public boolean hasMail(EntityPlayer player) {
        return this.getMailData(player).hasMail();
    }

    public PlayerMailData getMailData(EntityPlayer player) {
        PlayerMailData data = new PlayerMailData();
        data.readNBT(this.getData(player));
        return data;
    }
}

