/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.constants.EnumQuestRepeat;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.quests.QuestDialog;

public class PlayerQuestController {
    public static boolean hasActiveQuests(EntityPlayer player) {
        PlayerQuestData data = PlayerDataController.instance.getQuestData(player);
        return !data.activeQuests.isEmpty();
    }

    public static boolean isQuestActive(EntityPlayer player, int quest) {
        PlayerQuestData data = PlayerDataController.instance.getQuestData(player);
        return data.activeQuests.containsKey(quest);
    }

    public static boolean isQuestFinished(EntityPlayer player, int questid) {
        PlayerQuestData data = PlayerDataController.instance.getQuestData(player);
        return data.finishedQuests.containsKey(questid);
    }

    public static void addActiveQuest(Quest quest, EntityPlayer player) {
        PlayerQuestData data = PlayerDataController.instance.getQuestData(player);
        if (PlayerQuestController.canQuestBeAccepted(quest, player)) {
            data.activeQuests.put(quest.id, new QuestData(quest));
            Server.sendData((EntityPlayerMP)player, EnumPackets.Message, "quest.newquest", quest.title);
            Server.sendData((EntityPlayerMP)player, EnumPackets.Chat, "quest.newquest", ": ", quest.title);
            PlayerDataController.instance.savePlayerData(player, data);
        }
    }

    public static void setQuestFinished(Quest quest, EntityPlayer player) {
        PlayerQuestData data = PlayerDataController.instance.getQuestData(player);
        data.activeQuests.remove(quest.id);
        data.finishedQuests.put(quest.id, player.field_70170_p.func_72820_D());
        if (quest.repeat != EnumQuestRepeat.None && quest.type == EnumQuestType.Dialog) {
            QuestDialog questdialog = (QuestDialog)quest.questInterface;
            PlayerDialogData dialogdata = PlayerDataController.instance.getDialogData(player);
            for (int dialog : questdialog.dialogs.values()) {
                dialogdata.dialogsRead.remove(dialog);
            }
        }
        PlayerDataController.instance.savePlayerData(player, data);
    }

    public static boolean canQuestBeAccepted(Quest quest, EntityPlayer player) {
        if (quest == null) {
            return false;
        }
        PlayerQuestData data = PlayerDataController.instance.getQuestData(player);
        if (data.activeQuests.containsKey(quest.id)) {
            return false;
        }
        if (!data.finishedQuests.containsKey(quest.id) || quest.repeat == EnumQuestRepeat.Repeatable) {
            return true;
        }
        if (quest.repeat == EnumQuestRepeat.None) {
            return false;
        }
        long questTime = data.finishedQuests.get(quest.id);
        long worldTime = player.field_70170_p.func_72820_D();
        if (worldTime < questTime) {
            return true;
        }
        long timePassed = worldTime - questTime;
        if (quest.repeat == EnumQuestRepeat.Daily) {
            return timePassed >= 24000L;
        }
        if (quest.repeat == EnumQuestRepeat.Weekly) {
            return timePassed >= 168000L;
        }
        return false;
    }

    public static Vector<Quest> getActiveQuests(EntityPlayer player) {
        Vector<Quest> quests = new Vector<Quest>();
        PlayerQuestData data = PlayerDataController.instance.getQuestData(player);
        for (QuestData questdata : data.activeQuests.values()) {
            if (questdata.quest == null) continue;
            quests.add(questdata.quest);
        }
        return quests;
    }
}

