/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.controllers.Availability;

public class RecipeCarpentry
implements IRecipe {
    public int id = -1;
    public String name = "";
    public int recipeWidth = 4;
    public int recipeHeight = 4;
    private ItemStack[] recipeItems = new ItemStack[16];
    public ItemStack recipeOutput;
    public Availability availability = new Availability();
    public boolean isGlobal = false;
    public boolean ignoreDamage = false;

    public RecipeCarpentry() {
    }

    public RecipeCarpentry(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public void readNBT(NBTTagCompound compound) {
        this.id = compound.func_74762_e("ID");
        this.recipeWidth = compound.func_74762_e("Width");
        this.recipeHeight = compound.func_74762_e("Height");
        this.recipeOutput = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("Item"));
        this.recipeItems = NBTTags.getItemStackArray(compound.func_150295_c("Materials", 10));
        this.availability.readFromNBT(compound.func_74775_l("Availability"));
        this.ignoreDamage = compound.func_74767_n("IgnoreDamage");
        this.name = compound.func_74779_i("Name");
        this.isGlobal = compound.func_74767_n("Global");
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74768_a("Width", this.recipeWidth);
        compound.func_74768_a("Height", this.recipeHeight);
        if (this.recipeOutput != null) {
            compound.func_74782_a("Item", (NBTBase)this.recipeOutput.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Materials", (NBTBase)NBTTags.nbtItemStackArray(this.recipeItems));
        compound.func_74782_a("Availability", (NBTBase)this.availability.writeToNBT(new NBTTagCompound()));
        compound.func_74778_a("Name", this.name);
        compound.func_74757_a("Global", this.isGlobal);
        compound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        return compound;
    }

    public boolean func_77569_a(InventoryCrafting par1InventoryCrafting, World world) {
        for (int var2 = 0; var2 <= 4 - this.recipeWidth; ++var2) {
            for (int var3 = 0; var3 <= 4 - this.recipeHeight; ++var3) {
                if (this.checkMatch(par1InventoryCrafting, var2, var3, true)) {
                    return true;
                }
                if (!this.checkMatch(par1InventoryCrafting, var2, var3, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting par1InventoryCrafting, int par2, int par3, boolean par4) {
        for (int var5 = 0; var5 < 4; ++var5) {
            for (int var6 = 0; var6 < 4; ++var6) {
                ItemStack var10;
                int var7 = var5 - par2;
                int var8 = var6 - par3;
                ItemStack var9 = null;
                if (var7 >= 0 && var8 >= 0 && var7 < this.recipeWidth && var8 < this.recipeHeight) {
                    var9 = par4 ? this.recipeItems[this.recipeWidth - var7 - 1 + var8 * this.recipeWidth] : this.recipeItems[var7 + var8 * this.recipeWidth];
                }
                if ((var10 = par1InventoryCrafting.func_70463_b(var5, var6)) == null && var9 == null || NoppesUtilPlayer.compareItems(var9, var10, this.ignoreDamage)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        if (this.recipeOutput == null) {
            return null;
        }
        return this.recipeOutput.func_77946_l();
    }

    public int func_77570_a() {
        return 16;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public void addRecipe(ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        int var9;
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (par2ArrayOfObj[var4] instanceof String[]) {
            String[] var7;
            String[] var8 = var7 = (String[])par2ArrayOfObj[var4++];
            var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String var11 = var8[var10];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        } else {
            while (par2ArrayOfObj[var4] instanceof String) {
                String var13 = (String)par2ArrayOfObj[var4++];
                ++var6;
                var5 = var13.length();
                var3 = var3 + var13;
            }
        }
        HashMap<Character, ItemStack> var14 = new HashMap<Character, ItemStack>();
        while (var4 < par2ArrayOfObj.length) {
            Character var16 = (Character)par2ArrayOfObj[var4];
            ItemStack var17 = null;
            if (par2ArrayOfObj[var4 + 1] instanceof Item) {
                var17 = new ItemStack((Item)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof Block) {
                var17 = new ItemStack((Block)par2ArrayOfObj[var4 + 1], 1, -1);
            } else if (par2ArrayOfObj[var4 + 1] instanceof ItemStack) {
                var17 = (ItemStack)par2ArrayOfObj[var4 + 1];
            }
            var14.put(var16, var17);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (var9 = 0; var9 < var5 * var6; ++var9) {
            char var18 = var3.charAt(var9);
            var15[var9] = var14.containsKey(Character.valueOf(var18)) ? ((ItemStack)var14.get(Character.valueOf(var18))).func_77946_l() : null;
        }
        this.recipeOutput = par1ItemStack;
        this.recipeItems = var15;
        this.recipeWidth = var5;
        this.recipeHeight = var6;
        if (var5 == 4 || var6 == 4) {
            this.isGlobal = false;
        }
    }

    public ItemStack getCraftingItem(int i) {
        if (this.recipeItems == null || i >= this.recipeItems.length) {
            return null;
        }
        return this.recipeItems[i];
    }

    public void setCraftingItem(int i, ItemStack item) {
        if (i < this.recipeItems.length) {
            this.recipeItems[i] = item;
        }
    }

    public void clear() {
        this.recipeOutput = null;
        this.recipeItems = new ItemStack[16];
    }
}

